#include "Commands_ActorValue.h"
#include "ParamInfos.h"
#include "Script.h"

#if OBLIVION

#include "GameObjects.h"
#include "GameExtraData.h"
#include "GameAPI.h"
#include "GameForms.h"
#include "ArrayVar.h"
#include "ScriptUtils.h"

static bool Cmd_GetSkillUseIncrement_Execute(COMMAND_ARGS)
{
	*result = 0;

	UInt32 valSkill = 0;
	UInt32 whichUse = 0;
	ExtractArgs(paramInfo, arg1, opcodeOffsetPtr, thisObj, arg3, scriptObj, eventList, &valSkill, &whichUse);
	if (!IsSkill(valSkill)) return true;

	TESSkill *skill = TESSkill::SkillForActorVal(valSkill);
	if (skill) {
		*result = (whichUse == 1) ? skill->useValue1 : skill->useValue0;
	}
	return true;
}

static bool Cmd_SetSkillUseIncrement_Execute(COMMAND_ARGS)
{
	*result = 0;
	float nuVal = 0.0;
	UInt32 valSkill = 0;
	UInt32 whichUse = 0;
	ExtractArgs(paramInfo, arg1, opcodeOffsetPtr, thisObj, arg3, scriptObj, eventList, &nuVal, &valSkill, &whichUse);
	if (!IsSkill(valSkill)) return true;

	TESSkill *skill = TESSkill::SkillForActorVal(valSkill);
	if (skill) {
		if (whichUse == 1) {
			skill->useValue1 = nuVal;
		} else skill->useValue0 = nuVal;
	}
	return true;
}


static bool Cmd_GetSkillGoverningAttribute_Execute(COMMAND_ARGS)
{
	*result = -1;
	UInt32 skillCode = 0;

	if (ExtractArgs(PASS_EXTRACT_ARGS, &skillCode) && skillCode >= kActorVal_Armorer && skillCode <= kActorVal_Speechcraft)
	{
		TESSkill* skill = TESSkill::SkillForActorVal(skillCode);
		if (skill)
		{
			*result = skill->attribute;
		}
	}

	return true;
}

static bool Cmd_ActorValueToCode_Execute(COMMAND_ARGS)
{
	UInt32 actorVal = -1;
	ExtractArgs(PASS_EXTRACT_ARGS, &actorVal);
	*result = actorVal;
	return true;
}

static bool Cmd_SetSkillGoverningAttribute_Execute(COMMAND_ARGS)
{
	*result = 0;
	UInt32 skillCode = 0;
	UInt32 attrCode = 0;

	if (ExtractArgs(PASS_EXTRACT_ARGS, &skillCode, &attrCode))
	{
		if (skillCode >= kActorVal_Armorer && skillCode <= kActorVal_Speechcraft && attrCode < kActorVal_Luck)
		{
			TESSkill* skill = TESSkill::SkillForActorVal(skillCode);
			if (skill)
			{
				skill->attribute = attrCode;
				*result = 1;
			}
		}
	}

	return true;
}

static bool Cmd_StringToActorValue_Execute(COMMAND_ARGS)
{
	*result = 0;
	char avString[256] = { 0 };

	if(!ExtractArgs(paramInfo, arg1, opcodeOffsetPtr, thisObj, arg3, scriptObj, eventList, &avString))
		return true;
	
	UInt32 av = GetActorValueForString(avString);
	*result = av;
#if _DEBUG
	Console_Print("%s: %i", avString, av);
#endif
	return true;
}

#endif


static ParamInfo kParams_SkillUseIncrement[2] =
{
	{	"skill", kParamType_ActorValue, 0 },
	{	"index", kParamType_Integer, 1 },
};

CommandInfo kCommandInfo_GetSkillUseIncrement =
{
	"GetSkillUseIncrement",
	"",
	0,
	"returns the skill experience use increment for the specified skill",
	0,
	2,
	kParams_SkillUseIncrement,
	HANDLER(Cmd_GetSkillUseIncrement_Execute),
	Cmd_Default_Parse,
	NULL,
	0
};

static ParamInfo kParams_SkillUseIncrementC[2] =
{
	{	"skill", kParamType_Integer, 0 },
	{	"index", kParamType_Integer, 1 },
};

CommandInfo kCommandInfo_GetSkillUseIncrementC =
{
	"GetSkillUseIncrementC",
	"",
	0,
	"returns the skill experience use increment for the specified skill",
	0,
	2,
	kParams_SkillUseIncrementC,
	HANDLER(Cmd_GetSkillUseIncrement_Execute),
	Cmd_Default_Parse,
	NULL,
	0
};

static ParamInfo kParams_SetSkillUseIncrement[3] =
{
	{	"nuVal", kParamType_Float, 0 },
	{	"skill", kParamType_ActorValue, 0 },
	{	"index", kParamType_Integer, 1 },
};

CommandInfo kCommandInfo_SetSkillUseIncrement =
{
	"SetSkillUseIncrement",
	"",
	0,
	"sets the skill experience use increment for the specified skill",
	0,
	3,
	kParams_SetSkillUseIncrement,
	HANDLER(Cmd_SetSkillUseIncrement_Execute),
	Cmd_Default_Parse,
	NULL,
	0
};

static ParamInfo kParams_SetSkillUseIncrementC[3] =
{
	{	"nuVal", kParamType_Float, 0 },
	{	"skill", kParamType_Integer, 0 },
	{	"index", kParamType_Integer, 1 },
};

CommandInfo kCommandInfo_SetSkillUseIncrementC =
{
	"SetSkillUseIncrementC",
	"",
	0,
	"sets the skill experience use increment for the specified skill",
	0,
	3,
	kParams_SetSkillUseIncrementC,
	HANDLER(Cmd_SetSkillUseIncrement_Execute),
	Cmd_Default_Parse,
	NULL,
	0
};

DEFINE_COMMAND(GetSkillGoverningAttribute, returns the governing attribute of a skill given an actor value, 0, 1, kParams_OneActorValue);
DEFINE_COMMAND(SetSkillGoverningAttribute, sets the governing attribute of a skill, 0, 2, kParams_TwoActorValues);

CommandInfo kCommandInfo_GetSkillGoverningAttributeC =
{
	"GetSkillGoverningAttributeC",
	"",
	0,
	"returns the governing attribute of a skill passed as an actor value code",
	0,
	1,
	kParams_OneInt,
	HANDLER(Cmd_GetSkillGoverningAttribute_Execute),
	Cmd_Default_Parse,
	NULL,
	0
};

CommandInfo kCommandInfo_SetSkillGoverningAttributeC =
{
	"SetSkillGoverningAttributeC",
	"",
	0,
	"sets the governing attribute of a skill",
	0,
	2,
	kParams_TwoInts,
	HANDLER(Cmd_SetSkillGoverningAttribute_Execute),
	Cmd_Default_Parse,
	NULL,
	0
};

CommandInfo kCommandInfo_ActorValueToCode =
{
	"ActorValueToCode",
	"AVtoC",
	0,
	"returns the integer code for an actor value",
	0,
	1,
	kParams_OneActorValue,
	HANDLER(Cmd_ActorValueToCode_Execute),
	Cmd_Default_Parse,
	NULL,
	0
};

CommandInfo kCommandInfo_StringToActorValue =
{
	"StringToActorValue",
	"StringAV",
	0,
	"returns actor value code of the string",
	0,
	1,
	kParams_OneString,
	HANDLER(Cmd_StringToActorValue_Execute),
	Cmd_Default_Parse,
	NULL,
	0
};

