#pragma once

#include "obse/HavokBase.h"
#include "obse/HavokCollision.h"

class hkCharacterProxy;
class hkCharacterState;

enum // hkCharacterStateType
{
	kHKState_OnGround = 0,
	kHKState_Jumping,
	kHKState_InAir,
	kHKState_Climbing,
	kHKState_Flying,
	kHKState_Swimming,
	kHKState_Projectile,	// user state 0
	kHKState_UserState1,
	kHKState_UserState2,	// 8
	kHKState_UserState3,
	kHKState_UserState4,
	kHKState_UserState5,

	kHKState_Max			// C
};

// 3C
class hkCharacterStateManager : public hkReferencedObject
{
public:
	hkCharacterStateManager();
	~hkCharacterStateManager();

	hkCharacterState	* m_registeredState[kHKState_Max];
};

// 10
class hkCharacterContext : public hkReferencedObject
{
public:
	hkCharacterStateManager	* stateMgr;	// 08
	UInt32					hkState;	// 0C - hkCharacterStateType

	bool IsOnGround()
		{	return (hkState == kHKState_OnGround);	}
	bool IsJumping()
		{	return (hkState == kHKState_Jumping);	}
	bool IsInAir()
		{	return (hkState == kHKState_InAir);	}
	bool IsFlying()
		{	return (hkState == kHKState_Flying);	}
};

// 4
class hkCharacterProxyListener
{
	virtual void	Destroy(bool freeMem);
	virtual void	ProcessConstraintsCallback(void * arg0, void * arg1);
	virtual void	ContactPointAddedCallback(hkRootCdPoint * point);
	virtual void	ContactPointRemovedCallback(hkRootCdPoint * point);
	virtual void	CharacterInteractionCallback(hkCharacterProxy * proxy, hkCharacterProxy * otherProxy, hkContactPoint * contact);
	virtual void	ObjectInteractionCallback(hkCharacterProxy * proxy, void * arg1, void * arg2);

//	void	** _vtbl;	// 0
};
