#include "NiNodes.h"

void TextureFormat::InitFromD3DFMT(UInt32 fmt)
{
	typedef void (* _D3DFMTToTextureFormat)(UInt32 d3dfmt, TextureFormat * dst);
	_D3DFMTToTextureFormat D3DFMTToTextureFormat = (_D3DFMTToTextureFormat)0x0076C3B0;

	D3DFMTToTextureFormat(fmt, this);
}

#if OBLIVION_VERSION == OBLIVION_VERSION_1_2_416
static const UInt32 kNiObjectNET_SetNameAddr = 0x006FF420;
#else
#unsupported Oblivion version
#endif

void NiObjectNET::SetName(const char* newName)
{
#if OBLIVION
	ThisStdCall(kNiObjectNET_SetNameAddr, this, newName);
#endif
}
