/*
 * Decompiled with CFR 0.152.
 */
package TES4Plugin;

import TES4Plugin.PluginException;
import TES4Plugin.TES4Plugin;
import TES4Plugin.WorkerTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ConvertTask
extends JDialog
implements ActionListener {
    private JFrame parent;
    private File inFile;
    private File outFile;
    private WorkerTask worker;

    public ConvertTask(JFrame parent, File inFile, File outFile) {
        super(parent, "File Conversion", true);
        this.setDefaultCloseOperation(2);
        this.parent = parent;
        this.inFile = inFile;
        this.outFile = outFile;
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        JButton button = new JButton("Cancel");
        button.setActionCommand("cancel");
        button.addActionListener(this);
        buttonPane.add(button);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setOpaque(true);
        contentPane.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        JLabel label = new JLabel("Converting " + inFile.getName() + " to " + outFile.getName(), 0);
        contentPane.add((Component)label, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.setContentPane(contentPane);
        this.worker = new WorkerThread(this);
    }

    public static void convertFile(JFrame parent, File inFile, File outFile) {
        ConvertTask task = new ConvertTask(parent, inFile, outFile);
        task.worker.start();
        task.pack();
        task.setLocationRelativeTo(parent);
        task.setVisible(true);
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            String action = ae.getActionCommand();
            if (action.equals("convert complete")) {
                this.setVisible(false);
                this.dispose();
                JOptionPane.showMessageDialog(this.parent, this.inFile.getName() + " converted to " + this.outFile.getName(), "File Conversion", 1);
            } else if (action.equals("convert failed")) {
                this.setVisible(false);
                this.dispose();
                Throwable exc = (Throwable)ae.getSource();
                if (exc instanceof PluginException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "Format Error", 0);
                } else if (exc instanceof IOException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "I/O Error", 0);
                } else if (exc instanceof InterruptedException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "Interrupted", 0);
                } else {
                    TES4Plugin.logException("File conversion failed", exc);
                }
            } else if (action.equals("cancel")) {
                this.worker.interrupt();
            }
        }
        catch (Throwable exc) {
            TES4Plugin.logException("Exception while processing action event", exc);
        }
    }

    private class WorkerThread
    extends WorkerTask {
        private Throwable exception;

        public WorkerThread(ActionListener listener) {
            super(listener);
        }

        public void run() {
            block16: {
                FileOutputStream out;
                block15: {
                    FileInputStream in = null;
                    out = null;
                    byte[] buffer = new byte[4096];
                    try {
                        int count;
                        int sep;
                        String name;
                        boolean headerSet = false;
                        if (!ConvertTask.this.inFile.exists() || !ConvertTask.this.inFile.isFile()) {
                            throw new IOException("'" + ConvertTask.this.inFile.getName() + "' does not exist");
                        }
                        if (ConvertTask.this.outFile.exists()) {
                            ConvertTask.this.outFile.delete();
                        }
                        boolean flagValue = (name = ConvertTask.this.outFile.getName()).substring(sep = name.lastIndexOf(46)).equalsIgnoreCase(".esm");
                        in = new FileInputStream(ConvertTask.this.inFile);
                        out = new FileOutputStream(ConvertTask.this.outFile);
                        while ((count = in.read(buffer, 0, 4096)) >= 0) {
                            if (count <= 0) continue;
                            if (!headerSet) {
                                if (count < 20) {
                                    throw new PluginException("'" + ConvertTask.this.inFile.getName() + "' is not a TES4 file");
                                }
                                String type = new String(buffer, 0, 4);
                                if (!type.equals("TES4")) {
                                    throw new PluginException("'" + ConvertTask.this.inFile.getName() + "' is not a TES4 file");
                                }
                                buffer[8] = (byte)(flagValue ? 1 : 0);
                                headerSet = true;
                            }
                            out.write(buffer, 0, count);
                            if (!WorkerThread.interrupted()) continue;
                            throw new InterruptedException("Request canceled");
                        }
                    }
                    catch (Throwable exc) {
                        this.exception = exc;
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Throwable exc) {
                        if (this.exception != null) break block15;
                        this.exception = exc;
                    }
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Throwable exc) {
                    if (this.exception != null) break block16;
                    this.exception = exc;
                }
            }
            if (this.exception != null && ConvertTask.this.outFile.exists()) {
                ConvertTask.this.outFile.delete();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ActionEvent ae = WorkerThread.this.exception == null ? new ActionEvent(this, 1001, "convert complete") : new ActionEvent(WorkerThread.this.exception, 1001, "convert failed");
                    WorkerThread.this.getListener().actionPerformed(ae);
                }
            });
        }
    }
}

