/*
 * Decompiled with CFR 0.152.
 */
package TES4Plugin;

import TES4Plugin.DisplaySubrecordDialog;
import TES4Plugin.FormInfo;
import TES4Plugin.Plugin;
import TES4Plugin.PluginException;
import TES4Plugin.PluginGroup;
import TES4Plugin.PluginRecord;
import TES4Plugin.PluginSubrecord;
import TES4Plugin.SaveTask;
import TES4Plugin.TES4Plugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DisplayDialog
extends JDialog
implements ActionListener,
TreeExpansionListener {
    private Plugin plugin;
    private File pluginFile;
    private JTree pluginTree;
    private boolean pluginModified = false;
    private Plugin clipboard;
    private File clipboardFile;
    private JTree clipboardTree;
    Map<Integer, PluginRecord> clipboardMap;
    private boolean clipboardModified = false;

    public DisplayDialog(JFrame parent, File pluginFile, Plugin plugin) {
        super(parent, pluginFile.getName(), true);
        this.setDefaultCloseOperation(2);
        this.pluginFile = pluginFile;
        this.plugin = plugin;
        this.clipboardFile = new File(pluginFile.getParent() + "\\TES4Plugin Clipboard.esp");
        this.clipboard = new Plugin(this.clipboardFile, plugin.getCreator(), plugin.getSummary(), plugin.getMasterList());
        this.clipboard.createInitialGroups();
        this.clipboardMap = new HashMap<Integer, PluginRecord>(50);
        this.pluginTree = new JTree(this.createPluginNodes(plugin));
        this.pluginTree.setScrollsOnExpand(true);
        this.pluginTree.addTreeExpansionListener(this);
        JScrollPane pluginScrollPane = new JScrollPane(this.pluginTree);
        pluginScrollPane.setHorizontalScrollBarPolicy(32);
        pluginScrollPane.setVerticalScrollBarPolicy(22);
        pluginScrollPane.setPreferredSize(new Dimension(380, 380));
        this.clipboardTree = new JTree(this.createPluginNodes(this.clipboard));
        this.clipboardTree.setScrollsOnExpand(true);
        this.clipboardTree.setSelectionModel(null);
        this.clipboardTree.addTreeExpansionListener(this);
        JScrollPane clipboardScrollPane = new JScrollPane(this.clipboardTree);
        clipboardScrollPane.setHorizontalScrollBarPolicy(32);
        clipboardScrollPane.setVerticalScrollBarPolicy(22);
        clipboardScrollPane.setPreferredSize(new Dimension(380, 380));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 1));
        buttonPane.setBackground(new Color(240, 240, 240));
        JButton button = new JButton("Copy (Alt-C)");
        button.setActionCommand("copy");
        button.setMnemonic(67);
        button.setHorizontalAlignment(0);
        button.addActionListener(this);
        JPanel paddedButton = new JPanel();
        paddedButton.setLayout(new BoxLayout(paddedButton, 0));
        paddedButton.setOpaque(false);
        paddedButton.add(button);
        buttonPane.add(paddedButton);
        buttonPane.add(Box.createVerticalStrut(10));
        button = new JButton("Display (Alt-D)");
        button.setActionCommand("display");
        button.setMnemonic(68);
        button.setHorizontalAlignment(0);
        button.addActionListener(this);
        paddedButton = new JPanel();
        paddedButton.setLayout(new BoxLayout(paddedButton, 0));
        paddedButton.setOpaque(false);
        paddedButton.add(button);
        buttonPane.add(paddedButton);
        buttonPane.add(Box.createVerticalStrut(10));
        button = new JButton("Toggle Ignore (Alt-I)");
        button.setActionCommand("toggle");
        button.setMnemonic(73);
        button.setHorizontalAlignment(0);
        button.addActionListener(this);
        paddedButton = new JPanel();
        paddedButton.setLayout(new BoxLayout(paddedButton, 0));
        paddedButton.setOpaque(false);
        paddedButton.add(button);
        buttonPane.add(paddedButton);
        JPanel actionPane = new JPanel();
        actionPane.setLayout(new BoxLayout(actionPane, 1));
        actionPane.setBackground(new Color(240, 240, 240));
        actionPane.add(Box.createGlue());
        actionPane.add(buttonPane);
        actionPane.add(Box.createGlue());
        JPanel treePane = new JPanel();
        treePane.setLayout(new BoxLayout(treePane, 0));
        treePane.setOpaque(true);
        treePane.setBackground(new Color(240, 240, 240));
        treePane.add(pluginScrollPane);
        treePane.add(Box.createHorizontalStrut(5));
        treePane.add(actionPane);
        treePane.add(Box.createHorizontalStrut(5));
        treePane.add(clipboardScrollPane);
        buttonPane = new JPanel();
        buttonPane.setBackground(new Color(240, 240, 240));
        button = new JButton("Save Plugin");
        button.setActionCommand("save plugin");
        button.setHorizontalAlignment(0);
        button.addActionListener(this);
        buttonPane.add(button);
        buttonPane.add(Box.createHorizontalStrut(10));
        button = new JButton("Save Clipboard");
        button.setActionCommand("save clipboard");
        button.setHorizontalAlignment(0);
        button.addActionListener(this);
        buttonPane.add(button);
        buttonPane.add(Box.createHorizontalStrut(10));
        button = new JButton("Done");
        button.setActionCommand("done");
        button.setHorizontalAlignment(0);
        button.addActionListener(this);
        buttonPane.add(button);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.setOpaque(true);
        contentPane.setBackground(new Color(240, 240, 240));
        contentPane.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        contentPane.add(treePane);
        contentPane.add(Box.createVerticalStrut(15));
        contentPane.add(buttonPane);
        this.setContentPane(contentPane);
        this.addWindowListener(new DialogWindowListener());
    }

    public static void showDialog(JFrame parent, File pluginFile, Plugin plugin) {
        DisplayDialog dialog = new DisplayDialog(parent, pluginFile, plugin);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            String action = ae.getActionCommand();
            if (action.equals("save plugin")) {
                if (this.pluginModified && SaveTask.savePlugin(this, this.pluginFile, this.plugin)) {
                    this.pluginModified = false;
                    this.validateTree(this.pluginTree);
                }
            } else if (action.equals("save clipboard")) {
                if (this.clipboardModified && SaveTask.savePlugin(this, this.clipboardFile, this.clipboard)) {
                    this.clipboardModified = false;
                    this.validateTree(this.clipboardTree);
                }
            } else if (action.equals("copy")) {
                this.copyRecords();
            } else if (action.equals("display")) {
                this.displaySubrecordData();
            } else if (action.equals("toggle")) {
                this.toggleIgnore();
            } else if (action.equals("done")) {
                this.closeDialog();
                this.setVisible(false);
                this.dispose();
            }
        }
        catch (Throwable exc) {
            TES4Plugin.logException("Exception while processing action event", exc);
        }
    }

    private void closeDialog() {
        int selection;
        if (this.pluginModified && (selection = JOptionPane.showConfirmDialog(this, "The plugin has been modified. Do you want to save the changes?", "Plugin Modified", 0, 3)) == 0) {
            SaveTask.savePlugin(this, this.pluginFile, this.plugin);
        }
        if (this.clipboardModified && (selection = JOptionPane.showConfirmDialog(this, "The clipboard has been modified. Do you want to save the changes?", "Clipboard Modified", 0, 3)) == 0) {
            SaveTask.savePlugin(this, this.clipboardFile, this.clipboard);
        }
    }

    private void toggleIgnore() {
        TreePath[] treePaths = this.pluginTree.getSelectionPaths();
        if (treePaths == null) {
            JOptionPane.showMessageDialog(this, "You must select at least one record.", "Error", 0);
        } else {
            for (TreePath treePath : treePaths) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Object userObject = node.getUserObject();
                if (userObject instanceof Plugin) {
                    JOptionPane.showMessageDialog(this, "The entire plugin can not be selected.  The selection will be ignored.", "Warning", 2);
                    continue;
                }
                if (userObject instanceof PluginGroup) {
                    this.toggleGroupIgnore(treePath, node);
                    continue;
                }
                if (userObject instanceof PluginRecord) {
                    this.toggleRecordIgnore(treePath, (PluginRecord)userObject);
                    continue;
                }
                JOptionPane.showMessageDialog(this, "A subrecord can not be ignored.  The selection will be ignored.", "Warning", 2);
            }
        }
    }

    private void toggleGroupIgnore(TreePath groupPath, DefaultMutableTreeNode groupNode) {
        Enumeration<TreeNode> nodes = groupNode.children();
        while (nodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
            TreePath treePath = groupPath.pathByAddingChild(node);
            Object userObject = node.getUserObject();
            if (userObject instanceof PluginGroup) {
                this.toggleGroupIgnore(treePath, node);
                continue;
            }
            if (!(userObject instanceof PluginRecord)) continue;
            this.toggleRecordIgnore(treePath, (PluginRecord)userObject);
        }
    }

    private void toggleRecordIgnore(TreePath treePath, PluginRecord record) {
        int pathCount;
        DefaultMutableTreeNode node;
        Object userObject;
        Integer objFormID;
        Map<Integer, FormInfo> formMap;
        record.setIgnore(!record.isIgnored());
        this.pluginTree.getModel().valueForPathChanged(treePath, record);
        this.pluginModified = true;
        if (!record.isIgnored() && (formMap = this.plugin.getFormMap()).get(objFormID = new Integer(record.getFormID())) == null && (userObject = (node = (DefaultMutableTreeNode)treePath.getPathComponent((pathCount = treePath.getPathCount()) - 2)).getUserObject()) instanceof PluginGroup) {
            PluginGroup group = (PluginGroup)userObject;
            FormInfo formInfo = new FormInfo(record, record.getRecordType(), record.getFormID(), record.getEditorID());
            formInfo.setParentFormID(group.getGroupParentID());
            this.plugin.getFormList().add(formInfo);
            formMap.put(objFormID, formInfo);
        }
    }

    private void copyRecords() throws DataFormatException, IOException, PluginException {
        TreePath[] treePaths = this.pluginTree.getSelectionPaths();
        if (treePaths == null) {
            JOptionPane.showMessageDialog(this, "You must select at least one record to copy.", "Error", 0);
            return;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)this.clipboardTree.getModel();
        for (TreePath treePath : treePaths) {
            DefaultMutableTreeNode pathNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object pathObject = pathNode.getUserObject();
            if (pathObject instanceof Plugin) {
                JOptionPane.showMessageDialog(this, "The entire plugin can not be selected.  The selection will be ignored.", "Warning", 2);
                continue;
            }
            if (pathObject instanceof PluginSubrecord) {
                JOptionPane.showMessageDialog(this, "An individual subrecord can not be copied.  The selection will be ignored.", "Warning", 2);
                continue;
            }
            if (treePath.getPathCount() == 2) {
                PluginGroup pathGroup = (PluginGroup)pathObject;
                String groupRecordType = pathGroup.getGroupRecordType();
                DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
                int childCount = rootNode.getChildCount();
                DefaultMutableTreeNode parentNode = null;
                boolean foundGroup = false;
                for (int i = 0; i < childCount; ++i) {
                    parentNode = (DefaultMutableTreeNode)rootNode.getChildAt(i);
                    PluginGroup group = (PluginGroup)parentNode.getUserObject();
                    if (!group.getGroupRecordType().equals(groupRecordType)) continue;
                    foundGroup = true;
                    break;
                }
                if (!foundGroup) {
                    throw new PluginException("Clipboard " + groupRecordType + " group not found");
                }
                List<PluginRecord> pathRecordList = pathGroup.getRecordList();
                for (PluginRecord record : pathRecordList) {
                    if (record instanceof PluginGroup) {
                        this.copyGroup(treeModel, parentNode, (PluginGroup)record);
                        continue;
                    }
                    this.copyRecord(treeModel, parentNode, record);
                }
                continue;
            }
            PluginRecord pathRecord = (PluginRecord)pathObject;
            DefaultMutableTreeNode parentNode = this.createHierarchy(treeModel, pathRecord);
            if (pathRecord instanceof PluginGroup) {
                this.copyGroup(treeModel, parentNode, (PluginGroup)pathRecord);
                continue;
            }
            this.copyRecord(treeModel, parentNode, pathRecord);
        }
    }

    private DefaultMutableTreeNode createHierarchy(DefaultTreeModel treeModel, PluginRecord record) throws DataFormatException, IOException, PluginException {
        PluginGroup group;
        boolean foundGroup;
        int childCount;
        DefaultMutableTreeNode parentNode = null;
        int[] childIndices = new int[1];
        PluginGroup parentGroup = (PluginGroup)record.getParent();
        if (parentGroup == null) {
            if (record instanceof PluginGroup) {
                throw new PluginException(String.format("Type %d group does not have a parent", ((PluginGroup)record).getGroupType()));
            }
            throw new PluginException(String.format("%s record %s (%08X) does not have a parent", record.getRecordType(), record.getEditorID(), record.getFormID()));
        }
        int groupType = parentGroup.getGroupType();
        if (groupType == 0) {
            String groupRecordType = parentGroup.getGroupRecordType();
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
            childCount = rootNode.getChildCount();
            foundGroup = false;
            for (int i = 0; i < childCount; ++i) {
                parentNode = (DefaultMutableTreeNode)rootNode.getChildAt(i);
                PluginGroup clipboardGroup = (PluginGroup)parentNode.getUserObject();
                if (!clipboardGroup.getGroupRecordType().equals(groupRecordType)) continue;
                foundGroup = true;
                break;
            }
            if (!foundGroup) {
                throw new PluginException("Clipboard " + groupRecordType + " group not found");
            }
        } else {
            DefaultMutableTreeNode grandparentNode = this.createHierarchy(treeModel, parentGroup);
            byte[] groupLabel = parentGroup.getGroupLabel();
            childCount = grandparentNode.getChildCount();
            foundGroup = false;
            for (int i = 0; i < childCount; ++i) {
                parentNode = (DefaultMutableTreeNode)grandparentNode.getChildAt(i);
                PluginRecord clipboardRecord = (PluginRecord)parentNode.getUserObject();
                if (!(clipboardRecord instanceof PluginGroup)) continue;
                PluginGroup checkGroup = (PluginGroup)clipboardRecord;
                int checkType = checkGroup.getGroupType();
                byte[] checkLabel = checkGroup.getGroupLabel();
                if (checkType != groupType || checkLabel[0] != groupLabel[0] || checkLabel[1] != groupLabel[1] || checkLabel[2] != groupLabel[2] || checkLabel[3] != groupLabel[3]) continue;
                foundGroup = true;
                break;
            }
            if (!foundGroup) {
                PluginGroup grandparentGroup = (PluginGroup)grandparentNode.getUserObject();
                List<PluginRecord> clipboardRecordList = grandparentGroup.getRecordList();
                PluginGroup clipboardGroup = parentGroup.createEmptyGroup();
                clipboardGroup.setParent(grandparentGroup);
                clipboardRecordList.add(clipboardGroup);
                parentNode = new DefaultMutableTreeNode(clipboardGroup);
                childIndices[0] = grandparentNode.getChildCount();
                grandparentNode.add(parentNode);
                treeModel.nodesWereInserted(grandparentNode, childIndices);
                this.clipboardModified = true;
            }
        }
        if (record instanceof PluginGroup && ((groupType = (group = (PluginGroup)record).getGroupType()) == 1 || groupType == 6 || groupType == 7)) {
            List<PluginRecord> recordList = parentGroup.getRecordList();
            int recordCount = recordList.size();
            for (int index = 1; index < recordCount; ++index) {
                if (recordList.get(index) != group) continue;
                PluginRecord prevRecord = recordList.get(index - 1);
                String recordType = prevRecord.getRecordType();
                if (!recordType.equals("WRLD") && !recordType.equals("CELL") && !recordType.equals("DIAL") || group.getGroupParentID() != prevRecord.getFormID()) break;
                this.copyRecord(treeModel, parentNode, prevRecord);
                break;
            }
        }
        return parentNode;
    }

    private void copyGroup(DefaultTreeModel treeModel, DefaultMutableTreeNode parentClipboardNode, PluginGroup group) throws DataFormatException, IOException, PluginException {
        int groupType = group.getGroupType();
        byte[] groupLabel = group.getGroupLabel();
        int childCount = parentClipboardNode.getChildCount();
        DefaultMutableTreeNode clipboardNode = null;
        boolean foundGroup = false;
        for (int index = 0; index < childCount; ++index) {
            byte[] checkLabel;
            PluginGroup checkGroup;
            clipboardNode = (DefaultMutableTreeNode)parentClipboardNode.getChildAt(index);
            Object userObject = clipboardNode.getUserObject();
            if (!(userObject instanceof PluginGroup) || (checkGroup = (PluginGroup)userObject).getGroupType() != groupType || groupLabel[0] != (checkLabel = checkGroup.getGroupLabel())[0] || groupLabel[1] != checkLabel[1] || groupLabel[2] != checkLabel[2] || groupLabel[3] != checkLabel[3]) continue;
            foundGroup = true;
            break;
        }
        if (!foundGroup) {
            PluginGroup clipboardGroup = group.createEmptyGroup();
            PluginGroup parentClipboardGroup = (PluginGroup)parentClipboardNode.getUserObject();
            clipboardGroup.setParent(parentClipboardGroup);
            parentClipboardGroup.getRecordList().add(clipboardGroup);
            clipboardNode = new DefaultMutableTreeNode(clipboardGroup);
            int[] childIndices = new int[]{childCount};
            parentClipboardNode.add(clipboardNode);
            treeModel.nodesWereInserted(parentClipboardNode, childIndices);
            this.clipboardModified = true;
        }
        List<PluginRecord> recordList = group.getRecordList();
        for (PluginRecord record : recordList) {
            if (record instanceof PluginGroup) {
                this.copyGroup(treeModel, clipboardNode, (PluginGroup)record);
                continue;
            }
            this.copyRecord(treeModel, clipboardNode, record);
        }
    }

    private void copyRecord(DefaultTreeModel treeModel, DefaultMutableTreeNode parentClipboardNode, PluginRecord record) throws DataFormatException, IOException, PluginException {
        PluginGroup group;
        int groupType;
        PluginRecord nextRecord;
        PluginGroup parentGroup;
        List<PluginRecord> recordList;
        int index;
        int[] childIndices = new int[1];
        PluginGroup parentClipboardGroup = (PluginGroup)parentClipboardNode.getUserObject();
        List<PluginRecord> clipboardRecordList = parentClipboardGroup.getRecordList();
        if (clipboardRecordList.contains(record)) {
            return;
        }
        PluginRecord clipboardRecord = (PluginRecord)record.clone();
        clipboardRecord.setParent(parentClipboardGroup);
        clipboardRecordList.add(clipboardRecord);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(clipboardRecord);
        this.createRecordChildren(node, clipboardRecord);
        this.clipboardMap.put(new Integer(clipboardRecord.getFormID()), clipboardRecord);
        childIndices[0] = parentClipboardNode.getChildCount();
        parentClipboardNode.add(node);
        treeModel.nodesWereInserted(parentClipboardNode, childIndices);
        this.clipboardModified = true;
        String recordType = record.getRecordType();
        if ((recordType.equals("WRLD") || recordType.equals("CELL") || recordType.equals("DIAL")) && (index = (recordList = (parentGroup = (PluginGroup)record.getParent()).getRecordList()).indexOf(record)) >= 0 && index < recordList.size() - 1 && (nextRecord = recordList.get(index + 1)) instanceof PluginGroup && ((groupType = (group = (PluginGroup)nextRecord).getGroupType()) == 1 || groupType == 6 || groupType == 7) && group.getGroupParentID() == record.getFormID()) {
            PluginGroup clipboardGroup = group.createEmptyGroup();
            clipboardGroup.setParent(parentClipboardGroup);
            clipboardRecordList.add(clipboardGroup);
            node = new DefaultMutableTreeNode(clipboardGroup);
            childIndices[0] = parentClipboardNode.getChildCount();
            parentClipboardNode.add(node);
            treeModel.nodesWereInserted(parentClipboardNode, childIndices);
            this.clipboardModified = true;
        }
        this.copyRecordReferences(record);
    }

    private void copyRecordReferences(PluginRecord record) throws DataFormatException, IOException, PluginException {
        List<String> masterList = this.plugin.getMasterList();
        Map<Integer, FormInfo> formMap = this.plugin.getFormMap();
        DefaultTreeModel treeModel = (DefaultTreeModel)this.clipboardTree.getModel();
        List<PluginSubrecord> subrecordList = record.getSubrecords();
        for (PluginSubrecord subrecord : subrecordList) {
            int[][] references = subrecord.getReferences();
            if (references == null) continue;
            for (int i = 0; i < references.length; ++i) {
                FormInfo formInfo;
                Integer objFormID;
                int masterID;
                int formID = references[i][1];
                if (formID == 0 || (masterID = formID >>> 24) < masterList.size() || this.clipboardMap.get(objFormID = new Integer(formID)) != null || (formInfo = formMap.get(objFormID)) == null) continue;
                PluginRecord refRecord = (PluginRecord)formInfo.getSource();
                DefaultMutableTreeNode parentNode = this.createHierarchy(treeModel, refRecord);
                this.copyRecord(treeModel, parentNode, refRecord);
            }
        }
    }

    private void displaySubrecordData() {
        Object userObject;
        DefaultMutableTreeNode node;
        TreePath[] treePaths = this.pluginTree.getSelectionPaths();
        if (treePaths == null) {
            JOptionPane.showMessageDialog(this, "You must select a subrecord to display.", "Error", 0);
            return;
        }
        for (TreePath treePath : treePaths) {
            node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            userObject = node.getUserObject();
            if (userObject instanceof PluginSubrecord) continue;
            JOptionPane.showMessageDialog(this, "Only subrecord may be displayed.", "Error", 0);
            return;
        }
        for (TreePath treePath : treePaths) {
            node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            userObject = node.getUserObject();
            DisplaySubrecordDialog.showDialog(this, (PluginSubrecord)userObject);
        }
    }

    private DefaultMutableTreeNode createPluginNodes(Plugin plugin) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(plugin);
        try {
            List<PluginGroup> groupList = plugin.getGroupList();
            for (PluginGroup group : groupList) {
                DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode(group);
                this.createGroupChildren(groupNode, group);
                root.add(groupNode);
            }
        }
        catch (Throwable exc) {
            TES4Plugin.logException("Exception while creating display nodes", exc);
        }
        return root;
    }

    private void createGroupChildren(DefaultMutableTreeNode groupNode, PluginGroup group) throws DataFormatException, IOException, PluginException {
        List<PluginRecord> recordList = group.getRecordList();
        for (PluginRecord record : recordList) {
            DefaultMutableTreeNode recordNode = new DefaultMutableTreeNode(record);
            boolean insertNode = false;
            int index = 0;
            if (record instanceof PluginGroup) {
                this.createGroupChildren(recordNode, (PluginGroup)record);
            } else {
                String groupRecordType;
                if (record.getRecordLength() != 0) {
                    recordNode.add(new DefaultMutableTreeNode(null));
                }
                if (!(group.getGroupType() != 0 || (groupRecordType = group.getGroupRecordType()).equals("WRLD") || groupRecordType.equals("CELL") || groupRecordType.equals("DIAL"))) {
                    String editorID = record.getEditorID();
                    Enumeration<TreeNode> nodes = groupNode.children();
                    while (nodes.hasMoreElements()) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
                        PluginRecord nodeRecord = (PluginRecord)node.getUserObject();
                        String nodeEditorID = nodeRecord.getEditorID();
                        if (nodeEditorID != null && editorID.compareToIgnoreCase(nodeEditorID) < 0) {
                            insertNode = true;
                            break;
                        }
                        ++index;
                    }
                }
            }
            if (insertNode) {
                groupNode.insert(recordNode, index);
                continue;
            }
            groupNode.add(recordNode);
        }
    }

    private void createRecordChildren(DefaultMutableTreeNode recordNode, PluginRecord record) throws DataFormatException, IOException, PluginException {
        List<PluginSubrecord> subrecordList = record.getSubrecords();
        for (PluginSubrecord subrecord : subrecordList) {
            subrecord.setSpillMode(true);
            DefaultMutableTreeNode subrecordNode = new DefaultMutableTreeNode(subrecord);
            recordNode.add(subrecordNode);
        }
    }

    private void validateTree(JTree tree) {
        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        Enumeration<TreeNode> nodes = root.children();
        while (nodes.hasMoreElements()) {
            boolean subtreeChanged;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof PluginGroup) || !(subtreeChanged = this.validateTreeGroup(treeModel, node, (PluginGroup)userObject))) continue;
            treeModel.nodeStructureChanged(node);
        }
    }

    private boolean validateTreeGroup(DefaultTreeModel treeModel, DefaultMutableTreeNode groupNode, PluginGroup parentGroup) {
        boolean nodeStructureChanged = false;
        int index = 0;
        while (index < groupNode.getChildCount()) {
            PluginRecord record;
            boolean removeNode = false;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)groupNode.getChildAt(index);
            Object userObject = node.getUserObject();
            if (userObject instanceof PluginGroup) {
                PluginGroup group = (PluginGroup)userObject;
                boolean subtreeChanged = this.validateTreeGroup(treeModel, node, group);
                if (subtreeChanged) {
                    nodeStructureChanged = true;
                }
                if (group.isEmpty()) {
                    List<PluginRecord> recordList = parentGroup.getRecordList();
                    removeNode = true;
                    for (PluginRecord groupRecord : recordList) {
                        if (groupRecord != group) continue;
                        removeNode = false;
                        break;
                    }
                }
            } else if (userObject instanceof PluginRecord && (record = (PluginRecord)userObject).isIgnored()) {
                removeNode = true;
            }
            if (removeNode) {
                groupNode.remove(index);
                nodeStructureChanged = true;
                continue;
            }
            ++index;
        }
        return nodeStructureChanged;
    }

    public void treeExpanded(TreeExpansionEvent event) {
        JTree tree = (JTree)event.getSource();
        TreePath treePath = event.getPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object userObject = node.getUserObject();
        if (userObject instanceof PluginRecord && !(userObject instanceof PluginGroup)) {
            PluginRecord record = (PluginRecord)userObject;
            DefaultMutableTreeNode subrecordNode = (DefaultMutableTreeNode)node.getFirstChild();
            if (subrecordNode.getUserObject() == null) {
                try {
                    node.removeAllChildren();
                    this.createRecordChildren(node, record);
                    DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
                    model.nodeStructureChanged(node);
                }
                catch (Exception exc) {
                    TES4Plugin.logException("Exception while creating subrecords", exc);
                }
            }
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    private class DialogWindowListener
    extends WindowAdapter {
        public void windowClosing(WindowEvent we) {
            DisplayDialog.this.closeDialog();
        }
    }
}

