/*
 * Decompiled with CFR 0.152.
 */
package TES4Plugin;

import java.text.ParseException;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;

public final class EditInputVerifier
extends InputVerifier {
    private boolean optionalField;

    public EditInputVerifier(boolean optionalField) {
        this.optionalField = optionalField;
    }

    public boolean verify(JComponent input) {
        JFormattedTextField textField;
        JFormattedTextField.AbstractFormatter formatter;
        boolean allow = true;
        if (input instanceof JFormattedTextField && (formatter = (textField = (JFormattedTextField)input).getFormatter()) != null) {
            String value = textField.getText();
            if (value.length() != 0) {
                try {
                    formatter.stringToValue(value);
                }
                catch (ParseException exc) {
                    allow = false;
                }
            } else if (!this.optionalField) {
                allow = false;
            }
        }
        return allow;
    }

    public boolean shouldYieldFocus(JComponent input) {
        boolean allow = this.verify(input);
        if (!allow) {
            UIManager.getLookAndFeel().provideErrorFeedback(input);
        }
        return allow;
    }
}

