/*
 * Decompiled with CFR 0.152.
 */
package TES4Plugin;

import TES4Plugin.PluginException;
import TES4Plugin.PluginHeader;
import TES4Plugin.PluginInfo;
import TES4Plugin.TES4Plugin;
import TES4Plugin.WorkerTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class EditTask
extends JDialog
implements ActionListener {
    private JFrame parent;
    private File inFile;
    private PluginInfo pluginInfo;
    private WorkerTask worker;

    public EditTask(JFrame parent, File inFile, PluginInfo pluginInfo) {
        super(parent, "Edit Description", true);
        this.setDefaultCloseOperation(2);
        this.parent = parent;
        this.inFile = inFile;
        this.pluginInfo = pluginInfo;
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        JButton button = new JButton("Cancel");
        button.setActionCommand("cancel");
        button.addActionListener(this);
        buttonPane.add(button);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setOpaque(true);
        contentPane.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        JLabel label = new JLabel("Updating " + inFile.getName(), 0);
        contentPane.add((Component)label, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.setContentPane(contentPane);
        this.worker = new WorkerThread(this);
    }

    public static void editFile(JFrame parent, File inFile, PluginInfo pluginInfo) {
        EditTask task = new EditTask(parent, inFile, pluginInfo);
        task.worker.start();
        task.pack();
        task.setLocationRelativeTo(parent);
        task.setVisible(true);
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            String action = ae.getActionCommand();
            if (action.equals("copy complete")) {
                this.setVisible(false);
                this.dispose();
                JOptionPane.showMessageDialog(this.parent, this.inFile.getName() + " updated", "File Copied", 1);
            } else if (action.equals("copy failed")) {
                this.setVisible(false);
                this.dispose();
                Throwable exc = (Throwable)ae.getSource();
                if (exc instanceof PluginException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "Format Error", 0);
                } else if (exc instanceof IOException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "I/O Error", 0);
                } else if (exc instanceof InterruptedException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "Interrupted", 0);
                } else {
                    TES4Plugin.logException("File copy failed", exc);
                }
            } else if (action.equals("cancel")) {
                this.worker.interrupt();
            }
        }
        catch (Throwable exc) {
            TES4Plugin.logException("Exception while processing action event", exc);
        }
    }

    private class WorkerThread
    extends WorkerTask {
        private Throwable exception;

        public WorkerThread(ActionListener listener) {
            super(listener);
        }

        public void run() {
            File outFile;
            block16: {
                FileOutputStream out;
                block15: {
                    RandomAccessFile in = null;
                    out = null;
                    byte[] buffer = new byte[4096];
                    outFile = new File(EditTask.this.inFile.getParent() + "\\TES4Plugin.tmp");
                    try {
                        int count;
                        if (!EditTask.this.inFile.exists() || !EditTask.this.inFile.isFile()) {
                            throw new IOException("'" + EditTask.this.inFile.getName() + "' does not exist");
                        }
                        if (outFile.exists()) {
                            outFile.delete();
                        }
                        in = new RandomAccessFile(EditTask.this.inFile, "r");
                        out = new FileOutputStream(outFile);
                        PluginHeader inHeader = new PluginHeader(EditTask.this.inFile);
                        inHeader.read(in);
                        PluginHeader outHeader = new PluginHeader(outFile);
                        outHeader.setRecordCount(inHeader.getRecordCount());
                        outHeader.setMaster(inHeader.isMaster());
                        outHeader.setMasterList(inHeader.getMasterList());
                        outHeader.setCreator(EditTask.this.pluginInfo.getCreator());
                        outHeader.setSummary(EditTask.this.pluginInfo.getSummary());
                        outHeader.write(out);
                        while ((count = in.read(buffer, 0, 4096)) >= 0) {
                            if (count > 0) {
                                out.write(buffer, 0, count);
                            }
                            if (!WorkerThread.interrupted()) continue;
                            throw new InterruptedException("Request canceled");
                        }
                    }
                    catch (Throwable exc) {
                        this.exception = exc;
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Throwable exc) {
                        if (this.exception != null) break block15;
                        this.exception = exc;
                    }
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Throwable exc) {
                    if (this.exception != null) break block16;
                    this.exception = exc;
                }
            }
            if (outFile.exists()) {
                if (this.exception != null) {
                    outFile.delete();
                } else {
                    EditTask.this.inFile.delete();
                    outFile.renameTo(EditTask.this.inFile);
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ActionEvent ae = WorkerThread.this.exception == null ? new ActionEvent(this, 1001, "copy complete") : new ActionEvent(WorkerThread.this.exception, 1001, "copy failed");
                    WorkerThread.this.getListener().actionPerformed(ae);
                }
            });
        }
    }
}

