/*
 * Decompiled with CFR 0.152.
 */
package TES4Plugin;

import TES4Plugin.FormInfo;
import TES4Plugin.Master;
import TES4Plugin.Plugin;
import TES4Plugin.PluginException;
import TES4Plugin.PluginGroup;
import TES4Plugin.PluginNPC;
import TES4Plugin.PluginQuest;
import TES4Plugin.PluginRace;
import TES4Plugin.PluginRecord;
import TES4Plugin.PluginSubrecord;
import TES4Plugin.PluginTopic;
import TES4Plugin.TES4Plugin;
import TES4Plugin.WorkerTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GenerateTask
extends JDialog
implements ActionListener {
    private JFrame parent;
    private File pluginFile;
    private JLabel statusLabel;
    private Thread worker;

    public GenerateTask(JFrame parent, File pluginFile) {
        super(parent, "Merge Plugins", true);
        this.setDefaultCloseOperation(2);
        this.parent = parent;
        this.pluginFile = pluginFile;
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        JButton button = new JButton("Cancel");
        button.setActionCommand("cancel");
        button.addActionListener(this);
        buttonPane.add(button);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setOpaque(true);
        contentPane.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        this.statusLabel = new JLabel(" ", 0);
        this.statusLabel.setPreferredSize(new Dimension(320, 12));
        contentPane.add((Component)this.statusLabel, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.setContentPane(contentPane);
        this.worker = new WorkerThread(this);
    }

    public static void generateResponses(JFrame parent, File pluginFile) {
        GenerateTask task = new GenerateTask(parent, pluginFile);
        task.worker.start();
        task.pack();
        task.setLocationRelativeTo(parent);
        task.setVisible(true);
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            String action = ae.getActionCommand();
            if (action.equals("generate complete")) {
                this.setVisible(false);
                this.dispose();
                JOptionPane.showMessageDialog(this.parent, "Response files created for " + this.pluginFile.getName(), "Generate Responses", 1);
            } else if (action.equals("generate failed")) {
                this.setVisible(false);
                this.dispose();
                Throwable exc = (Throwable)ae.getSource();
                if (exc instanceof PluginException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "Format Error", 0);
                } else if (exc instanceof DataFormatException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "Compression Error", 0);
                } else if (exc instanceof IOException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "I/O Error", 0);
                } else if (exc instanceof InterruptedException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "Interrupted", 0);
                } else {
                    TES4Plugin.logException("Generate failed", exc);
                }
            } else if (action.equals("cancel")) {
                this.worker.interrupt();
            }
        }
        catch (Throwable exc) {
            TES4Plugin.logException("Exception while processing action event", exc);
        }
    }

    private class WorkerThread
    extends WorkerTask {
        private Throwable exception;
        private String currentPlugin;
        private Plugin plugin;
        byte[] voiceData;
        List<PluginRace> raceList;
        Map<Integer, PluginRace> raceMap;
        List<PluginNPC> npcList;
        Map<Integer, PluginNPC> npcMap;
        List<PluginQuest> questList;
        Map<Integer, PluginQuest> questMap;
        List<PluginTopic> topicList;
        Map<Integer, PluginTopic> topicMap;

        public WorkerThread(ActionListener listener) {
            super(listener);
        }

        public void run() {
            try {
                PluginTopic topic;
                PluginQuest quest;
                PluginNPC npc;
                PluginRace race;
                URL fileURL = TES4Plugin.class.getResource("TES4Plugin.class");
                if (fileURL == null) {
                    throw new IOException("Unable to locate TES4Plugin class");
                }
                String filePath = fileURL.getPath();
                int sep = filePath.indexOf(58);
                if (sep < 1) {
                    throw new IOException("TES4Plugin class path is not valid");
                }
                String protocol = filePath.substring(0, sep);
                if (!protocol.equals("file")) {
                    throw new IOException("TES4Plugin class path protocol is not valid");
                }
                sep = filePath.indexOf(33);
                if (sep < 9 || filePath.charAt(5) != '/') {
                    throw new IOException("TES4Plugin jar path is not valid");
                }
                String uriString = filePath.substring(0, sep = filePath.lastIndexOf(47, sep));
                URI fileURI = new URI(uriString);
                File voiceFile = new File((filePath = fileURI.getPath().substring(1)) + "/TES4Plugin-Silence.mp3");
                if (!voiceFile.exists() || !voiceFile.isFile()) {
                    throw new IOException("'" + voiceFile.getPath() + "' does not exist");
                }
                this.voiceData = new byte[(int)voiceFile.length()];
                FileInputStream in = new FileInputStream(voiceFile);
                in.read(this.voiceData);
                in.close();
                this.currentPlugin = GenerateTask.this.pluginFile.getName();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GenerateTask.this.statusLabel.setText("Loading " + WorkerThread.this.currentPlugin);
                    }
                });
                this.plugin = new Plugin(GenerateTask.this.pluginFile);
                this.plugin.load(this);
                List<PluginGroup> groupList = this.plugin.getGroupList();
                List<String> masterList = this.plugin.getMasterList();
                Master[] masters = new Master[masterList.size()];
                int index = 0;
                Iterator<String> i$ = masterList.iterator();
                while (i$.hasNext()) {
                    String masterName;
                    this.currentPlugin = masterName = i$.next();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            GenerateTask.this.statusLabel.setText("Loading " + WorkerThread.this.currentPlugin);
                        }
                    });
                    File masterFile = new File(GenerateTask.this.pluginFile.getParent() + "\\" + masterName);
                    Master master = new Master(masterFile);
                    master.load(this);
                    masters[index++] = master;
                }
                this.raceList = new ArrayList<PluginRace>(32);
                this.raceMap = new HashMap<Integer, PluginRace>(32);
                this.npcList = new ArrayList<PluginNPC>(3072);
                this.npcMap = new HashMap<Integer, PluginNPC>(3072);
                this.questList = new ArrayList<PluginQuest>(512);
                this.questMap = new HashMap<Integer, PluginQuest>(512);
                this.topicList = new ArrayList<PluginTopic>(4096);
                this.topicMap = new HashMap<Integer, PluginTopic>(4096);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GenerateTask.this.statusLabel.setText("Building cross-reference lists");
                    }
                });
                for (PluginGroup group : groupList) {
                    String groupRecordType = group.getGroupRecordType();
                    List<PluginRecord> recordList = group.getRecordList();
                    if (groupRecordType.equals("RACE")) {
                        for (PluginRecord record : recordList) {
                            if (!record.getRecordType().equals("RACE") || record.isIgnored()) continue;
                            if (record.isDeleted()) {
                                race = new PluginRace(record.getFormID());
                                race.setDelete(true);
                            } else {
                                race = this.buildRaceEntry(record);
                            }
                            this.raceList.add(race);
                            this.raceMap.put(new Integer(race.getFormID()), race);
                        }
                        continue;
                    }
                    if (groupRecordType.equals("NPC_")) {
                        for (PluginRecord record : recordList) {
                            if (!record.getRecordType().equals("NPC_") || record.isIgnored()) continue;
                            if (record.isDeleted()) {
                                npc = new PluginNPC(record.getFormID());
                                npc.setDelete(true);
                            } else {
                                npc = this.buildNPCEntry(record);
                            }
                            this.npcList.add(npc);
                            this.npcMap.put(new Integer(npc.getFormID()), npc);
                        }
                        continue;
                    }
                    if (groupRecordType.equals("QUST")) {
                        for (PluginRecord record : recordList) {
                            if (!record.getRecordType().equals("QUST") || record.isIgnored()) continue;
                            if (record.isDeleted()) {
                                quest = new PluginQuest(record.getFormID());
                                quest.setDelete(true);
                            } else {
                                quest = this.buildQuestEntry(record);
                            }
                            this.questList.add(quest);
                            this.questMap.put(new Integer(quest.getFormID()), quest);
                        }
                        continue;
                    }
                    if (!groupRecordType.equals("DIAL")) continue;
                    for (PluginRecord record : recordList) {
                        if (!record.getRecordType().equals("DIAL") || record.isIgnored()) continue;
                        if (record.isDeleted()) {
                            topic = new PluginTopic(record.getFormID());
                            topic.setDelete(true);
                        } else {
                            topic = this.buildTopicEntry(record);
                        }
                        this.topicList.add(topic);
                        this.topicMap.put(new Integer(topic.getFormID()), topic);
                    }
                }
                for (int masterID = 0; masterID < masters.length; ++masterID) {
                    Master master = masters[masterID];
                    List<FormInfo> formList = master.getFormList();
                    for (FormInfo formInfo : formList) {
                        Integer objFormID;
                        int formID;
                        PluginRecord record;
                        String recordType = formInfo.getRecordType();
                        if (recordType.equals("RACE")) {
                            record = master.getRecord(formInfo.getFormID());
                            race = this.buildRaceEntry(record);
                            formID = race.getFormID() & 0xFFFFFF | masterID << 24;
                            objFormID = new Integer(formID);
                            if (this.raceMap.get(objFormID) != null) continue;
                            this.raceList.add(race);
                            this.raceMap.put(objFormID, race);
                            continue;
                        }
                        if (recordType.equals("NPC_")) {
                            record = master.getRecord(formInfo.getFormID());
                            npc = this.buildNPCEntry(record);
                            formID = npc.getFormID() & 0xFFFFFF | masterID << 24;
                            objFormID = new Integer(formID);
                            if (this.npcMap.get(objFormID) != null) continue;
                            this.npcList.add(npc);
                            this.npcMap.put(objFormID, npc);
                            continue;
                        }
                        if (recordType.equals("QUST")) {
                            record = master.getRecord(formInfo.getFormID());
                            quest = this.buildQuestEntry(record);
                            formID = quest.getFormID() & 0xFFFFFF | masterID << 24;
                            objFormID = new Integer(formID);
                            if (this.questMap.get(objFormID) != null) continue;
                            this.questList.add(quest);
                            this.questMap.put(objFormID, quest);
                            continue;
                        }
                        if (!recordType.equals("DIAL") || this.topicMap.get(objFormID = new Integer(formID = (topic = this.buildTopicEntry(record = master.getRecord(formInfo.getFormID()))).getFormID() & 0xFFFFFF | masterID << 24)) != null) continue;
                        this.topicList.add(topic);
                        this.topicMap.put(objFormID, topic);
                    }
                }
                File voiceBase = new File(GenerateTask.this.pluginFile.getParent() + "\\Sound\\Voice\\" + this.plugin.getName());
                if (voiceBase.exists()) {
                    if (voiceBase.isDirectory()) {
                        this.deleteDirectoryTree(voiceBase);
                    } else {
                        voiceBase.delete();
                    }
                }
                this.currentPlugin = GenerateTask.this.pluginFile.getName();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GenerateTask.this.statusLabel.setText("Generating response files for " + WorkerThread.this.currentPlugin);
                    }
                });
                for (PluginGroup group : groupList) {
                    String groupRecordType = group.getGroupRecordType();
                    if (!groupRecordType.equals("DIAL")) continue;
                    List<PluginRecord> recordList = group.getRecordList();
                    for (PluginRecord record : recordList) {
                        if (!record.getRecordType().equals("GRUP")) continue;
                        PluginGroup infoGroup = (PluginGroup)record;
                        int topicID = infoGroup.getGroupParentID();
                        List<PluginRecord> infoList = infoGroup.getRecordList();
                        for (PluginRecord infoRecord : infoList) {
                            int masterID;
                            if (!infoRecord.getRecordType().equals("INFO") || infoRecord.isIgnored() || infoRecord.isDeleted() || (masterID = infoRecord.getFormID() >>> 24) < masterList.size()) continue;
                            this.createResponseFiles(topicID, infoRecord);
                        }
                    }
                }
            }
            catch (Throwable exc) {
                this.exception = exc;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ActionEvent ae = WorkerThread.this.exception == null ? new ActionEvent(this, 1001, "generate complete") : new ActionEvent(WorkerThread.this.exception, 1001, "generate failed");
                    WorkerThread.this.getListener().actionPerformed(ae);
                }
            });
        }

        private PluginRace buildRaceEntry(PluginRecord record) throws DataFormatException, IOException, PluginException {
            int raceFormID;
            int maleFormID = raceFormID = record.getFormID();
            int femaleFormID = raceFormID;
            boolean playableRace = false;
            String raceName = null;
            List<PluginSubrecord> subrecordList = record.getSubrecords();
            for (PluginSubrecord subrecord : subrecordList) {
                byte[] subrecordData;
                String subrecordType = subrecord.getSubrecordType();
                if (subrecordType.equals("FULL")) {
                    subrecordData = subrecord.getSubrecordData();
                    if (subrecordData.length <= 1) continue;
                    raceName = new String(subrecordData, 0, subrecordData.length - 1);
                    continue;
                }
                if (subrecordType.equals("VNAM")) {
                    int formID;
                    subrecordData = subrecord.getSubrecordData();
                    if (subrecordData.length >= 4 && (formID = subrecordData[0] & 0xFF | (subrecordData[1] & 0xFF) << 8 | (subrecordData[2] & 0xFF) << 16 | (subrecordData[3] & 0xFF) << 24) != 0) {
                        maleFormID = formID;
                    }
                    if (subrecordData.length < 8 || (formID = subrecordData[4] & 0xFF | (subrecordData[5] & 0xFF) << 8 | (subrecordData[6] & 0xFF) << 16 | (subrecordData[7] & 0xFF) << 24) == 0) continue;
                    femaleFormID = formID;
                    continue;
                }
                if (!subrecordType.equals("DATA") || (subrecordData = subrecord.getSubrecordData()).length < 33 || (subrecordData[32] & 1) == 0) continue;
                playableRace = true;
            }
            if (raceName == null) {
                raceName = record.getEditorID();
            }
            return new PluginRace(raceFormID, record.getEditorID(), raceName, playableRace, maleFormID, femaleFormID);
        }

        private PluginNPC buildNPCEntry(PluginRecord record) throws DataFormatException, IOException, PluginException {
            int formID = record.getFormID();
            int raceID = 0;
            boolean female = false;
            List<PluginSubrecord> subrecordList = record.getSubrecords();
            for (PluginSubrecord subrecord : subrecordList) {
                byte[] subrecordData;
                String subrecordType = subrecord.getSubrecordType();
                if (subrecordType.equals("RNAM")) {
                    subrecordData = subrecord.getSubrecordData();
                    if (subrecordData.length < 4) continue;
                    raceID = subrecordData[0] & 0xFF | (subrecordData[1] & 0xFF) << 8 | (subrecordData[2] & 0xFF) << 16 | (subrecordData[3] & 0xFF) << 24;
                    continue;
                }
                if (!subrecordType.equals("ACBS") || (subrecordData = subrecord.getSubrecordData()).length < 1 || (subrecordData[0] & 1) == 0) continue;
                female = true;
            }
            return new PluginNPC(formID, record.getEditorID(), raceID, female);
        }

        private PluginQuest buildQuestEntry(PluginRecord record) {
            return new PluginQuest(record.getFormID(), record.getEditorID());
        }

        private PluginTopic buildTopicEntry(PluginRecord record) {
            return new PluginTopic(record.getFormID(), record.getEditorID());
        }

        private void createResponseFiles(int topicID, PluginRecord infoRecord) throws DataFormatException, IOException, PluginException {
            String text;
            String text2;
            List<PluginSubrecord> subrecordList = infoRecord.getSubrecords();
            int infoID = infoRecord.getFormID() & 0xFFFFFF;
            int responseCount = 0;
            int questID = 0;
            int npcID = 0;
            int raceID = 0;
            for (PluginSubrecord subrecord : subrecordList) {
                byte[] subrecordData;
                String subrecordType = subrecord.getSubrecordType();
                if (subrecordType.equals("QSTI")) {
                    subrecordData = subrecord.getSubrecordData();
                    questID = subrecordData[0] & 0xFF | (subrecordData[1] & 0xFF) << 8 | (subrecordData[2] & 0xFF) << 16 | (subrecordData[3] & 0xFF) << 24;
                    continue;
                }
                if (subrecordType.equals("CTDA")) {
                    subrecordData = subrecord.getSubrecordData();
                    int code = subrecordData[8] & 0xFF | (subrecordData[9] & 0xFF) << 8 | (subrecordData[10] & 0xFF) << 16 | (subrecordData[11] & 0xFF) << 24;
                    if (subrecordData[0] != 0 || code != 72 && code != 69) continue;
                    int bits = subrecordData[4] & 0xFF | (subrecordData[5] & 0xFF) << 8 | (subrecordData[6] & 0xFF) << 16 | (subrecordData[7] & 0xFF) << 24;
                    float value = Float.intBitsToFloat(bits);
                    int formID = subrecordData[12] & 0xFF | (subrecordData[13] & 0xFF) << 8 | (subrecordData[14] & 0xFF) << 16 | (subrecordData[15] & 0xFF) << 24;
                    if ((double)value != 1.0) continue;
                    if (code == 72) {
                        npcID = formID;
                        continue;
                    }
                    raceID = formID;
                    continue;
                }
                if (!subrecordType.equals("TRDT")) continue;
                ++responseCount;
            }
            if (responseCount == 0 || questID == 0) {
                return;
            }
            PluginTopic topic = this.topicMap.get(new Integer(topicID));
            if (topic == null) {
                text2 = String.format("Topic %08X not found", new Object[0]);
                throw new PluginException(text2);
            }
            if (topic.isDeleted()) {
                text2 = String.format("Topic %08X is deleted", topicID);
                throw new PluginException(text2);
            }
            String topicName = topic.getEditorID();
            PluginQuest quest = this.questMap.get(new Integer(questID));
            if (quest == null) {
                text = String.format("Quest %08X not found for dialog topic %s", questID, topicName);
                throw new PluginException(text);
            }
            if (quest.isDeleted()) {
                text = String.format("Quest %08X is deleted", questID);
                throw new PluginException(text);
            }
            String questName = quest.getEditorID();
            if (npcID != 0) {
                PluginNPC npc = this.npcMap.get(new Integer(npcID));
                if (npc == null) {
                    String text3 = String.format("NPC %08X not found for dialog topic %s", npcID, topicName);
                    throw new PluginException(text3);
                }
                if (npc.isDeleted()) {
                    String text4 = String.format("NPC %08X is deleted", npcID);
                    throw new PluginException(text4);
                }
                raceID = npc.getRaceID();
                PluginRace race = this.raceMap.get(new Integer(raceID));
                if (race == null) {
                    String text5 = String.format("Race %08X not found for NPC %s", raceID, npc.getEditorID());
                    throw new PluginException(text5);
                }
                if (race.isDeleted()) {
                    String text6 = String.format("Race %08X is deleted", raceID);
                    throw new PluginException(text6);
                }
                this.copyVoiceData(questName, topicName, infoID, race, npc.isFemale(), responseCount);
            } else if (raceID != 0) {
                PluginRace race = this.raceMap.get(new Integer(raceID));
                if (race == null) {
                    String text7 = String.format("Race %08X not found for dialog topic %s", raceID, topicName);
                    throw new PluginException(text7);
                }
                if (race.isDeleted()) {
                    String text8 = String.format("Race %08X is deleted", raceID);
                    throw new PluginException(text8);
                }
                this.copyVoiceData(questName, topicName, infoID, race, false, responseCount);
                this.copyVoiceData(questName, topicName, infoID, race, true, responseCount);
            } else {
                for (PluginRace race : this.raceList) {
                    if (!race.isPlayableRace() || race.isDeleted()) continue;
                    this.copyVoiceData(questName, topicName, infoID, race, false, responseCount);
                    this.copyVoiceData(questName, topicName, infoID, race, true, responseCount);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copyVoiceData(String questName, String topicName, int infoID, PluginRace race, boolean female, int count) throws IOException, PluginException {
            int voiceID = female ? race.getFemaleVoiceID() : race.getMaleVoiceID();
            PluginRace voiceRace = this.raceMap.get(new Integer(voiceID));
            if (voiceRace == null) {
                String text = String.format("Voice race %08X not found for race %s", voiceID, race.getName());
                throw new PluginException(text);
            }
            if (voiceRace.isDeleted()) {
                String text = String.format("Voice race %08X is deleted", voiceID);
                throw new PluginException(text);
            }
            String filePath = String.format("%s\\Sound\\Voice\\%s\\%s\\%s", GenerateTask.this.pluginFile.getParent(), this.plugin.getName(), voiceRace.getName(), female ? "F" : "M");
            File voiceDirectory = new File(filePath);
            if (!voiceDirectory.exists()) {
                voiceDirectory.mkdirs();
            }
            for (int response = 1; response <= count; ++response) {
                String fileName = String.format("%s_%s_%08X_%d.mp3", questName, topicName, infoID, response);
                File voiceFile = new File(filePath + "\\" + fileName);
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(voiceFile);
                    out.write(this.voiceData);
                    continue;
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
        }

        private void deleteDirectoryTree(File directory) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                if (file.isDirectory()) {
                    this.deleteDirectoryTree(file);
                    continue;
                }
                file.delete();
            }
            directory.delete();
        }
    }
}

