/*
 * Decompiled with CFR 0.152.
 */
package TES4Plugin;

import TES4Plugin.Plugin;
import TES4Plugin.PluginException;
import TES4Plugin.TES4Plugin;
import TES4Plugin.WorkerTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LoadTask
extends JDialog
implements ActionListener {
    private JFrame parent;
    private File pluginFile;
    private Plugin plugin;
    private WorkerTask worker;

    public LoadTask(JFrame parent, File pluginFile) {
        super(parent, "Load Plugin", true);
        this.setDefaultCloseOperation(2);
        this.parent = parent;
        this.pluginFile = pluginFile;
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        JButton button = new JButton("Cancel");
        button.setActionCommand("cancel");
        button.addActionListener(this);
        buttonPane.add(button);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setOpaque(true);
        contentPane.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        JLabel label = new JLabel("Loading " + pluginFile.getName(), 0);
        contentPane.add((Component)label, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.setContentPane(contentPane);
        this.worker = new WorkerThread(this);
    }

    public static Plugin loadPlugin(JFrame parent, File pluginFile) {
        LoadTask task = new LoadTask(parent, pluginFile);
        task.worker.start();
        task.pack();
        task.setLocationRelativeTo(parent);
        task.setVisible(true);
        return task.plugin;
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            String action = ae.getActionCommand();
            if (action.equals("load complete")) {
                this.setVisible(false);
                this.dispose();
            } else if (action.equals("load failed")) {
                this.setVisible(false);
                this.dispose();
                Throwable exc = (Throwable)ae.getSource();
                if (exc instanceof PluginException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "Format Error", 0);
                } else if (exc instanceof IOException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "I/O Error", 0);
                } else if (exc instanceof InterruptedException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "Interrupted", 0);
                } else {
                    TES4Plugin.logException("Plugin load failed", exc);
                }
            } else if (action.equals("cancel")) {
                this.worker.interrupt();
            }
        }
        catch (Throwable exc) {
            TES4Plugin.logException("Exception while processing action event", exc);
        }
    }

    private class WorkerThread
    extends WorkerTask {
        private Throwable exception;

        public WorkerThread(ActionListener listener) {
            super(listener);
        }

        public void run() {
            try {
                LoadTask.this.plugin = new Plugin(LoadTask.this.pluginFile);
                LoadTask.this.plugin.load(this);
            }
            catch (Throwable exc) {
                this.exception = exc;
                LoadTask.this.plugin = null;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ActionEvent ae = WorkerThread.this.exception == null ? new ActionEvent(this, 1001, "load complete") : new ActionEvent(WorkerThread.this.exception, 1001, "load failed");
                    WorkerThread.this.getListener().actionPerformed(ae);
                }
            });
        }
    }
}

