/*
 * Decompiled with CFR 0.152.
 */
package TES4Plugin;

import TES4Plugin.ConvertTask;
import TES4Plugin.DisplayDialog;
import TES4Plugin.EditDialog;
import TES4Plugin.EditTask;
import TES4Plugin.GenerateTask;
import TES4Plugin.LoadTask;
import TES4Plugin.MergeDialog;
import TES4Plugin.MergeTask;
import TES4Plugin.Plugin;
import TES4Plugin.PluginDialog;
import TES4Plugin.PluginDirectoryFilter;
import TES4Plugin.PluginException;
import TES4Plugin.PluginFileFilter;
import TES4Plugin.PluginHeader;
import TES4Plugin.PluginInfo;
import TES4Plugin.TES4Plugin;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MainWindow
extends JFrame
implements ActionListener {
    private boolean windowMinimized = false;

    public MainWindow() {
        super("TES4 Plugin Utility");
        this.setDefaultCloseOperation(2);
        int frameX = 0;
        int frameY = 0;
        String propValue = TES4Plugin.properties.getProperty("window.main.position");
        if (propValue != null) {
            int sep = propValue.indexOf(44);
            frameX = Integer.parseInt(propValue.substring(0, sep));
            frameY = Integer.parseInt(propValue.substring(sep + 1));
        }
        this.setLocation(frameX, frameY);
        JPanel contentPane = new JPanel(new GridLayout(0, 2));
        contentPane.setOpaque(true);
        contentPane.setBackground(new Color(240, 240, 240));
        contentPane.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        JLabel label = new JLabel("Convert a plugin to a master     ");
        Font font = label.getFont();
        font = font.deriveFont((float)(font.getSize() + 2));
        label.setFont(font);
        contentPane.add(label);
        JButton button = new JButton("Convert to Master");
        button.setActionCommand("convert master");
        button.setHorizontalAlignment(0);
        button.addActionListener(this);
        contentPane.add(button);
        contentPane.add(Box.createVerticalStrut(5));
        contentPane.add(Box.createVerticalStrut(5));
        label = new JLabel("Convert a master to a plugin     ");
        label.setFont(font);
        contentPane.add(label);
        button = new JButton("Convert to Plugin");
        button.setActionCommand("convert plugin");
        button.setHorizontalAlignment(0);
        button.addActionListener(this);
        contentPane.add(button);
        contentPane.add(Box.createVerticalStrut(5));
        contentPane.add(Box.createVerticalStrut(5));
        label = new JLabel("Display/Copy plugin records     ");
        label.setFont(font);
        contentPane.add(label);
        button = new JButton("Display/Copy");
        button.setActionCommand("display records");
        button.setHorizontalAlignment(0);
        button.addActionListener(this);
        contentPane.add(button);
        contentPane.add(Box.createVerticalStrut(5));
        contentPane.add(Box.createVerticalStrut(5));
        label = new JLabel("Edit plugin description     ");
        label.setFont(font);
        contentPane.add(label);
        button = new JButton("Edit Description");
        button.setActionCommand("edit description");
        button.setHorizontalAlignment(0);
        button.addActionListener(this);
        contentPane.add(button);
        contentPane.add(Box.createVerticalStrut(5));
        contentPane.add(Box.createVerticalStrut(5));
        label = new JLabel("Generate silent response files     ");
        label.setFont(font);
        contentPane.add(label);
        button = new JButton("Generate Responses");
        button.setActionCommand("generate responses");
        button.setHorizontalAlignment(0);
        button.addActionListener(this);
        contentPane.add(button);
        contentPane.add(Box.createVerticalStrut(5));
        contentPane.add(Box.createVerticalStrut(5));
        label = new JLabel("Merge plugin files     ");
        label.setFont(font);
        contentPane.add(label);
        button = new JButton("Merge Plugins");
        button.setActionCommand("merge plugins");
        button.setHorizontalAlignment(0);
        button.addActionListener(this);
        contentPane.add(button);
        contentPane.add(Box.createVerticalStrut(5));
        contentPane.add(Box.createVerticalStrut(5));
        label = new JLabel("Merge plugin file into master file     ");
        label.setFont(font);
        contentPane.add(label);
        button = new JButton("Merge To Master");
        button.setActionCommand("merge master");
        button.setHorizontalAlignment(0);
        button.addActionListener(this);
        contentPane.add(button);
        contentPane.add(Box.createVerticalStrut(5));
        contentPane.add(Box.createVerticalStrut(5));
        label = new JLabel("Set the plugin directory");
        label.setFont(font);
        contentPane.add(label);
        button = new JButton("Set Directory");
        button.setActionCommand("set directory");
        button.setHorizontalAlignment(0);
        button.addActionListener(this);
        contentPane.add(button);
        this.setContentPane(contentPane);
        JMenuBar menuBar = new JMenuBar();
        menuBar.setOpaque(true);
        menuBar.setBackground(new Color(230, 230, 230));
        JMenu menu = new JMenu("File");
        menu.setMnemonic(77);
        JMenuItem menuItem = new JMenuItem("Exit");
        menuItem.setActionCommand("exit");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new JMenu("Help");
        menu.setMnemonic(72);
        menuItem = new JMenuItem("About");
        menuItem.setActionCommand("about");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        this.addWindowListener(new MainWindowListener());
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            String action = ae.getActionCommand();
            if (action.equals("convert master")) {
                this.convertToMaster();
            } else if (action.equals("convert plugin")) {
                this.convertToPlugin();
            } else if (action.equals("display records")) {
                this.displayRecords();
            } else if (action.equals("edit description")) {
                this.editDescription();
            } else if (action.equals("generate responses")) {
                this.generateResponses();
            } else if (action.equals("merge plugins")) {
                this.mergePlugins();
            } else if (action.equals("merge master")) {
                this.mergeToMaster();
            } else if (action.equals("set directory")) {
                this.setDirectory();
            } else if (action.equals("exit")) {
                this.exitProgram();
            } else if (action.equals("about")) {
                this.aboutTES4Plugin();
            }
            TES4Plugin.pluginSpill.reset();
        }
        catch (Throwable exc) {
            TES4Plugin.logException("Exception while processing action event", exc);
        }
    }

    private void setDirectory() {
        String pluginDirectory = TES4Plugin.properties.getProperty("plugin.directory");
        JFileChooser chooser = new JFileChooser(pluginDirectory);
        chooser.setDialogTitle("Select Plugin Directory");
        chooser.setFileFilter(new PluginDirectoryFilter());
        chooser.setFileSelectionMode(1);
        if (chooser.showDialog(this, "Select") == 0) {
            TES4Plugin.properties.setProperty("plugin.directory", chooser.getSelectedFile().getPath());
        }
    }

    private void editDescription() {
        String pluginDirectory = TES4Plugin.properties.getProperty("plugin.directory");
        if (pluginDirectory == null) {
            JOptionPane.showMessageDialog(this, "The plugin directory has not been set", "Error", 0);
            return;
        }
        JFileChooser chooser = new JFileChooser(pluginDirectory);
        chooser.setDialogTitle("Select Plugin File");
        chooser.setFileFilter(new PluginFileFilter(false));
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        File pluginFile = chooser.getSelectedFile();
        RandomAccessFile in = null;
        String creator = null;
        String summary = null;
        boolean descriptionSet = false;
        try {
            if (!pluginFile.exists() || !pluginFile.isFile()) {
                throw new IOException("'" + pluginFile.getName() + "' does not exist");
            }
            in = new RandomAccessFile(pluginFile, "r");
            PluginHeader header = new PluginHeader(pluginFile);
            header.read(in);
            creator = header.getCreator();
            summary = header.getSummary();
            descriptionSet = true;
        }
        catch (PluginException exc) {
            JOptionPane.showMessageDialog(this, exc.getMessage(), "Format Error", 0);
        }
        catch (IOException exc) {
            JOptionPane.showMessageDialog(this, exc.getMessage(), "I/O Error", 0);
        }
        catch (Throwable exc) {
            TES4Plugin.logException("Unable to read plugin header", exc);
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException exc) {
            JOptionPane.showMessageDialog(this, exc.getMessage(), "I/O Error", 0);
        }
        if (!descriptionSet) {
            return;
        }
        PluginInfo pluginInfo = new PluginInfo(pluginFile.getName(), creator, summary);
        boolean descriptionUpdated = EditDialog.showDialog(this, pluginInfo);
        if (descriptionUpdated) {
            EditTask.editFile(this, pluginFile, pluginInfo);
        }
    }

    private void convertToMaster() {
        String pluginDirectory = TES4Plugin.properties.getProperty("plugin.directory");
        if (pluginDirectory == null) {
            JOptionPane.showMessageDialog(this, "The plugin directory has not been set", "Error", 0);
            return;
        }
        JFileChooser chooser = new JFileChooser(pluginDirectory);
        chooser.setDialogTitle("Select Plugin File");
        chooser.setFileFilter(new PluginFileFilter(false));
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        File pluginFile = chooser.getSelectedFile();
        String inputFilename = pluginFile.getPath();
        String outputFilename = null;
        int sep = inputFilename.lastIndexOf(46);
        outputFilename = sep < 0 ? inputFilename + ".esm" : inputFilename.substring(0, sep) + ".esm";
        File masterFile = new File(outputFilename);
        ConvertTask.convertFile(this, pluginFile, masterFile);
    }

    private void convertToPlugin() {
        String pluginDirectory = TES4Plugin.properties.getProperty("plugin.directory");
        if (pluginDirectory == null) {
            JOptionPane.showMessageDialog(this, "The plugin directory has not been set", "Error", 0);
            return;
        }
        JFileChooser chooser = new JFileChooser(pluginDirectory);
        chooser.setDialogTitle("Select Master File");
        chooser.setFileFilter(new PluginFileFilter(true));
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        File masterFile = chooser.getSelectedFile();
        String inputFilename = masterFile.getPath();
        String outputFilename = null;
        int sep = inputFilename.lastIndexOf(46);
        outputFilename = sep < 0 ? inputFilename + ".esp" : inputFilename.substring(0, sep) + ".esp";
        File pluginFile = new File(outputFilename);
        ConvertTask.convertFile(this, masterFile, pluginFile);
    }

    private void displayRecords() {
        String pluginDirectory = TES4Plugin.properties.getProperty("plugin.directory");
        if (pluginDirectory == null) {
            JOptionPane.showMessageDialog(this, "The plugin directory has not been set", "Error", 0);
            return;
        }
        JFileChooser chooser = new JFileChooser(pluginDirectory);
        chooser.setDialogTitle("Select Plugin File");
        chooser.setFileFilter(new PluginFileFilter());
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        File pluginFile = chooser.getSelectedFile();
        Plugin plugin = LoadTask.loadPlugin(this, pluginFile);
        if (plugin != null) {
            DisplayDialog.showDialog(this, pluginFile, plugin);
        }
    }

    private void generateResponses() {
        String pluginDirectory = TES4Plugin.properties.getProperty("plugin.directory");
        if (pluginDirectory == null) {
            JOptionPane.showMessageDialog(this, "The plugin directory has not been set", "Error", 0);
            return;
        }
        JFileChooser chooser = new JFileChooser(pluginDirectory);
        chooser.setDialogTitle("Select Plugin File");
        chooser.setFileFilter(new PluginFileFilter(false));
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        File pluginFile = chooser.getSelectedFile();
        GenerateTask.generateResponses(this, pluginFile);
    }

    private void mergePlugins() {
        String pluginDirectory = TES4Plugin.properties.getProperty("plugin.directory");
        if (pluginDirectory == null) {
            JOptionPane.showMessageDialog(this, "The plugin directory has not been set", "Error", 0);
            return;
        }
        String[] pluginNames = PluginDialog.showDialog(this);
        if (pluginNames == null) {
            return;
        }
        PluginInfo pluginInfo = MergeDialog.showDialog(this);
        if (pluginInfo == null) {
            return;
        }
        MergeTask.mergePlugins(this, pluginNames, pluginInfo);
    }

    private void mergeToMaster() {
        String pluginDirectory = TES4Plugin.properties.getProperty("plugin.directory");
        if (pluginDirectory == null) {
            JOptionPane.showMessageDialog(this, "The plugin directory has not been set", "Error", 0);
            return;
        }
        JFileChooser chooser = new JFileChooser(pluginDirectory);
        chooser.setDialogTitle("Select Master File");
        chooser.setFileFilter(new PluginFileFilter(true));
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        File masterFile = chooser.getSelectedFile();
        chooser = new JFileChooser(pluginDirectory);
        chooser.setDialogTitle("Select Plugin File");
        chooser.setFileFilter(new PluginFileFilter(false));
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        File pluginFile = chooser.getSelectedFile();
        MergeTask.mergeToMaster(this, masterFile, pluginFile);
    }

    private void exitProgram() {
        if (!this.windowMinimized) {
            Point p = TES4Plugin.mainWindow.getLocation();
            TES4Plugin.properties.setProperty("window.main.position", p.x + "," + p.y);
        }
        TES4Plugin.saveProperties();
        if (TES4Plugin.pluginSpill != null) {
            try {
                TES4Plugin.pluginSpill.close();
            }
            catch (IOException exc) {
                TES4Plugin.logException("Unable to close spill file", exc);
            }
        }
        System.exit(0);
    }

    private void aboutTES4Plugin() {
        StringBuilder info = new StringBuilder(256);
        info.append("<html>TES4Plugin Version 11.0<br>(c) 2006 Ronald W. Hoffman<br>");
        info.append("<br>User name: ");
        info.append(System.getProperty("user.name"));
        info.append("<br>Home directory: ");
        info.append(System.getProperty("user.home"));
        info.append("<br><br>OS: ");
        info.append(System.getProperty("os.name"));
        info.append("<br>OS version: ");
        info.append(System.getProperty("os.version"));
        info.append("<br>OS patch level: ");
        info.append(System.getProperty("sun.os.patch.level"));
        info.append("<br><br>Java vendor: ");
        info.append(System.getProperty("java.vendor"));
        info.append("<br>Java version: ");
        info.append(System.getProperty("java.version"));
        info.append("<br>Java home directory: ");
        info.append(System.getProperty("java.home"));
        info.append("<br>Java class path: ");
        info.append(System.getProperty("java.class.path"));
        info.append("</html>");
        JOptionPane.showMessageDialog(this, info.toString(), "About TES4Plugin", 1);
    }

    private class MainWindowListener
    extends WindowAdapter {
        public void windowIconified(WindowEvent we) {
            MainWindow.this.windowMinimized = true;
        }

        public void windowDeiconified(WindowEvent we) {
            MainWindow.this.windowMinimized = false;
        }

        public void windowClosing(WindowEvent we) {
            MainWindow.this.exitProgram();
        }
    }
}

