/*
 * Decompiled with CFR 0.152.
 */
package TES4Plugin;

import TES4Plugin.FormInfo;
import TES4Plugin.PluginException;
import TES4Plugin.PluginHeader;
import TES4Plugin.PluginRecord;
import TES4Plugin.WorkerTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Master {
    private static final int INDEX_VERSION = 2;
    private File masterFile;
    private PluginHeader masterHeader;
    private List<FormInfo> formList;
    private Map<Integer, FormInfo> formMap;

    public Master(File masterFile) {
        this.masterFile = masterFile;
        this.masterHeader = new PluginHeader(masterFile);
    }

    public String getName() {
        return this.masterFile.getName();
    }

    public String getCreator() {
        return this.masterHeader.getCreator();
    }

    public String getSummary() {
        return this.masterHeader.getSummary();
    }

    public int getRecordCount() {
        return this.masterHeader.getRecordCount();
    }

    public List<String> getMasterList() {
        return this.masterHeader.getMasterList();
    }

    public List<FormInfo> getFormList() {
        return this.formList;
    }

    public Map<Integer, FormInfo> getFormMap() {
        return this.formMap;
    }

    public String toString() {
        return this.masterFile.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginRecord getRecord(int formID) throws DataFormatException, IOException, PluginException {
        PluginRecord record = null;
        RandomAccessFile in = null;
        int masterFormID = formID & 0xFFFFFF | this.masterHeader.getMasterList().size() << 24;
        FormInfo formInfo = this.formMap.get(new Integer(masterFormID));
        if (formInfo == null) {
            throw new PluginException(String.format("%s: Record %08X not found", this.masterFile.getName(), masterFormID));
        }
        byte[] prefix = new byte[20];
        long fileOffset = (Long)formInfo.getSource();
        try {
            in = new RandomAccessFile(this.masterFile, "r");
            in.seek(fileOffset);
            int count = in.read(prefix);
            if (count != 20) {
                throw new PluginException(String.format("%s: Record %08X truncated", this.masterFile.getName(), masterFormID));
            }
            int recordLength = (prefix[4] & 0xFF) + ((prefix[5] & 0xFF) << 8) + ((prefix[6] & 0xFF) << 16) + ((prefix[7] & 0xFF) << 24);
            record = new PluginRecord(prefix);
            record.load(this.masterFile, in, recordLength);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(WorkerTask task) throws PluginException, DataFormatException, IOException, InterruptedException {
        if (!this.masterFile.exists() || !this.masterFile.isFile()) {
            throw new IOException("Master file '" + this.masterFile.getName() + "' does not exist");
        }
        RandomAccessFile in = null;
        try {
            in = new RandomAccessFile(this.masterFile, "r");
            this.masterHeader.read(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        String masterName = this.masterFile.getName();
        int sep = masterName.lastIndexOf(46);
        String indexName = sep > 0 ? "TES4Plugin-" + masterName.substring(0, sep) + ".index" : "TES4Plugin-" + masterName + ".index";
        File indexFile = new File(this.masterFile.getParent() + "\\" + indexName);
        if (!indexFile.exists() || indexFile.lastModified() != this.masterFile.lastModified()) {
            this.buildIndexFile(task, indexFile);
        } else {
            this.readIndexFile(task, indexFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIndexFile(WorkerTask task, File indexFile) throws DataFormatException, InterruptedException, IOException, PluginException {
        block16: {
            FileInputStream in = null;
            int masterID = this.masterHeader.getMasterList().size();
            try {
                in = new FileInputStream(indexFile);
                byte[] buffer = new byte[4096];
                int count = in.read(buffer, 0, 12);
                if (count != 12) {
                    throw new PluginException(indexFile.getName() + ": Invalid TES4Plugin index file");
                }
                String recordType = new String(buffer, 0, 4);
                if (!recordType.equals("INDX")) {
                    throw new PluginException(indexFile.getName() + ": Invalid TES4Plugin index file");
                }
                if (buffer[4] != 2) {
                    in.close();
                    in = null;
                    this.buildIndexFile(task, indexFile);
                    break block16;
                }
                int recordCount = (buffer[8] & 0xFF) + ((buffer[9] & 0xFF) << 8) + ((buffer[10] & 0xFF) << 16) + ((buffer[11] & 0xFF) << 24);
                this.formList = new ArrayList<FormInfo>(recordCount);
                this.formMap = new HashMap<Integer, FormInfo>(recordCount);
                int offset = 0;
                int residual = 0;
                while (true) {
                    if (residual < 17) {
                        if (residual > 0 && offset > 0) {
                            System.arraycopy(buffer, offset, buffer, 0, residual);
                        }
                        offset = 0;
                        count = in.read(buffer, residual, buffer.length - residual);
                        if (count < 0) {
                            if (residual != 0) {
                                throw new PluginException(indexFile.getName() + ": Index file truncated");
                            }
                        } else {
                            residual += count;
                            continue;
                        }
                    }
                    if (residual == 0) {
                        break block16;
                    }
                    long position = (buffer[offset] & 0xFF) + ((buffer[offset + 1] & 0xFF) << 8) + ((buffer[offset + 2] & 0xFF) << 16) + ((buffer[offset + 3] & 0xFF) << 24);
                    int formID = (buffer[offset + 4] & 0xFF) + ((buffer[offset + 5] & 0xFF) << 8) + ((buffer[offset + 6] & 0xFF) << 16) + ((buffer[offset + 7] & 0xFF) << 24);
                    recordType = new String(buffer, offset + 8, 4);
                    int parentFormID = (buffer[offset + 12] & 0xFF) + ((buffer[offset + 13] & 0xFF) << 8) + ((buffer[offset + 14] & 0xFF) << 16) + ((buffer[offset + 15] & 0xFF) << 24);
                    offset += 16;
                    residual -= 16;
                    int length = 0;
                    while (buffer[offset + length] != 0) {
                        if (++length < residual) continue;
                        System.arraycopy(buffer, offset, buffer, 0, residual);
                        offset = 0;
                        count = in.read(buffer, residual, buffer.length - residual);
                        if (count < 0) {
                            throw new PluginException(indexFile.getName() + ": Index file truncated");
                        }
                        residual += count;
                    }
                    String editorID = new String(buffer, offset, length);
                    offset += length + 1;
                    residual -= length + 1;
                    FormInfo info = new FormInfo(new Long(position), recordType, formID, editorID);
                    info.setParentFormID(parentFormID);
                    this.formList.add(info);
                    formID = formID & 0xFFFFFF | masterID << 24;
                    this.formMap.put(new Integer(formID), info);
                    if (task == null) continue;
                    if (task.interrupted()) break;
                }
                throw new InterruptedException("Request canceled");
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildIndexFile(WorkerTask task, File indexFile) throws DataFormatException, InterruptedException, IOException, PluginException {
        RandomAccessFile in = null;
        FileOutputStream out = null;
        byte[] prefix = new byte[20];
        int masterID = this.masterHeader.getMasterList().size();
        int recordCount = this.masterHeader.getRecordCount();
        this.formList = new ArrayList<FormInfo>(recordCount);
        try {
            int count;
            in = new RandomAccessFile(this.masterFile, "r");
            if (indexFile.exists()) {
                indexFile.delete();
            }
            out = new FileOutputStream(indexFile);
            while ((count = in.read(prefix)) != -1) {
                if (count != 20) {
                    throw new PluginException(this.masterFile.getName() + ": Group record prefix is too short");
                }
                String recordType = new String(prefix, 0, 4);
                int groupLength = (prefix[4] & 0xFF) + ((prefix[5] & 0xFF) << 8) + ((prefix[6] & 0xFF) << 16) + ((prefix[7] & 0xFF) << 24);
                if (recordType.equals("TES4")) {
                    in.skipBytes(groupLength);
                    continue;
                }
                if (!recordType.equals("GRUP")) {
                    throw new PluginException(this.masterFile.getName() + ": Top-level record is not a group");
                }
                if (prefix[12] != 0) {
                    throw new PluginException(this.masterFile.getName() + ": Top-level group type is not 0");
                }
                String groupRecordType = new String(prefix, 8, 4);
                groupLength -= 20;
                if (groupRecordType.equals("WRLD") || groupRecordType.equals("CELL")) {
                    in.skipBytes(groupLength);
                    continue;
                }
                while (groupLength >= 20) {
                    long position = in.getFilePointer();
                    count = in.read(prefix);
                    if (count != 20) {
                        throw new PluginException(this.masterFile.getName() + ": Group " + groupRecordType + " is incomplete");
                    }
                    recordType = new String(prefix, 0, 4);
                    int recordLength = (prefix[4] & 0xFF) + ((prefix[5] & 0xFF) << 8) + ((prefix[6] & 0xFF) << 16) + ((prefix[7] & 0xFF) << 24);
                    if (recordType.equals("GRUP")) {
                        groupLength -= recordLength;
                        in.skipBytes(recordLength - 20);
                        continue;
                    }
                    PluginRecord record = new PluginRecord(prefix);
                    int formID = record.getFormID();
                    if (record.isDeleted() || record.isIgnored() || formID == 0 || formID >>> 24 < masterID) {
                        in.skipBytes(recordLength);
                    } else {
                        record.load(this.masterFile, in, recordLength);
                        this.formList.add(new FormInfo(new Long(position), recordType, formID, record.getEditorID()));
                    }
                    groupLength -= recordLength + 20;
                }
                if (groupLength != 0) {
                    throw new PluginException(this.masterFile.getName() + ": Group " + groupRecordType + " is incomplete");
                }
                if (task == null) continue;
                if (!task.interrupted()) continue;
                throw new InterruptedException("Request canceled");
            }
            recordCount = this.formList.size();
            this.formMap = new HashMap<Integer, FormInfo>(recordCount);
            byte[] buffer = new byte[256];
            System.arraycopy("INDX".getBytes(), 0, buffer, 0, 4);
            buffer[4] = 2;
            buffer[5] = 0;
            buffer[6] = 0;
            buffer[7] = 0;
            buffer[8] = (byte)recordCount;
            buffer[9] = (byte)(recordCount >> 8);
            buffer[10] = (byte)(recordCount >> 16);
            buffer[11] = (byte)(recordCount >> 24);
            out.write(buffer, 0, 12);
            for (FormInfo info : this.formList) {
                int formID = info.getFormID();
                byte[] recordType = info.getRecordType().getBytes();
                byte[] editorID = info.getEditorID().getBytes();
                int parentFormID = info.getParentFormID();
                int position = ((Long)info.getSource()).intValue();
                int length = 16 + editorID.length + 1;
                if (length > buffer.length) {
                    buffer = new byte[length];
                }
                buffer[0] = (byte)position;
                buffer[1] = (byte)(position >> 8);
                buffer[2] = (byte)(position >> 16);
                buffer[3] = (byte)(position >> 24);
                buffer[4] = (byte)formID;
                buffer[5] = (byte)(formID >> 8);
                buffer[6] = (byte)(formID >> 16);
                buffer[7] = (byte)(formID >> 24);
                System.arraycopy(recordType, 0, buffer, 8, 4);
                buffer[12] = (byte)parentFormID;
                buffer[13] = (byte)(parentFormID >> 8);
                buffer[14] = (byte)(parentFormID >> 16);
                buffer[15] = (byte)(parentFormID >> 24);
                if (editorID.length != 0) {
                    System.arraycopy(editorID, 0, buffer, 16, editorID.length);
                }
                buffer[16 + editorID.length] = 0;
                out.write(buffer, 0, 16 + editorID.length + 1);
                formID = formID & 0xFFFFFF | masterID << 24;
                this.formMap.put(new Integer(formID), info);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            indexFile.setLastModified(this.masterFile.lastModified());
        }
    }
}

