/*
 * Decompiled with CFR 0.152.
 */
package TES4Plugin;

import TES4Plugin.EditLeveledList;
import TES4Plugin.FormInfo;
import TES4Plugin.Master;
import TES4Plugin.Plugin;
import TES4Plugin.PluginException;
import TES4Plugin.PluginGroup;
import TES4Plugin.PluginInfo;
import TES4Plugin.PluginRecord;
import TES4Plugin.PluginSubrecord;
import TES4Plugin.TES4Plugin;
import TES4Plugin.WorkerConfirmDialog;
import TES4Plugin.WorkerTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.zip.DataFormatException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MergeTask
extends JDialog
implements ActionListener {
    private JFrame parent;
    private String[] pluginNames;
    private PluginInfo pluginInfo;
    private boolean masterMerge;
    private Thread worker;
    private JLabel statusLabel;

    public MergeTask(JFrame parent, String[] pluginNames, PluginInfo pluginInfo) {
        super(parent, "Merge Plugins", true);
        this.setDefaultCloseOperation(2);
        this.parent = parent;
        this.pluginNames = pluginNames;
        this.pluginInfo = pluginInfo;
        this.masterMerge = pluginInfo == null;
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        JButton button = new JButton("Cancel");
        button.setActionCommand("cancel");
        button.addActionListener(this);
        buttonPane.add(button);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setOpaque(true);
        contentPane.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        this.statusLabel = new JLabel(" ", 0);
        this.statusLabel.setPreferredSize(new Dimension(320, 12));
        contentPane.add((Component)this.statusLabel, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.setContentPane(contentPane);
        this.worker = new WorkerThread(this);
    }

    public static void mergeToMaster(JFrame parent, File masterFile, File pluginFile) {
        String[] pluginNames = new String[]{masterFile.getName(), pluginFile.getName()};
        MergeTask task = new MergeTask(parent, pluginNames, null);
        task.worker.start();
        task.pack();
        task.setLocationRelativeTo(parent);
        task.setVisible(true);
    }

    public static void mergePlugins(JFrame parent, String[] pluginNames, PluginInfo pluginInfo) {
        MergeTask task = new MergeTask(parent, pluginNames, pluginInfo);
        task.worker.start();
        task.pack();
        task.setLocationRelativeTo(parent);
        task.setVisible(true);
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            String action = ae.getActionCommand();
            if (action.equals("merge complete")) {
                this.setVisible(false);
                this.dispose();
                if (this.masterMerge) {
                    JOptionPane.showMessageDialog(this.parent, this.pluginNames[0] + " updated", "Merge", 1);
                } else {
                    JOptionPane.showMessageDialog(this.parent, this.pluginInfo.getName() + " created", "Merge", 1);
                }
            } else if (action.equals("merge failed")) {
                this.setVisible(false);
                this.dispose();
                Throwable exc = (Throwable)ae.getSource();
                if (exc instanceof PluginException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "Format Error", 0);
                } else if (exc instanceof DataFormatException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "Compression Error", 0);
                } else if (exc instanceof IOException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "I/O Error", 0);
                } else if (exc instanceof InterruptedException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "Interrupted", 0);
                } else {
                    TES4Plugin.logException("Merge failed", exc);
                }
            } else if (action.equals("cancel")) {
                this.worker.interrupt();
            }
        }
        catch (Throwable exc) {
            TES4Plugin.logException("Exception while processing action event", exc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WorkerThread
    extends WorkerTask {
        private Throwable exception;
        private String currentPlugin;
        private Plugin[] plugins;
        private Plugin mergedPlugin;
        private List<String> mergedMasterList;
        private int mergedMasterCount;
        private Master[] masters;
        private Map<Integer, FormInfo> mergedFormMap;
        private Map<String, FormInfo> mergedEditorMap;
        private int highFormID;

        public WorkerThread(ActionListener listener) {
            super(listener);
        }

        @Override
        public void run() {
            String pluginDirectory = TES4Plugin.properties.getProperty("plugin.directory");
            Plugin plugin = null;
            Master master = null;
            try {
                File mergedFile;
                int i;
                this.plugins = new Plugin[MergeTask.this.pluginNames.length];
                for (i = 0; i < MergeTask.this.pluginNames.length; ++i) {
                    this.currentPlugin = MergeTask.this.pluginNames[i];
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MergeTask.this.statusLabel.setText("Loading " + WorkerThread.this.currentPlugin);
                        }
                    });
                    File inFile = new File(pluginDirectory + "\\" + this.currentPlugin);
                    plugin = new Plugin(inFile);
                    plugin.load(this);
                    this.plugins[i] = plugin;
                }
                int count = 0;
                for (i = 0; i < this.plugins.length; ++i) {
                    count += this.plugins[i].getMasterList().size();
                }
                this.mergedMasterList = new ArrayList<String>(count);
                for (i = 0; i < this.plugins.length; ++i) {
                    List<String> masterList = this.plugins[i].getMasterList();
                    for (String masterName : masterList) {
                        if (this.mergedMasterList.contains(masterName) || MergeTask.this.masterMerge && masterName.equals(MergeTask.this.pluginNames[0])) continue;
                        this.mergedMasterList.add(masterName);
                    }
                }
                this.mergedMasterCount = this.mergedMasterList.size();
                this.masters = new Master[this.mergedMasterCount];
                i = 0;
                Iterator<String> i$ = this.mergedMasterList.iterator();
                while (i$.hasNext()) {
                    String masterName;
                    this.currentPlugin = masterName = i$.next();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MergeTask.this.statusLabel.setText("Loading " + WorkerThread.this.currentPlugin);
                        }
                    });
                    File masterFile = new File(pluginDirectory + "\\" + masterName);
                    master = new Master(masterFile);
                    master.load(this);
                    this.masters[i++] = master;
                }
                count = 0;
                for (i = 0; i < this.plugins.length; ++i) {
                    count += this.plugins[i].getFormList().size();
                }
                this.mergedFormMap = new HashMap<Integer, FormInfo>(count);
                this.mergedEditorMap = new HashMap<String, FormInfo>(count);
                this.highFormID = this.mergedMasterCount << 24;
                for (i = 0; i < this.plugins.length; ++i) {
                    this.mapPluginRecords(this.plugins[i]);
                    if (!WorkerThread.interrupted()) continue;
                    throw new InterruptedException("Request canceled");
                }
                for (i = 0; i < this.plugins.length; ++i) {
                    this.currentPlugin = MergeTask.this.pluginNames[i];
                    plugin = this.plugins[i];
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MergeTask.this.statusLabel.setText("Updating " + WorkerThread.this.currentPlugin);
                        }
                    });
                    List<PluginGroup> groupList = plugin.getGroupList();
                    Map<Integer, FormInfo> formMap = plugin.getFormMap();
                    List<String> masterList = plugin.getMasterList();
                    int[] masterMap = new int[masterList.size()];
                    for (int index = 0; index < masterMap.length; ++index) {
                        int mergedIndex = this.mergedMasterList.indexOf(masterList.get(index));
                        masterMap[index] = mergedIndex >= 0 ? mergedIndex : this.mergedMasterList.size();
                    }
                    for (PluginGroup group : groupList) {
                        this.updateGroup(group, masterMap, formMap);
                        if (!WorkerThread.interrupted()) continue;
                        throw new InterruptedException("Request canceled");
                    }
                }
                if (MergeTask.this.masterMerge) {
                    plugin = this.plugins[0];
                    mergedFile = new File(pluginDirectory + "\\" + plugin.getName());
                    this.mergedPlugin = new Plugin(mergedFile, plugin.getCreator(), plugin.getSummary(), this.mergedMasterList);
                    this.mergedPlugin.setMaster(true);
                } else {
                    mergedFile = new File(pluginDirectory + "\\" + MergeTask.this.pluginInfo.getName());
                    this.mergedPlugin = new Plugin(mergedFile, MergeTask.this.pluginInfo.getCreator(), MergeTask.this.pluginInfo.getSummary(), this.mergedMasterList);
                    this.mergedPlugin.setMaster(false);
                }
                this.mergedPlugin.createInitialGroups();
                for (i = 0; i < this.plugins.length; ++i) {
                    this.currentPlugin = MergeTask.this.pluginNames[i];
                    plugin = this.plugins[i];
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MergeTask.this.statusLabel.setText("Merging " + WorkerThread.this.currentPlugin);
                        }
                    });
                    this.mergePlugin(plugin);
                }
                this.currentPlugin = this.mergedPlugin.getName();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MergeTask.this.statusLabel.setText("Writing " + WorkerThread.this.currentPlugin);
                    }
                });
                this.mergedPlugin.store(this);
                String mergedPath = String.format("%s\\Sound\\Voice\\%s", mergedFile.getParent(), mergedFile.getName());
                if (!MergeTask.this.masterMerge) {
                    File voiceDirectory;
                    String mergedName = this.mergedPlugin.getName();
                    boolean deleteFiles = true;
                    for (i = 0; i < MergeTask.this.pluginNames.length; ++i) {
                        if (!mergedName.equalsIgnoreCase(MergeTask.this.pluginNames[i])) continue;
                        deleteFiles = false;
                        break;
                    }
                    if (deleteFiles && (voiceDirectory = new File(mergedPath)).exists()) {
                        if (voiceDirectory.isDirectory()) {
                            this.deleteDirectoryTree(voiceDirectory);
                        } else {
                            voiceDirectory.delete();
                        }
                    }
                }
                for (i = 0; i < this.plugins.length; ++i) {
                    String voicePath;
                    File voiceDirectory;
                    plugin = this.plugins[i];
                    if (this.mergedPlugin.getName().equalsIgnoreCase(plugin.getName()) || !(voiceDirectory = new File(voicePath = String.format("%s\\Sound\\Voice\\%s", mergedFile.getParent(), plugin.getName()))).exists() || !voiceDirectory.isDirectory()) continue;
                    this.copyVoiceFiles(plugin, voiceDirectory, mergedPath);
                }
            }
            catch (Throwable exc) {
                this.exception = exc;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ActionEvent ae = WorkerThread.this.exception == null ? new ActionEvent(this, 1001, "merge complete") : new ActionEvent(WorkerThread.this.exception, 1001, "merge failed");
                    WorkerThread.this.getListener().actionPerformed(ae);
                }
            });
        }

        private void mapPluginRecords(Plugin plugin) throws IOException, PluginException {
            List<FormInfo> formList = plugin.getFormList();
            List<String> masterList = plugin.getMasterList();
            String pluginName = plugin.getName();
            int masterCount = masterList.size();
            for (FormInfo info : formList) {
                PluginRecord mergedRecord;
                PluginRecord record;
                FormInfo mergedInfo;
                int formID = info.getFormID();
                String editorID = info.getEditorID();
                Integer objFormID = null;
                int masterID = formID >>> 24;
                formID &= 0xFFFFFF;
                boolean masterReference = false;
                boolean updateMap = true;
                if (masterID < masterCount) {
                    String masterName = masterList.get(masterID);
                    if (!MergeTask.this.masterMerge || !masterName.equals(MergeTask.this.pluginNames[0])) {
                        masterReference = true;
                        masterID = this.mergedMasterList.indexOf(masterName);
                    }
                }
                if (masterReference) {
                    objFormID = new Integer(formID |= masterID << 24);
                    mergedInfo = this.mergedFormMap.get(objFormID);
                    if (mergedInfo != null) {
                        updateMap = false;
                        record = (PluginRecord)info.getSource();
                        if (record.isIdentical(mergedRecord = (PluginRecord)mergedInfo.getSource())) {
                            record.setIgnore(true);
                        } else if (!record.isDeleted() && editorID.length() != 0 && !mergedInfo.getMergedEditorID().equals(editorID)) {
                            mergedInfo.setMergedEditorID(editorID);
                            this.mergedEditorMap.put(editorID.toLowerCase(), info);
                        }
                    }
                } else {
                    objFormID = new Integer(formID |= this.mergedMasterCount << 24);
                    mergedInfo = this.mergedFormMap.get(objFormID);
                    if (mergedInfo != null) {
                        if (MergeTask.this.masterMerge && masterID < masterCount) {
                            record = (PluginRecord)info.getSource();
                            String recordType = info.getRecordType();
                            if (!(recordType.equals("WRLD") || recordType.equals("CELL") || recordType.equals("DIAL"))) {
                                mergedRecord = (PluginRecord)mergedInfo.getSource();
                                this.mergedFormMap.remove(objFormID);
                                this.mergedEditorMap.remove(mergedInfo.getMergedEditorID().toLowerCase());
                                mergedRecord.setIgnore(true);
                                if (record.isDeleted()) {
                                    record.setIgnore(true);
                                    updateMap = false;
                                }
                            } else {
                                updateMap = false;
                                if (!record.isDeleted() && editorID.length() != 0 && !mergedInfo.getMergedEditorID().equals(editorID)) {
                                    mergedInfo.setMergedEditorID(editorID);
                                    this.mergedEditorMap.put(editorID.toLowerCase(), info);
                                }
                            }
                        } else {
                            formID = this.highFormID + 1;
                            objFormID = new Integer(formID);
                        }
                    }
                    if (updateMap && editorID.length() != 0 && (mergedInfo = this.mergedEditorMap.get(editorID.toLowerCase())) != null) {
                        record = (PluginRecord)info.getSource();
                        if (record.isIdentical(mergedRecord = (PluginRecord)mergedInfo.getSource())) {
                            record.setIgnore(true);
                            formID = mergedInfo.getMergedFormID();
                            objFormID = new Integer(formID);
                            updateMap = false;
                        } else {
                            String newEditorID = editorID.concat("X");
                            while (this.mergedEditorMap.get(newEditorID.toLowerCase()) != null) {
                                newEditorID = newEditorID.concat("X");
                            }
                            String text = String.format("%s record %s in '%s' has the same name as %s record in '%s'", info.getRecordType(), editorID, pluginName, mergedInfo.getRecordType(), ((Plugin)mergedInfo.getPlugin()).getName());
                            int selection = WorkerConfirmDialog.showConfirmDialog(this.getParent(), text + ". Do you want to rename it to " + newEditorID + "?", "Error", 0, 0);
                            if (selection != 0) {
                                throw new PluginException(text);
                            }
                            editorID = newEditorID;
                        }
                    }
                }
                info.setMergedFormID(formID);
                info.setMergedEditorID(editorID);
                if (updateMap) {
                    this.mergedFormMap.put(objFormID, info);
                    if (editorID.length() != 0) {
                        this.mergedEditorMap.put(editorID.toLowerCase(), info);
                    }
                }
                if (formID <= this.highFormID) continue;
                this.highFormID = formID;
            }
        }

        private void updateGroup(PluginGroup group, int[] masterMap, Map<Integer, FormInfo> formMap) throws DataFormatException, IOException, PluginException {
            byte[] groupLabel;
            int parentID;
            FormInfo formInfo;
            int groupType = group.getGroupType();
            if ((groupType == 1 || groupType == 6 || groupType == 8 || groupType == 9 || groupType == 10 || groupType == 7) && (formInfo = formMap.get(new Integer(parentID = (groupLabel = group.getGroupLabel())[0] & 0xFF | (groupLabel[1] & 0xFF) << 8 | (groupLabel[2] & 0xFF) << 16 | (groupLabel[3] & 0xFF) << 24))) != null) {
                parentID = formInfo.getMergedFormID();
                groupLabel[0] = (byte)parentID;
                groupLabel[1] = (byte)(parentID >>> 8);
                groupLabel[2] = (byte)(parentID >>> 16);
                groupLabel[3] = (byte)(parentID >>> 24);
            }
            List<PluginRecord> recordList = group.getRecordList();
            for (PluginRecord record : recordList) {
                if (record instanceof PluginGroup) {
                    this.updateGroup((PluginGroup)record, masterMap, formMap);
                    continue;
                }
                if (record.isIgnored()) continue;
                this.updateRecord(record, masterMap, formMap);
            }
        }

        private void updateRecord(PluginRecord record, int[] masterMap, Map<Integer, FormInfo> formMap) throws DataFormatException, IOException, PluginException {
            String recordType = record.getRecordType();
            int formID = record.getFormID();
            List<PluginSubrecord> subrecordList = record.getSubrecords();
            Integer objFormID = new Integer(formID);
            FormInfo info = formMap.get(objFormID);
            if (info == null && formID != 0) {
                throw new PluginException(String.format("No mapping found for Form ID %08X in %s record %s", formID, recordType, record.getEditorID()));
            }
            for (PluginSubrecord subrecord : subrecordList) {
                byte[] subrecordData;
                String subrecordType = subrecord.getSubrecordType();
                if (subrecordType.equals("EDID")) {
                    if (info == null) continue;
                    byte[] idString = info.getMergedEditorID().getBytes();
                    subrecordData = new byte[idString.length + 1];
                    System.arraycopy(idString, 0, subrecordData, 0, idString.length);
                    subrecordData[idString.length] = 0;
                    subrecord.setSubrecordData(subrecordData);
                    continue;
                }
                int[][] references = subrecord.getReferences();
                if (references == null) continue;
                subrecordData = subrecord.getSubrecordData();
                for (int i = 0; i < references.length; ++i) {
                    int mergedFormID;
                    int refOffset = references[i][0];
                    int refFormID = references[i][1];
                    int refMasterID = refFormID >>> 24;
                    if (refFormID == 0) continue;
                    if (refMasterID < masterMap.length) {
                        refMasterID = masterMap[refMasterID];
                        mergedFormID = refFormID & 0xFFFFFF | refMasterID << 24;
                    } else {
                        Integer lookupID = new Integer(refFormID);
                        FormInfo refInfo = formMap.get(lookupID);
                        if (refInfo == null) {
                            String text = String.format("No mapping found for reference %08X in subrecord %s of %s record %s", lookupID, subrecord.getSubrecordType(), record.getRecordType(), record.getEditorID());
                            int selection = WorkerConfirmDialog.showConfirmDialog(this.getParent(), text + ". Do you want to continue?", "Error", 0, 0);
                            if (selection != 0) {
                                throw new PluginException(text);
                            }
                            mergedFormID = refFormID;
                        } else {
                            mergedFormID = refInfo.getMergedFormID();
                        }
                    }
                    subrecordData[refOffset] = (byte)mergedFormID;
                    subrecordData[refOffset + 1] = (byte)(mergedFormID >>> 8);
                    subrecordData[refOffset + 2] = (byte)(mergedFormID >>> 16);
                    subrecordData[refOffset + 3] = (byte)(mergedFormID >>> 24);
                }
            }
            record.setSubrecords(subrecordList);
            if (info != null) {
                record.setFormID(info.getMergedFormID());
            }
        }

        private void mergePlugin(Plugin plugin) throws DataFormatException, IOException, PluginException {
            List<PluginGroup> mergedGroupList = this.mergedPlugin.getGroupList();
            List<PluginGroup> groupList = plugin.getGroupList();
            boolean editLeveledLists = MergeTask.this.masterMerge ? false : MergeTask.this.pluginInfo.shouldEditConflicts();
            for (PluginGroup group : groupList) {
                String groupRecordType = group.getGroupRecordType();
                group.removeIgnoredRecords();
                boolean groupMerged = false;
                for (PluginGroup mergedGroup : mergedGroupList) {
                    if (!mergedGroup.getGroupRecordType().equals(groupRecordType)) continue;
                    List<PluginRecord> recordList = group.getRecordList();
                    List<PluginRecord> mergedRecordList = mergedGroup.getRecordList();
                    for (PluginRecord record : recordList) {
                        if (record instanceof PluginGroup) {
                            PluginGroup subgroup = (PluginGroup)record;
                            int subgroupType = subgroup.getGroupType();
                            byte[] subgroupLabel = subgroup.getGroupLabel();
                            boolean subgroupMerged = false;
                            for (PluginRecord mergedRecord : mergedRecordList) {
                                byte[] mergedSubgroupLabel;
                                PluginGroup mergedSubgroup;
                                if (!(mergedRecord instanceof PluginGroup) || (mergedSubgroup = (PluginGroup)mergedRecord).getGroupType() != subgroupType || (mergedSubgroupLabel = mergedSubgroup.getGroupLabel())[0] != subgroupLabel[0] || mergedSubgroupLabel[1] != subgroupLabel[1] || mergedSubgroupLabel[2] != subgroupLabel[2] || mergedSubgroupLabel[3] != subgroupLabel[3]) continue;
                                this.mergeGroup(mergedSubgroup, subgroup);
                                subgroupMerged = true;
                                break;
                            }
                            if (subgroupMerged) continue;
                            if (subgroupType == 2) {
                                PluginGroup mergedSubgroup = subgroup.createEmptyGroup();
                                mergedRecordList.add(mergedSubgroup);
                                mergedSubgroup.setParent(mergedGroup);
                                this.mergeGroup(mergedSubgroup, subgroup);
                                continue;
                            }
                            mergedRecordList.add(record);
                            record.setParent(mergedGroup);
                            continue;
                        }
                        String recordType = record.getRecordType();
                        int index = mergedRecordList.indexOf(record);
                        if (index < 0) {
                            mergedRecordList.add(record);
                            record.setParent(mergedGroup);
                            continue;
                        }
                        if (record.isDeleted()) continue;
                        PluginRecord mergedRecord = mergedRecordList.get(index);
                        if (recordType.equals("ACTI") || recordType.equals("AMMO") || recordType.equals("APPA") || recordType.equals("ARMO") || recordType.equals("CLAS") || recordType.equals("CLOT") || recordType.equals("DOOR") || recordType.equals("EYES") || recordType.equals("HAIR") || recordType.equals("LIGH") || recordType.equals("MISC") || recordType.equals("SKIL") || recordType.equals("WEAP")) {
                            this.mergeSubrecords(mergedRecord, record, null);
                            continue;
                        }
                        if (recordType.equals("BSGN")) {
                            this.mergeBirthsign(mergedRecord, record);
                            continue;
                        }
                        if (recordType.equals("CONT")) {
                            this.mergeContainer(mergedRecord, record);
                            continue;
                        }
                        if (recordType.equals("ALCH") || recordType.equals("ENCH") || recordType.equals("INGR") || recordType.equals("SPEL")) {
                            this.mergeEnchantment(mergedRecord, record);
                            continue;
                        }
                        if (recordType.equals("FACT")) {
                            this.mergeFaction(mergedRecord, record);
                            continue;
                        }
                        if (recordType.equals("LVLC") || recordType.equals("LVLI") || recordType.equals("LVSP")) {
                            if (editLeveledLists) {
                                EditLeveledList.showWorkerDialog((JDialog)this.getParent(), mergedRecord, record, this.mergedFormMap, this.masters);
                                continue;
                            }
                            this.mergeLeveledList(mergedRecord, record);
                            continue;
                        }
                        if (recordType.equals("NPC_") || recordType.equals("CREA")) {
                            this.mergeNPC(mergedRecord, record);
                            continue;
                        }
                        if (recordType.equals("RACE")) {
                            this.mergeRace(mergedRecord, record);
                            continue;
                        }
                        if (!MergeTask.this.masterMerge && MergeTask.this.pluginInfo.shouldDeleteLastConflict()) continue;
                        mergedRecordList.remove(index);
                        mergedRecordList.add(index, record);
                        record.setParent(mergedGroup);
                    }
                    groupMerged = true;
                    break;
                }
                if (groupMerged) continue;
                throw new PluginException("Merge group " + groupRecordType + " not found");
            }
        }

        private void mergeGroup(PluginGroup mergedGroup, PluginGroup group) {
            List<PluginRecord> mergedRecordList = mergedGroup.getRecordList();
            List<PluginRecord> recordList = group.getRecordList();
            ListIterator<PluginRecord> lit = recordList.listIterator();
            while (lit.hasNext()) {
                PluginGroup mergedSubgroup;
                PluginRecord record = lit.next();
                String recordType = record.getRecordType();
                if (record instanceof PluginGroup) {
                    PluginGroup subgroup = (PluginGroup)record;
                    int subgroupType = subgroup.getGroupType();
                    byte[] subgroupLabel = subgroup.getGroupLabel();
                    boolean subgroupMerged = false;
                    for (PluginRecord mergedRecord : mergedRecordList) {
                        byte[] mergedSubgroupLabel;
                        if (!(mergedRecord instanceof PluginGroup) || (mergedSubgroup = (PluginGroup)mergedRecord).getGroupType() != subgroupType || (mergedSubgroupLabel = mergedSubgroup.getGroupLabel())[0] != subgroupLabel[0] || mergedSubgroupLabel[1] != subgroupLabel[1] || mergedSubgroupLabel[2] != subgroupLabel[2] || mergedSubgroupLabel[3] != subgroupLabel[3]) continue;
                        this.mergeGroup(mergedSubgroup, subgroup);
                        subgroupMerged = true;
                        break;
                    }
                    if (subgroupMerged) continue;
                    if (subgroupType == 4 || subgroupType == 5 || subgroupType == 2 || subgroupType == 3) {
                        PluginGroup mergedSubgroup2 = subgroup.createEmptyGroup();
                        mergedRecordList.add(mergedSubgroup2);
                        mergedSubgroup2.setParent(mergedGroup);
                        this.mergeGroup(mergedSubgroup2, subgroup);
                        continue;
                    }
                    mergedRecordList.add(record);
                    record.setParent(mergedGroup);
                    continue;
                }
                if (recordType.equals("CELL")) {
                    FormInfo formInfo = this.mergedFormMap.get(new Integer(record.getFormID()));
                    PluginRecord mergedRecord = (PluginRecord)formInfo.getSource();
                    if (mergedRecord == record) {
                        mergedRecordList.add(record);
                        record.setParent(mergedGroup);
                        continue;
                    }
                    PluginGroup parentGroup = (PluginGroup)mergedRecord.getParent();
                    List<PluginRecord> parentRecordList = parentGroup.getRecordList();
                    int index = parentRecordList.indexOf(record);
                    if (!(record.isDeleted() || !MergeTask.this.masterMerge && MergeTask.this.pluginInfo.shouldDeleteLastConflict())) {
                        parentRecordList.remove(index);
                        parentRecordList.add(index, record);
                        record.setParent(parentGroup);
                    }
                    if (!lit.hasNext()) continue;
                    record = lit.next();
                    if (record instanceof PluginGroup && ++index < parentRecordList.size()) {
                        mergedRecord = parentRecordList.get(index);
                        if (mergedRecord instanceof PluginGroup) {
                            PluginGroup subgroup = (PluginGroup)record;
                            mergedSubgroup = (PluginGroup)mergedRecord;
                            this.mergeGroup(mergedSubgroup, subgroup);
                            continue;
                        }
                        lit.previous();
                        continue;
                    }
                    lit.previous();
                    continue;
                }
                int index = mergedRecordList.indexOf(record);
                if (index < 0) {
                    mergedRecordList.add(record);
                    record.setParent(mergedGroup);
                    continue;
                }
                if (record.isDeleted() || !MergeTask.this.masterMerge && MergeTask.this.pluginInfo.shouldDeleteLastConflict()) continue;
                mergedRecordList.remove(index);
                mergedRecordList.add(index, record);
                record.setParent(mergedGroup);
            }
        }

        private void mergeSubrecords(PluginRecord mergedRecord, PluginRecord record, String[] exclusionList) throws DataFormatException, IOException, PluginException {
            boolean modifiedMergedList = false;
            boolean skipName = false;
            int formID = mergedRecord.getFormID();
            int masterID = formID >>> 24;
            if (masterID >= this.mergedMasterCount) {
                throw new PluginException("Merged master ID " + masterID + " is not valid");
            }
            Master master = this.masters[masterID];
            PluginRecord masterRecord = master.getRecord(formID);
            List<PluginSubrecord> masterSubrecordList = masterRecord.getSubrecords();
            List<PluginSubrecord> mergedSubrecordList = mergedRecord.getSubrecords();
            List<PluginSubrecord> subrecordList = record.getSubrecords();
            ListIterator<PluginSubrecord> lit = subrecordList.listIterator();
            while (lit.hasNext()) {
                PluginSubrecord subrecord = lit.next();
                boolean foundSubrecord = false;
                String subrecordType = subrecord.getSubrecordType();
                if (subrecordType.equals("MODB") || subrecordType.equals("MODT") || subrecordType.equals("MO2B") || subrecordType.equals("MO2T") || subrecordType.equals("MO3B") || subrecordType.equals("MO3T") || subrecordType.equals("MO4B") || subrecordType.equals("MO4T") || skipName && subrecordType.equals("FULL")) continue;
                if (subrecordType.equals("EFID")) {
                    skipName = true;
                }
                if (exclusionList != null) {
                    boolean mergeSubrecord = true;
                    for (String exclusion : exclusionList) {
                        if (!exclusion.equals(subrecordType)) continue;
                        mergeSubrecord = false;
                        break;
                    }
                    if (!mergeSubrecord) continue;
                }
                ListIterator<PluginSubrecord> mlit = mergedSubrecordList.listIterator();
                boolean skipMergedName = false;
                while (mlit.hasNext()) {
                    PluginSubrecord mergedSubrecord = mlit.next();
                    if (!mergedSubrecord.getSubrecordType().equals(subrecordType)) continue;
                    if (skipMergedName && subrecordType.equals("FULL")) break;
                    if (subrecordType.equals("EFID")) {
                        skipMergedName = true;
                    }
                    foundSubrecord = true;
                    boolean replaceSubrecord = false;
                    if (!mergedSubrecord.equals(subrecord)) {
                        int mergedIndex = masterSubrecordList.indexOf(mergedSubrecord);
                        int index = masterSubrecordList.indexOf(subrecord);
                        if (mergedIndex < 0) {
                            if (index < 0 && (MergeTask.this.masterMerge || !MergeTask.this.pluginInfo.shouldDeleteLastConflict())) {
                                replaceSubrecord = true;
                            }
                        } else {
                            replaceSubrecord = true;
                        }
                    }
                    if (!replaceSubrecord) break;
                    String modb = null;
                    String modt = null;
                    if (subrecordType.equals("MODL")) {
                        modb = "MODB";
                        modt = "MODT";
                    } else if (subrecordType.equals("MOD2")) {
                        modb = "MO2B";
                        modt = "MO2T";
                    } else if (subrecordType.equals("MOD3")) {
                        modb = "MO3B";
                        modt = "MO3T";
                    } else if (subrecordType.equals("MOD4")) {
                        modb = "MO4B";
                        modt = "MO4T";
                    }
                    mlit.set(subrecord);
                    if (modb != null && lit.hasNext()) {
                        subrecord = lit.next();
                        if (subrecord.getSubrecordType().equals(modb)) {
                            if (mlit.hasNext()) {
                                mergedSubrecord = mlit.next();
                                if (mergedSubrecord.getSubrecordType().equals(modb)) {
                                    mlit.set(subrecord);
                                } else {
                                    mlit.previous();
                                    mlit.add(subrecord);
                                }
                            } else {
                                mlit.add(subrecord);
                            }
                        } else {
                            lit.previous();
                        }
                    }
                    if (modt != null && lit.hasNext()) {
                        subrecord = lit.next();
                        if (subrecord.getSubrecordType().equals(modt)) {
                            if (mlit.hasNext()) {
                                mergedSubrecord = mlit.next();
                                if (mergedSubrecord.getSubrecordType().equals(modt)) {
                                    mlit.set(subrecord);
                                } else {
                                    mlit.previous();
                                    mlit.add(subrecord);
                                }
                            } else {
                                mlit.add(subrecord);
                            }
                        } else {
                            lit.previous();
                        }
                    }
                    modifiedMergedList = true;
                    break;
                }
                if (foundSubrecord) continue;
                String modb = null;
                String modt = null;
                if (subrecordType.equals("MODL")) {
                    modb = "MODB";
                    modt = "MODT";
                } else if (subrecordType.equals("MOD2")) {
                    modb = "MO2B";
                    modt = "MO2T";
                } else if (subrecordType.equals("MOD3")) {
                    modb = "MO3B";
                    modt = "MO3T";
                } else if (subrecordType.equals("MOD4")) {
                    modb = "MO4B";
                    modt = "MO4T";
                }
                if (subrecordType.equals("FULL")) {
                    mergedSubrecordList.add(1, subrecord);
                } else {
                    mergedSubrecordList.add(subrecord);
                }
                if (modb != null && lit.hasNext()) {
                    subrecord = lit.next();
                    if (subrecord.getSubrecordType().equals(modb)) {
                        mergedSubrecordList.add(subrecord);
                    } else {
                        lit.previous();
                    }
                }
                if (modt != null && lit.hasNext()) {
                    subrecord = lit.next();
                    if (subrecord.getSubrecordType().equals(modt)) {
                        mergedSubrecordList.add(subrecord);
                    } else {
                        lit.previous();
                    }
                }
                modifiedMergedList = true;
            }
            if (modifiedMergedList) {
                mergedRecord.setSubrecords(mergedSubrecordList);
            }
        }

        private boolean mergeArray(String subrecordType, int entrySize, List<PluginSubrecord> mergedSubrecordList, List<PluginSubrecord> subrecordList) throws IOException {
            boolean modifiedMergedList = false;
            for (PluginSubrecord subrecord : subrecordList) {
                if (!subrecord.getSubrecordType().equals(subrecordType)) continue;
                boolean addSubrecord = true;
                boolean replaceSubrecordData = false;
                byte[] subrecordData = subrecord.getSubrecordData();
                for (PluginSubrecord mergedSubrecord : mergedSubrecordList) {
                    if (!mergedSubrecord.getSubrecordType().equals(subrecordType)) continue;
                    addSubrecord = false;
                    byte[] mergedSubrecordData = mergedSubrecord.getSubrecordData();
                    for (int offset = 0; offset < subrecordData.length; offset += entrySize) {
                        boolean addReference = true;
                        int reference = subrecordData[offset] & 0xFF | (subrecordData[offset + 1] & 0xFF) << 8 | (subrecordData[offset + 2] & 0xFF) << 16 | (subrecordData[offset + 3] & 0xFF) << 24;
                        for (int mergedOffset = 0; mergedOffset < mergedSubrecordData.length; mergedOffset += entrySize) {
                            int mergedReference = mergedSubrecordData[mergedOffset] & 0xFF | (mergedSubrecordData[mergedOffset + 1] & 0xFF) << 8 | (mergedSubrecordData[mergedOffset + 2] & 0xFF) << 16 | (mergedSubrecordData[mergedOffset + 3] & 0xFF) << 24;
                            if (reference != mergedReference) continue;
                            addReference = false;
                            break;
                        }
                        if (!addReference) continue;
                        int length = mergedSubrecordData.length;
                        byte[] newSubrecordData = new byte[length + entrySize];
                        System.arraycopy(mergedSubrecordData, 0, newSubrecordData, 0, length);
                        System.arraycopy(subrecordData, offset, newSubrecordData, length, entrySize);
                        mergedSubrecordData = newSubrecordData;
                        replaceSubrecordData = true;
                    }
                    if (!replaceSubrecordData) break;
                    mergedSubrecord.setSubrecordData(mergedSubrecordData);
                    modifiedMergedList = true;
                    break;
                }
                if (!addSubrecord) break;
                mergedSubrecordList.add(subrecord);
                modifiedMergedList = true;
                break;
            }
            modifiedMergedList = true;
            return true;
        }

        private boolean mergeList(String subrecordType, List<PluginSubrecord> mergedSubrecordList, List<PluginSubrecord> subrecordList) throws IOException {
            boolean modifiedMergedList = false;
            for (PluginSubrecord subrecord : subrecordList) {
                if (!subrecord.getSubrecordType().equals(subrecordType)) continue;
                byte[] subrecordData = subrecord.getSubrecordData();
                int subrecordID = subrecordData[0] & 0xFF | (subrecordData[1] & 0xFF) << 8 | (subrecordData[2] & 0xFF) << 16 | (subrecordData[3] & 0xFF) << 24;
                boolean insertSubrecord = true;
                boolean foundSubrecord = false;
                int index = 0;
                for (PluginSubrecord mergedSubrecord : mergedSubrecordList) {
                    if (mergedSubrecord.getSubrecordType().equals(subrecordType)) {
                        foundSubrecord = true;
                        subrecordData = mergedSubrecord.getSubrecordData();
                        int mergedSubrecordID = subrecordData[0] & 0xFF | (subrecordData[1] & 0xFF) << 8 | (subrecordData[2] & 0xFF) << 16 | (subrecordData[3] & 0xFF) << 24;
                        if (subrecordID == mergedSubrecordID) {
                            insertSubrecord = false;
                            break;
                        }
                    } else if (foundSubrecord) break;
                    ++index;
                }
                if (!insertSubrecord) continue;
                mergedSubrecordList.add(index, subrecord);
                modifiedMergedList = true;
            }
            return modifiedMergedList;
        }

        private void mergeBirthsign(PluginRecord mergedRecord, PluginRecord record) throws DataFormatException, IOException, PluginException {
            boolean modifiedMergedList = false;
            String[] exclusionList = new String[]{"SPLO"};
            this.mergeSubrecords(mergedRecord, record, exclusionList);
            List<PluginSubrecord> mergedSubrecordList = mergedRecord.getSubrecords();
            List<PluginSubrecord> subrecordList = record.getSubrecords();
            if (this.mergeList("SPLO", mergedSubrecordList, subrecordList)) {
                modifiedMergedList = true;
            }
            if (modifiedMergedList) {
                mergedRecord.setSubrecords(mergedSubrecordList);
            }
        }

        private void mergeContainer(PluginRecord mergedRecord, PluginRecord record) throws DataFormatException, IOException, PluginException {
            boolean modifiedMergedList = false;
            String[] exclusionList = new String[]{"CNTO"};
            this.mergeSubrecords(mergedRecord, record, exclusionList);
            List<PluginSubrecord> mergedSubrecordList = mergedRecord.getSubrecords();
            List<PluginSubrecord> subrecordList = record.getSubrecords();
            if (this.mergeList("CNTO", mergedSubrecordList, subrecordList)) {
                modifiedMergedList = true;
            }
            if (modifiedMergedList) {
                mergedRecord.setSubrecords(mergedSubrecordList);
            }
        }

        private void mergeEnchantment(PluginRecord mergedRecord, PluginRecord record) throws DataFormatException, IOException, PluginException {
            String recordType = record.getRecordType();
            boolean modifiedMergedList = false;
            int pluginField1 = 0;
            int pluginField2 = 0;
            boolean autoCalculate = true;
            String[] exclusionList = new String[]{"EFID", "EFIT", "ENIT", "SCIT", "SPIT"};
            this.mergeSubrecords(mergedRecord, record, exclusionList);
            List<PluginSubrecord> mergedSubrecordList = mergedRecord.getSubrecords();
            List<PluginSubrecord> subrecordList = record.getSubrecords();
            ListIterator<PluginSubrecord> lit = subrecordList.listIterator();
            while (lit.hasNext()) {
                byte[] subrecordData;
                PluginSubrecord subrecord = lit.next();
                String subrecordType = subrecord.getSubrecordType();
                if (subrecordType.equals("ENIT")) {
                    subrecordData = subrecord.getSubrecordData();
                    if (recordType.equals("ALCH") || recordType.equals("INGR")) {
                        pluginField1 = subrecordData[0] & 0xFF | (subrecordData[1] & 0xFF) << 8 | (subrecordData[2] & 0xFF) << 16 | (subrecordData[3] & 0xFF) << 24;
                        if ((subrecordData[4] & 1) == 0) continue;
                        autoCalculate = false;
                        continue;
                    }
                    pluginField1 = subrecordData[4] & 0xFF | (subrecordData[5] & 0xFF) << 8 | (subrecordData[6] & 0xFF) << 16 | (subrecordData[7] & 0xFF) << 24;
                    pluginField2 = subrecordData[8] & 0xFF | (subrecordData[9] & 0xFF) << 8 | (subrecordData[10] & 0xFF) << 16 | (subrecordData[11] & 0xFF) << 24;
                    if ((subrecordData[12] & 1) == 0) continue;
                    autoCalculate = false;
                    continue;
                }
                if (subrecordType.equals("SPIT")) {
                    subrecordData = subrecord.getSubrecordData();
                    pluginField1 = subrecordData[4] & 0xFF | (subrecordData[5] & 0xFF) << 8 | (subrecordData[6] & 0xFF) << 16 | (subrecordData[7] & 0xFF) << 24;
                    pluginField2 = subrecordData[8] & 0xFF | (subrecordData[9] & 0xFF) << 8 | (subrecordData[10] & 0xFF) << 16 | (subrecordData[11] & 0xFF) << 24;
                    if ((subrecordData[12] & 1) == 0) continue;
                    autoCalculate = false;
                    continue;
                }
                if (!subrecordType.equals("EFIT")) continue;
                subrecordData = subrecord.getSubrecordData();
                boolean addEffect = true;
                String effectName = new String(subrecordData, 0, 4);
                int effectSubtype = subrecordData[20] & 0xFF | (subrecordData[21] & 0xFF) << 8 | (subrecordData[22] & 0xFF) << 16 | (subrecordData[23] & 0xFF) << 24;
                PluginSubrecord scitSubrecord = null;
                PluginSubrecord fullSubrecord = null;
                int scriptID = 0;
                if (effectName.equals("SEFF")) {
                    if (lit.hasNext()) {
                        scitSubrecord = lit.next();
                        if (scitSubrecord.getSubrecordType().equals("SCIT")) {
                            byte[] scitSubrecordData = scitSubrecord.getSubrecordData();
                            scriptID = scitSubrecordData[0] & 0xFF | (scitSubrecordData[1] & 0xFF) << 8 | (scitSubrecordData[2] & 0xFF) << 16 | (scitSubrecordData[3] & 0xFF) << 24;
                            if (lit.hasNext() && !(fullSubrecord = lit.next()).getSubrecordType().equals("FULL")) {
                                lit.previous();
                                fullSubrecord = null;
                            }
                        } else {
                            scitSubrecord = null;
                        }
                    }
                    if (scitSubrecord == null) {
                        throw new PluginException("SCIT subrecord missing for script effect");
                    }
                }
                ListIterator<PluginSubrecord> mlit = mergedSubrecordList.listIterator();
                while (mlit.hasNext()) {
                    PluginSubrecord mergedSubrecord = mlit.next();
                    if (!mergedSubrecord.getSubrecordType().equals("EFIT")) continue;
                    byte[] mergedSubrecordData = mergedSubrecord.getSubrecordData();
                    String mergedEffectName = new String(mergedSubrecordData, 0, 4);
                    int mergedEffectSubtype = mergedSubrecordData[20] & 0xFF | (mergedSubrecordData[21] & 0xFF) << 8 | (mergedSubrecordData[22] & 0xFF) << 16 | (mergedSubrecordData[23] & 0xFF) << 24;
                    if (!mergedEffectName.equals(effectName)) continue;
                    if (effectName.equals("SEFF")) {
                        PluginSubrecord mscitSubrecord = null;
                        if (mlit.hasNext()) {
                            mscitSubrecord = mlit.next();
                            if (mscitSubrecord.getSubrecordType().equals("SCIT")) {
                                mergedSubrecordData = mscitSubrecord.getSubrecordData();
                                int mergedScriptID = mergedSubrecordData[0] & 0xFF | (mergedSubrecordData[1] & 0xFF) << 8 | (mergedSubrecordData[2] & 0xFF) << 16 | (mergedSubrecordData[3] & 0xFF) << 24;
                                if (mergedScriptID == scriptID) {
                                    addEffect = false;
                                    break;
                                }
                            } else {
                                mscitSubrecord = null;
                            }
                        }
                        if (mscitSubrecord != null) continue;
                        throw new PluginException("SCIT subrecord missing for script effect");
                    }
                    if (mergedEffectSubtype != effectSubtype) continue;
                    addEffect = false;
                    break;
                }
                if (!addEffect) continue;
                byte[] mergedSubrecordData = new byte[]{subrecordData[0], subrecordData[1], subrecordData[2], subrecordData[3]};
                mergedSubrecordList.add(new PluginSubrecord(recordType, "EFID", mergedSubrecordData));
                mergedSubrecordList.add(subrecord);
                if (scitSubrecord != null) {
                    mergedSubrecordList.add(scitSubrecord);
                    if (fullSubrecord != null) {
                        mergedSubrecordList.add(fullSubrecord);
                    }
                }
                modifiedMergedList = true;
            }
            if (modifiedMergedList) {
                for (PluginSubrecord subrecord : mergedSubrecordList) {
                    String subrecordType = subrecord.getSubrecordType();
                    if (!subrecordType.equals("ENIT") && !subrecordType.equals("SPIT")) continue;
                    byte[] subrecordData = subrecord.getSubrecordData();
                    if (recordType.equals("ALCH") || recordType.equals("INGR")) {
                        int mergedField1 = subrecordData[0] & 0xFF | (subrecordData[1] & 0xFF) << 8 | (subrecordData[2] & 0xFF) << 16 | (subrecordData[3] & 0xFF) << 24;
                        mergedField1 = Math.max(pluginField1, mergedField1);
                        subrecordData[0] = (byte)mergedField1;
                        subrecordData[1] = (byte)(mergedField1 >>> 8);
                        subrecordData[2] = (byte)(mergedField1 >>> 16);
                        subrecordData[3] = (byte)(mergedField1 >>> 24);
                        if (autoCalculate) break;
                        subrecordData[4] = (byte)(subrecordData[4] | 1);
                        break;
                    }
                    int mergedField1 = subrecordData[4] & 0xFF | (subrecordData[5] & 0xFF) << 8 | (subrecordData[6] & 0xFF) << 16 | (subrecordData[7] & 0xFF) << 24;
                    int mergedField2 = subrecordData[8] & 0xFF | (subrecordData[9] & 0xFF) << 8 | (subrecordData[10] & 0xFF) << 16 | (subrecordData[11] & 0xFF) << 24;
                    mergedField1 = Math.max(pluginField1, mergedField1);
                    mergedField2 = Math.max(pluginField2, mergedField2);
                    subrecordData[4] = (byte)mergedField1;
                    subrecordData[5] = (byte)(mergedField1 >>> 8);
                    subrecordData[6] = (byte)(mergedField1 >>> 16);
                    subrecordData[7] = (byte)(mergedField1 >>> 24);
                    subrecordData[8] = (byte)mergedField2;
                    subrecordData[9] = (byte)(mergedField2 >>> 8);
                    subrecordData[10] = (byte)(mergedField2 >>> 16);
                    subrecordData[11] = (byte)(mergedField2 >>> 24);
                    if (autoCalculate) break;
                    subrecordData[12] = (byte)(subrecordData[12] | 1);
                    break;
                }
            }
            if (modifiedMergedList) {
                mergedRecord.setSubrecords(mergedSubrecordList);
            }
        }

        private void mergeFaction(PluginRecord mergedRecord, PluginRecord record) throws DataFormatException, IOException, PluginException {
            boolean modifiedMergedList = false;
            String[] exclusionList = new String[]{"FNAM", "INAM", "MNAM", "RNAM", "XNAM"};
            this.mergeSubrecords(mergedRecord, record, exclusionList);
            int formID = mergedRecord.getFormID();
            int masterID = formID >>> 24;
            if (masterID >= this.mergedMasterCount) {
                throw new PluginException("Merged master ID " + masterID + " is not valid");
            }
            Master master = this.masters[masterID];
            PluginRecord masterRecord = master.getRecord(formID);
            List<PluginSubrecord> masterSubrecordList = masterRecord.getSubrecords();
            List<PluginSubrecord> mergedSubrecordList = mergedRecord.getSubrecords();
            List<PluginSubrecord> subrecordList = record.getSubrecords();
            int ranks = 0;
            int mergedRanks = 0;
            int masterRanks = 0;
            for (PluginSubrecord subrecord : subrecordList) {
                if (!subrecord.getSubrecordType().equals("RNAM")) continue;
                ++ranks;
            }
            for (PluginSubrecord subrecord : mergedSubrecordList) {
                if (!subrecord.getSubrecordType().equals("RNAM")) continue;
                ++mergedRanks;
            }
            for (PluginSubrecord subrecord : masterSubrecordList) {
                if (!subrecord.getSubrecordType().equals("RNAM")) continue;
                ++masterRanks;
            }
            boolean keepFirst = true;
            if (mergedRanks == masterRanks) {
                if (ranks != masterRanks) {
                    keepFirst = false;
                } else if (MergeTask.this.masterMerge || !MergeTask.this.pluginInfo.shouldDeleteLastConflict()) {
                    keepFirst = false;
                }
            } else if (ranks != masterRanks && (MergeTask.this.masterMerge || !MergeTask.this.pluginInfo.shouldDeleteLastConflict())) {
                keepFirst = false;
            }
            if (!keepFirst) {
                modifiedMergedList = true;
                ListIterator<PluginSubrecord> lit = mergedSubrecordList.listIterator();
                while (lit.hasNext()) {
                    PluginSubrecord subrecord = lit.next();
                    String subrecordType = subrecord.getSubrecordType();
                    if (!subrecordType.equals("RNAM") && !subrecordType.equals("MNAM") && !subrecordType.equals("FNAM") && !subrecordType.equals("INAM")) continue;
                    lit.remove();
                }
                for (PluginSubrecord subrecord : subrecordList) {
                    String subrecordType = subrecord.getSubrecordType();
                    if (!subrecordType.equals("RNAM") && !subrecordType.equals("MNAM") && !subrecordType.equals("FNAM") && !subrecordType.equals("INAM")) continue;
                    mergedSubrecordList.add(subrecord);
                }
            }
            for (PluginSubrecord subrecord : subrecordList) {
                if (!subrecord.getSubrecordType().equals("XNAM")) continue;
                byte[] subrecordData = subrecord.getSubrecordData();
                int faction = subrecordData[0] & 0xFF | (subrecordData[1] & 0xFF) << 8 | (subrecordData[2] & 0xFF) << 16 | (subrecordData[3] & 0xFF) << 24;
                boolean insertSubrecord = true;
                boolean foundSubrecord = false;
                int index = 0;
                for (PluginSubrecord mergedSubrecord : mergedSubrecordList) {
                    if (mergedSubrecord.getSubrecordType().equals("XNAM")) {
                        foundSubrecord = true;
                        subrecordData = mergedSubrecord.getSubrecordData();
                        int mergedFaction = subrecordData[0] & 0xFF | (subrecordData[1] & 0xFF) << 8 | (subrecordData[2] & 0xFF) << 16 | (subrecordData[3] & 0xFF) << 24;
                        if (faction == mergedFaction) {
                            if (subrecord.equals(mergedSubrecord)) {
                                insertSubrecord = false;
                                break;
                            }
                            if (masterSubrecordList.indexOf(mergedSubrecord) < 0) {
                                if (masterSubrecordList.indexOf(subrecord) < 0) {
                                    if (MergeTask.this.masterMerge || !MergeTask.this.pluginInfo.shouldDeleteLastConflict()) {
                                        mergedSubrecordList.remove(index);
                                        break;
                                    }
                                    insertSubrecord = false;
                                    break;
                                }
                                insertSubrecord = false;
                                break;
                            }
                            mergedSubrecordList.remove(index);
                            break;
                        }
                    } else if (foundSubrecord) break;
                    ++index;
                }
                if (!insertSubrecord) continue;
                mergedSubrecordList.add(index, subrecord);
                modifiedMergedList = true;
            }
            if (modifiedMergedList) {
                mergedRecord.setSubrecords(mergedSubrecordList);
            }
        }

        private void mergeLeveledList(PluginRecord mergedRecord, PluginRecord record) throws DataFormatException, IOException, PluginException {
            String recordType = record.getRecordType();
            int formID = mergedRecord.getFormID();
            int masterID = formID >>> 24;
            if (masterID >= this.mergedMasterCount) {
                throw new PluginException("Merged leveled list master ID " + masterID + " is not valid");
            }
            Master master = this.masters[masterID];
            PluginRecord masterRecord = master.getRecord(formID);
            List<PluginSubrecord> masterSubrecordList = masterRecord.getSubrecords();
            List<PluginSubrecord> mergedSubrecordList = mergedRecord.getSubrecords();
            List<PluginSubrecord> subrecordList = record.getSubrecords();
            boolean foundFlags = false;
            int chanceIndex = -1;
            int subrecordIndex = 0;
            for (PluginSubrecord masterSubrecord : masterSubrecordList) {
                if (masterSubrecord.getSubrecordType().equals("LVLF")) {
                    foundFlags = true;
                    break;
                }
                if (masterSubrecord.getSubrecordType().equals("LVLD")) {
                    chanceIndex = subrecordIndex;
                }
                ++subrecordIndex;
            }
            if (!foundFlags) {
                byte[] chanceData;
                if (chanceIndex < 0) {
                    byte[] flagsData = new byte[]{0};
                    masterSubrecordList.add(new PluginSubrecord(recordType, "LVLF", flagsData));
                    chanceData = new byte[]{0};
                    masterSubrecordList.add(new PluginSubrecord(recordType, "LVLD", chanceData));
                } else {
                    PluginSubrecord chanceSubrecord = masterSubrecordList.get(chanceIndex);
                    chanceData = chanceSubrecord.getSubrecordData();
                    byte[] flagsData = new byte[]{(byte)((chanceData[0] & 0xFF) >>> 7)};
                    chanceData[0] = (byte)(chanceData[0] & 0x7F);
                    masterSubrecordList.add(new PluginSubrecord(recordType, "LVLF", flagsData));
                }
            }
            for (PluginSubrecord subrecord : subrecordList) {
                boolean foundSubrecord = false;
                String subrecordType = subrecord.getSubrecordType();
                if (subrecordType.equals("LVLO")) continue;
                for (PluginSubrecord mergedSubrecord : mergedSubrecordList) {
                    if (!mergedSubrecord.getSubrecordType().equals(subrecordType)) continue;
                    foundSubrecord = true;
                    boolean replaceSubrecord = false;
                    if (!mergedSubrecord.equals(subrecord)) {
                        int mergedIndex = masterSubrecordList.indexOf(mergedSubrecord);
                        int index = masterSubrecordList.indexOf(subrecord);
                        if (mergedIndex < 0) {
                            if (index < 0 && (MergeTask.this.masterMerge || !MergeTask.this.pluginInfo.shouldDeleteLastConflict())) {
                                replaceSubrecord = true;
                            }
                        } else {
                            replaceSubrecord = true;
                        }
                    }
                    if (!replaceSubrecord) break;
                    int index = mergedSubrecordList.indexOf(mergedSubrecord);
                    mergedSubrecordList.remove(index);
                    mergedSubrecordList.add(index, subrecord);
                    break;
                }
                if (foundSubrecord) continue;
                mergedSubrecordList.add(subrecord);
            }
            for (PluginSubrecord subrecord : subrecordList) {
                if (!subrecord.getSubrecordType().equals("LVLO")) continue;
                byte[] subrecordData = subrecord.getSubrecordData();
                int itemLevel = subrecordData[0] & 0xFF | (subrecordData[1] & 0xFF) << 8;
                int itemID = subrecordData[4] & 0xFF | (subrecordData[5] & 0xFF) << 8 | (subrecordData[6] & 0xFF) << 16 | (subrecordData[7] & 0xFF) << 24;
                boolean duplicate = false;
                int index = 0;
                for (PluginSubrecord mergedSubrecord : mergedSubrecordList) {
                    if (mergedSubrecord.getSubrecordType().equals("LVLO")) {
                        byte[] mergedSubrecordData = mergedSubrecord.getSubrecordData();
                        int mergedItemLevel = mergedSubrecordData[0] & 0xFF | (mergedSubrecordData[1] & 0xFF) << 8;
                        int mergedItemID = mergedSubrecordData[4] & 0xFF | (mergedSubrecordData[5] & 0xFF) << 8 | (mergedSubrecordData[6] & 0xFF) << 16 | (mergedSubrecordData[7] & 0xFF) << 24;
                        if (mergedItemLevel > itemLevel) break;
                        if (mergedItemLevel == itemLevel && mergedItemID == itemID) {
                            duplicate = true;
                            break;
                        }
                    }
                    ++index;
                }
                if (duplicate) continue;
                mergedSubrecordList.add(index, subrecord);
            }
            mergedRecord.setSubrecords(mergedSubrecordList);
        }

        private void mergeNPC(PluginRecord mergedRecord, PluginRecord record) throws DataFormatException, IOException, PluginException {
            boolean modifiedMergedList = false;
            String[] exclusionList = new String[]{"CNTO", "PKID", "SNAM", "SPLO"};
            this.mergeSubrecords(mergedRecord, record, exclusionList);
            List<PluginSubrecord> mergedSubrecordList = mergedRecord.getSubrecords();
            List<PluginSubrecord> subrecordList = record.getSubrecords();
            if (this.mergeList("CNTO", mergedSubrecordList, subrecordList)) {
                modifiedMergedList = true;
            }
            if (this.mergeList("PKID", mergedSubrecordList, subrecordList)) {
                modifiedMergedList = true;
            }
            if (this.mergeList("SNAM", mergedSubrecordList, subrecordList)) {
                modifiedMergedList = true;
            }
            if (this.mergeList("SPLO", mergedSubrecordList, subrecordList)) {
                modifiedMergedList = true;
            }
            if (modifiedMergedList) {
                mergedRecord.setSubrecords(mergedSubrecordList);
            }
        }

        private void mergeRace(PluginRecord mergedRecord, PluginRecord record) throws DataFormatException, IOException, PluginException {
            List<PluginSubrecord> subrecordList;
            boolean modifiedMergedList = false;
            String[] exclusionList = new String[]{"ENAM", "FNAM", "HNAM", "ICON", "INDX", "MNAM", "MODB", "MODL", "NAM0", "NAM1", "SPLO", "XNAM"};
            this.mergeSubrecords(mergedRecord, record, exclusionList);
            int formID = mergedRecord.getFormID();
            int masterID = formID >>> 24;
            if (masterID >= this.mergedMasterCount) {
                throw new PluginException("Merged master ID " + masterID + " is not valid");
            }
            Master master = this.masters[masterID];
            PluginRecord masterRecord = master.getRecord(formID);
            List<PluginSubrecord> masterSubrecordList = masterRecord.getSubrecords();
            List<PluginSubrecord> mergedSubrecordList = mergedRecord.getSubrecords();
            if (this.mergeList("SPLO", mergedSubrecordList, subrecordList = record.getSubrecords())) {
                modifiedMergedList = true;
            }
            for (PluginSubrecord subrecord : subrecordList) {
                if (!subrecord.getSubrecordType().equals("XNAM")) continue;
                byte[] subrecordData = subrecord.getSubrecordData();
                int raceID = subrecordData[0] & 0xFF | (subrecordData[1] & 0xFF) << 8 | (subrecordData[2] & 0xFF) << 16 | (subrecordData[3] & 0xFF) << 24;
                int modifier = subrecordData[4] & 0xFF | (subrecordData[5] & 0xFF) << 8 | (subrecordData[6] & 0xFF) << 16 | (subrecordData[7] & 0xFF) << 24;
                boolean insertSubrecord = true;
                boolean foundSubrecord = false;
                int index = 0;
                for (PluginSubrecord mergedSubrecord : mergedSubrecordList) {
                    if (mergedSubrecord.getSubrecordType().equals("XNAM")) {
                        foundSubrecord = true;
                        subrecordData = mergedSubrecord.getSubrecordData();
                        int mergedRaceID = subrecordData[0] & 0xFF | (subrecordData[1] & 0xFF) << 8 | (subrecordData[2] & 0xFF) << 16 | (subrecordData[3] & 0xFF) << 24;
                        int mergedModifier = subrecordData[4] & 0xFF | (subrecordData[5] & 0xFF) << 8 | (subrecordData[6] & 0xFF) << 16 | (subrecordData[7] & 0xFF) << 24;
                        if (raceID == mergedRaceID) {
                            if (subrecord.equals(mergedSubrecord)) {
                                insertSubrecord = false;
                                break;
                            }
                            if (masterSubrecordList.indexOf(mergedSubrecord) < 0) {
                                if (masterSubrecordList.indexOf(subrecord) < 0) {
                                    if (MergeTask.this.masterMerge || !MergeTask.this.pluginInfo.shouldDeleteLastConflict()) {
                                        mergedSubrecordList.remove(index);
                                        break;
                                    }
                                    insertSubrecord = false;
                                    break;
                                }
                                insertSubrecord = false;
                                break;
                            }
                            mergedSubrecordList.remove(index);
                            break;
                        }
                    } else if (foundSubrecord) break;
                    ++index;
                }
                if (!insertSubrecord) continue;
                mergedSubrecordList.add(index, subrecord);
                modifiedMergedList = true;
            }
            if (this.mergeArray("ENAM", 4, mergedSubrecordList, subrecordList)) {
                modifiedMergedList = true;
            }
            if (this.mergeArray("HNAM", 4, mergedSubrecordList, subrecordList)) {
                modifiedMergedList = true;
            }
            if (this.mergeFaceData(subrecordList, mergedSubrecordList, masterSubrecordList)) {
                modifiedMergedList = true;
            }
            if (this.mergeBodyData(subrecordList, mergedSubrecordList, masterSubrecordList)) {
                modifiedMergedList = true;
            }
            if (modifiedMergedList) {
                mergedRecord.setSubrecords(mergedSubrecordList);
            }
        }

        private boolean mergeFaceData(List<PluginSubrecord> subrecordList, List<PluginSubrecord> mergedSubrecordList, List<PluginSubrecord> masterSubrecordList) throws PluginException {
            String subrecordType;
            boolean modifiedMergedList = false;
            boolean foundList = false;
            int count = 0;
            for (PluginSubrecord subrecord : subrecordList) {
                subrecordType = subrecord.getSubrecordType();
                if (subrecordType.equals("NAM1")) {
                    if (foundList) break;
                    throw new PluginException("Face data does not precede body data");
                }
                if (!foundList) {
                    if (!subrecordType.equals("NAM0")) continue;
                    foundList = true;
                    continue;
                }
                if (!subrecordType.equals("INDX")) continue;
                ++count;
            }
            PluginSubrecord[] indx = new PluginSubrecord[count];
            PluginSubrecord[] modl = new PluginSubrecord[count];
            PluginSubrecord[] modb = new PluginSubrecord[count];
            PluginSubrecord[] icon = new PluginSubrecord[count];
            int index = -1;
            foundList = false;
            for (PluginSubrecord subrecord : subrecordList) {
                subrecordType = subrecord.getSubrecordType();
                if (!foundList) {
                    if (!subrecordType.equals("NAM0")) continue;
                    foundList = true;
                    continue;
                }
                if (subrecordType.equals("INDX")) {
                    indx[++index] = subrecord;
                    continue;
                }
                if (subrecordType.equals("MODL")) {
                    modl[index] = subrecord;
                    continue;
                }
                if (subrecordType.equals("MODB")) {
                    modb[index] = subrecord;
                    continue;
                }
                if (!subrecordType.equals("ICON")) break;
                icon[index] = subrecord;
            }
            foundList = false;
            count = 0;
            for (PluginSubrecord subrecord : mergedSubrecordList) {
                subrecordType = subrecord.getSubrecordType();
                if (subrecordType.equals("NAM1")) {
                    if (foundList) break;
                    throw new PluginException("Face data does not precede body data");
                }
                if (!foundList) {
                    if (!subrecordType.equals("NAM0")) continue;
                    foundList = true;
                    continue;
                }
                if (!subrecordType.equals("INDX")) continue;
                ++count;
            }
            PluginSubrecord[] mindx = new PluginSubrecord[count];
            PluginSubrecord[] mmodl = new PluginSubrecord[count];
            PluginSubrecord[] mmodb = new PluginSubrecord[count];
            PluginSubrecord[] micon = new PluginSubrecord[count];
            index = -1;
            foundList = false;
            for (PluginSubrecord subrecord : mergedSubrecordList) {
                subrecordType = subrecord.getSubrecordType();
                if (!foundList) {
                    if (!subrecordType.equals("NAM0")) continue;
                    foundList = true;
                    continue;
                }
                if (subrecordType.equals("INDX")) {
                    mindx[++index] = subrecord;
                    continue;
                }
                if (subrecordType.equals("MODL")) {
                    mmodl[index] = subrecord;
                    continue;
                }
                if (subrecordType.equals("MODB")) {
                    mmodb[index] = subrecord;
                    continue;
                }
                if (!subrecordType.equals("ICON")) break;
                micon[index] = subrecord;
            }
            foundList = false;
            count = 0;
            for (PluginSubrecord subrecord : masterSubrecordList) {
                subrecordType = subrecord.getSubrecordType();
                if (subrecordType.equals("NAM1")) {
                    if (foundList) break;
                    throw new PluginException("Face data does not precede body data");
                }
                if (!foundList) {
                    if (!subrecordType.equals("NAM0")) continue;
                    foundList = true;
                    continue;
                }
                if (!subrecordType.equals("INDX")) continue;
                ++count;
            }
            PluginSubrecord[] xindx = new PluginSubrecord[count];
            PluginSubrecord[] xmodl = new PluginSubrecord[count];
            PluginSubrecord[] xmodb = new PluginSubrecord[count];
            PluginSubrecord[] xicon = new PluginSubrecord[count];
            index = -1;
            foundList = false;
            for (PluginSubrecord subrecord : masterSubrecordList) {
                subrecordType = subrecord.getSubrecordType();
                if (!foundList) {
                    if (!subrecordType.equals("NAM0")) continue;
                    foundList = true;
                    continue;
                }
                if (subrecordType.equals("INDX")) {
                    xindx[++index] = subrecord;
                    continue;
                }
                if (subrecordType.equals("MODL")) {
                    xmodl[index] = subrecord;
                    continue;
                }
                if (subrecordType.equals("MODB")) {
                    xmodb[index] = subrecord;
                    continue;
                }
                if (!subrecordType.equals("ICON")) break;
                xicon[index] = subrecord;
            }
            if (indx.length != mindx.length || indx.length != xindx.length) {
                throw new PluginException("Face data maximum index values are not the same");
            }
            boolean rebuildMergedData = false;
            for (int i = 0; i < indx.length; ++i) {
                if (!indx[i].equals(mindx[i]) || !indx[i].equals(xindx[i])) {
                    throw new PluginException("Incorrect face data index progression");
                }
                if (modl[i] != null) {
                    if (mmodl[i] != null) {
                        if (!modl[i].equals(mmodl[i])) {
                            if (xmodl[i] != null) {
                                if (!modl[i].equals(xmodl[i])) {
                                    if (!mmodl[i].equals(xmodl[i])) {
                                        if (MergeTask.this.masterMerge || !MergeTask.this.pluginInfo.shouldDeleteLastConflict()) {
                                            mmodl[i] = modl[i];
                                            rebuildMergedData = true;
                                        }
                                    } else {
                                        mmodl[i] = modl[i];
                                        rebuildMergedData = true;
                                    }
                                }
                            } else if (MergeTask.this.masterMerge || !MergeTask.this.pluginInfo.shouldDeleteLastConflict()) {
                                mmodl[i] = modl[i];
                                rebuildMergedData = true;
                            }
                        }
                    } else {
                        mmodl[i] = modl[i];
                        rebuildMergedData = true;
                    }
                }
                if (icon[i] == null) continue;
                if (micon[i] != null) {
                    if (icon[i].equals(micon[i])) continue;
                    if (xicon[i] != null) {
                        if (icon[i].equals(xicon[i])) continue;
                        if (!micon[i].equals(xicon[i])) {
                            if (!MergeTask.this.masterMerge && MergeTask.this.pluginInfo.shouldDeleteLastConflict()) continue;
                            micon[i] = icon[i];
                            rebuildMergedData = true;
                            continue;
                        }
                        micon[i] = icon[i];
                        rebuildMergedData = true;
                        continue;
                    }
                    if (!MergeTask.this.masterMerge && MergeTask.this.pluginInfo.shouldDeleteLastConflict()) continue;
                    micon[i] = icon[i];
                    rebuildMergedData = true;
                    continue;
                }
                micon[i] = icon[i];
                rebuildMergedData = true;
            }
            if (rebuildMergedData) {
                modifiedMergedList = true;
                index = 0;
                foundList = false;
                ListIterator<PluginSubrecord> lit = mergedSubrecordList.listIterator();
                while (lit.hasNext()) {
                    PluginSubrecord subrecord = lit.next();
                    subrecordType = subrecord.getSubrecordType();
                    if (foundList) {
                        if (!subrecordType.equals("INDX") && !subrecordType.equals("MODL") && !subrecordType.equals("MODB") && !subrecordType.equals("ICON")) break;
                        lit.remove();
                        continue;
                    }
                    if (subrecordType.equals("NAM0")) {
                        foundList = true;
                        lit.remove();
                        continue;
                    }
                    ++index;
                }
                for (int i = mindx.length - 1; i >= 0; --i) {
                    if (micon[i] != null) {
                        mergedSubrecordList.add(index, micon[i]);
                    }
                    if (mmodb[i] != null) {
                        mergedSubrecordList.add(index, mmodb[i]);
                    }
                    if (mmodl[i] != null) {
                        mergedSubrecordList.add(index, mmodl[i]);
                    }
                    mergedSubrecordList.add(index, mindx[i]);
                }
                byte[] subrecordData = new byte[]{};
                mergedSubrecordList.add(index, new PluginSubrecord("RACE", "NAM0", subrecordData));
            }
            return modifiedMergedList;
        }

        private boolean mergeBodyData(List<PluginSubrecord> subrecordList, List<PluginSubrecord> mergedSubrecordList, List<PluginSubrecord> masterSubrecordList) throws PluginException {
            int i;
            String subrecordType;
            String subrecordType2;
            boolean modifiedMergedList = false;
            boolean foundList = false;
            boolean foundFace = false;
            int count = 0;
            for (PluginSubrecord subrecord : subrecordList) {
                String subrecordType3 = subrecord.getSubrecordType();
                if (!foundList) {
                    if (subrecordType3.equals("NAM0")) {
                        foundFace = true;
                        continue;
                    }
                    if (!subrecordType3.equals("NAM1")) continue;
                    if (!foundFace) {
                        throw new PluginException("Face data does not precede body data");
                    }
                    foundList = true;
                    continue;
                }
                if (!subrecordType3.equals("INDX")) continue;
                ++count;
            }
            PluginSubrecord[] indx = new PluginSubrecord[count];
            PluginSubrecord[] icon = new PluginSubrecord[count];
            PluginSubrecord[] modl = new PluginSubrecord[2];
            PluginSubrecord[] modb = new PluginSubrecord[2];
            int index = -1;
            int femaleIndex = -1;
            boolean foundFemale = false;
            foundList = false;
            for (PluginSubrecord subrecord : subrecordList) {
                subrecordType2 = subrecord.getSubrecordType();
                if (!foundList) {
                    if (!subrecordType2.equals("NAM1")) continue;
                    foundList = true;
                    continue;
                }
                if (subrecordType2.equals("INDX")) {
                    indx[++index] = subrecord;
                    continue;
                }
                if (subrecordType2.equals("ICON")) {
                    icon[index] = subrecord;
                    continue;
                }
                if (subrecordType2.equals("MNAM")) {
                    if (!foundFemale) continue;
                    throw new PluginException("Female body data does not follow male body data");
                }
                if (subrecordType2.equals("FNAM")) {
                    foundFemale = true;
                    femaleIndex = index + 1;
                    continue;
                }
                if (subrecordType2.equals("MODL")) {
                    if (!foundFemale) {
                        modl[0] = subrecord;
                        continue;
                    }
                    modl[1] = subrecord;
                    continue;
                }
                if (!subrecordType2.equals("MODB")) break;
                if (!foundFemale) {
                    modb[0] = subrecord;
                    continue;
                }
                modb[1] = subrecord;
            }
            if (!foundFemale) {
                throw new PluginException("No female body data");
            }
            foundList = false;
            foundFace = false;
            count = 0;
            for (PluginSubrecord subrecord : mergedSubrecordList) {
                subrecordType2 = subrecord.getSubrecordType();
                if (!foundList) {
                    if (subrecordType2.equals("NAM0")) {
                        foundFace = true;
                        continue;
                    }
                    if (!subrecordType2.equals("NAM1")) continue;
                    if (!foundFace) {
                        throw new PluginException("Face data does not precede body data");
                    }
                    foundList = true;
                    continue;
                }
                if (!subrecordType2.equals("INDX")) continue;
                ++count;
            }
            PluginSubrecord[] mindx = new PluginSubrecord[count];
            PluginSubrecord[] micon = new PluginSubrecord[count];
            PluginSubrecord[] mmodl = new PluginSubrecord[2];
            PluginSubrecord[] mmodb = new PluginSubrecord[2];
            index = -1;
            foundList = false;
            foundFemale = false;
            for (PluginSubrecord subrecord : mergedSubrecordList) {
                subrecordType = subrecord.getSubrecordType();
                if (!foundList) {
                    if (!subrecordType.equals("NAM1")) continue;
                    foundList = true;
                    continue;
                }
                if (subrecordType.equals("INDX")) {
                    mindx[++index] = subrecord;
                    continue;
                }
                if (subrecordType.equals("ICON")) {
                    micon[index] = subrecord;
                    continue;
                }
                if (subrecordType.equals("MNAM")) {
                    if (!foundFemale) continue;
                    throw new PluginException("Female body data does not follow male body data");
                }
                if (subrecordType.equals("FNAM")) {
                    foundFemale = true;
                    continue;
                }
                if (subrecordType.equals("MODL")) {
                    if (!foundFemale) {
                        mmodl[0] = subrecord;
                        continue;
                    }
                    mmodl[1] = subrecord;
                    continue;
                }
                if (!subrecordType.equals("MODB")) break;
                if (!foundFemale) {
                    mmodb[0] = subrecord;
                    continue;
                }
                mmodb[1] = subrecord;
            }
            foundList = false;
            foundFace = false;
            count = 0;
            for (PluginSubrecord subrecord : masterSubrecordList) {
                subrecordType = subrecord.getSubrecordType();
                if (!foundList) {
                    if (subrecordType.equals("NAM0")) {
                        foundFace = true;
                        continue;
                    }
                    if (!subrecordType.equals("NAM1")) continue;
                    if (!foundFace) {
                        throw new PluginException("Face data does not precede body data");
                    }
                    foundList = true;
                    continue;
                }
                if (!subrecordType.equals("INDX")) continue;
                ++count;
            }
            PluginSubrecord[] xindx = new PluginSubrecord[count];
            PluginSubrecord[] xicon = new PluginSubrecord[count];
            PluginSubrecord[] xmodl = new PluginSubrecord[2];
            PluginSubrecord[] xmodb = new PluginSubrecord[2];
            index = -1;
            foundList = false;
            foundFemale = false;
            for (PluginSubrecord subrecord : masterSubrecordList) {
                String subrecordType4 = subrecord.getSubrecordType();
                if (!foundList) {
                    if (!subrecordType4.equals("NAM1")) continue;
                    foundList = true;
                    continue;
                }
                if (subrecordType4.equals("INDX")) {
                    xindx[++index] = subrecord;
                    continue;
                }
                if (subrecordType4.equals("ICON")) {
                    xicon[index] = subrecord;
                    continue;
                }
                if (subrecordType4.equals("MNAM")) {
                    if (!foundFemale) continue;
                    throw new PluginException("Female body data does not follow male body data");
                }
                if (subrecordType4.equals("FNAM")) {
                    foundFemale = true;
                    continue;
                }
                if (subrecordType4.equals("MODL")) {
                    if (!foundFemale) {
                        xmodl[0] = subrecord;
                        continue;
                    }
                    xmodl[1] = subrecord;
                    continue;
                }
                if (!subrecordType4.equals("MODB")) break;
                if (!foundFemale) {
                    xmodb[0] = subrecord;
                    continue;
                }
                xmodb[1] = subrecord;
            }
            if (indx.length != mindx.length || indx.length != xindx.length) {
                throw new PluginException("Body data maximum index values are not the same");
            }
            boolean rebuildMergedData = false;
            for (i = 0; i < indx.length; ++i) {
                if (!indx[i].equals(mindx[i]) || !indx[i].equals(xindx[i])) {
                    throw new PluginException("Incorrect body data index progression");
                }
                if (icon[i] == null) continue;
                if (micon[i] != null) {
                    if (icon[i].equals(micon[i])) continue;
                    if (xicon[i] != null) {
                        if (icon[i].equals(xicon[i])) continue;
                        if (!micon[i].equals(xicon[i])) {
                            if (!MergeTask.this.masterMerge && MergeTask.this.pluginInfo.shouldDeleteLastConflict()) continue;
                            micon[i] = icon[i];
                            rebuildMergedData = true;
                            continue;
                        }
                        micon[i] = icon[i];
                        rebuildMergedData = true;
                        continue;
                    }
                    if (!MergeTask.this.masterMerge && MergeTask.this.pluginInfo.shouldDeleteLastConflict()) continue;
                    micon[i] = icon[i];
                    rebuildMergedData = true;
                    continue;
                }
                micon[i] = icon[i];
                rebuildMergedData = true;
            }
            for (i = 0; i < 2; ++i) {
                if (modl[i] == null) continue;
                if (mmodl[i] != null) {
                    if (xmodl[i] != null) {
                        if (modl[i].equals(xmodl[i])) continue;
                        if (!mmodl[i].equals(xmodl[i])) {
                            if (!MergeTask.this.masterMerge && MergeTask.this.pluginInfo.shouldDeleteLastConflict()) continue;
                            mmodl[i] = modl[i];
                            mmodb[i] = modb[i];
                            rebuildMergedData = true;
                            continue;
                        }
                        mmodl[i] = modl[i];
                        mmodb[i] = modb[i];
                        rebuildMergedData = true;
                        continue;
                    }
                    if (!MergeTask.this.masterMerge && MergeTask.this.pluginInfo.shouldDeleteLastConflict()) continue;
                    mmodl[i] = modl[i];
                    mmodb[i] = modb[i];
                    rebuildMergedData = true;
                    continue;
                }
                mmodl[i] = modl[i];
                mmodb[i] = modb[i];
                rebuildMergedData = true;
            }
            if (rebuildMergedData) {
                modifiedMergedList = true;
                index = 0;
                foundList = false;
                ListIterator<PluginSubrecord> lit = mergedSubrecordList.listIterator();
                while (lit.hasNext()) {
                    PluginSubrecord subrecord = lit.next();
                    String subrecordType5 = subrecord.getSubrecordType();
                    if (foundList) {
                        if (!subrecordType5.equals("INDX") && !subrecordType5.equals("MNAM") && !subrecordType5.equals("FNAM") && !subrecordType5.equals("MODL") && !subrecordType5.equals("MODB") && !subrecordType5.equals("ICON")) break;
                        lit.remove();
                        continue;
                    }
                    if (subrecordType5.equals("NAM1")) {
                        foundList = true;
                        lit.remove();
                        continue;
                    }
                    ++index;
                }
                byte[] subrecordData = new byte[]{};
                for (int i2 = mindx.length - 1; i2 >= 0; --i2) {
                    if (micon[i2] != null) {
                        mergedSubrecordList.add(index, micon[i2]);
                    }
                    mergedSubrecordList.add(index, mindx[i2]);
                    if (i2 != femaleIndex) continue;
                    if (mmodb[1] != null) {
                        mergedSubrecordList.add(index, mmodb[1]);
                    }
                    if (mmodl[1] != null) {
                        mergedSubrecordList.add(index, mmodl[1]);
                    }
                    mergedSubrecordList.add(index, new PluginSubrecord("RACE", "FNAM", subrecordData));
                }
                if (mmodb[0] != null) {
                    mergedSubrecordList.add(index, mmodb[0]);
                }
                if (mmodl[0] != null) {
                    mergedSubrecordList.add(index, mmodl[0]);
                }
                mergedSubrecordList.add(index, new PluginSubrecord("RACE", "MNAM", subrecordData));
                mergedSubrecordList.add(index, new PluginSubrecord("RACE", "NAM1", subrecordData));
            }
            return modifiedMergedList;
        }

        private void copyVoiceFiles(Plugin plugin, File voiceDirectory, String mergedPath) throws DataFormatException, IOException, PluginException {
            File[] files = voiceDirectory.listFiles();
            List<FormInfo> formList = plugin.getFormList();
            Map<Integer, FormInfo> formMap = plugin.getFormMap();
            int masterID = plugin.getMasterList().size();
            for (File file : files) {
                FormInfo topicForm;
                FormInfo infoForm;
                int infoID;
                int infoSep;
                int topicSep;
                if (file.isDirectory()) {
                    String path = mergedPath + "\\" + file.getName();
                    this.copyVoiceFiles(plugin, file, path);
                    continue;
                }
                String name = file.getName();
                int questSep = name.indexOf(95);
                if (questSep < 1 || (topicSep = name.indexOf(95, questSep + 1)) < questSep + 2 || (infoSep = name.indexOf(95, topicSep + 1)) < topicSep + 2) continue;
                try {
                    infoID = Integer.parseInt(name.substring(topicSep + 1, infoSep), 16);
                }
                catch (NumberFormatException exc) {
                    infoID = 0;
                }
                if (infoID == 0 || (infoForm = formMap.get(new Integer(infoID |= masterID << 24))) == null) continue;
                PluginRecord infoRecord = (PluginRecord)infoForm.getSource();
                int topicID = infoForm.getParentFormID();
                if (topicID == 0 || (topicForm = formMap.get(new Integer(topicID))) == null) continue;
                String topicName = topicForm.getMergedEditorID();
                int questID = 0;
                List<PluginSubrecord> subrecordList = infoRecord.getSubrecords();
                for (PluginSubrecord subrecord : subrecordList) {
                    if (!subrecord.getSubrecordType().equals("QSTI")) continue;
                    byte[] subrecordData = subrecord.getSubrecordData();
                    questID = subrecordData[0] & 0xFF | (subrecordData[1] & 0xFF) << 8 | (subrecordData[2] & 0xFF) << 16 | (subrecordData[3] & 0xFF) << 24;
                    break;
                }
                if (questID == 0) continue;
                FormInfo questForm = formMap.get(new Integer(questID));
                String questName = questForm == null ? name.substring(0, questSep) : questForm.getMergedEditorID();
                File mergedDirectory = new File(mergedPath);
                if (!mergedDirectory.exists()) {
                    mergedDirectory.mkdirs();
                }
                String mergedName = String.format("%s\\%s_%s_%08X_%s", mergedPath, questName, topicName, infoForm.getMergedFormID() & 0xFFFFFF, name.substring(infoSep + 1));
                File mergedFile = new File(mergedName);
                FileInputStream in = new FileInputStream(file);
                FileOutputStream out = new FileOutputStream(mergedFile);
                int length = (int)file.length();
                byte[] buffer = new byte[length];
                in.read(buffer);
                out.write(buffer);
                out.close();
                in.close();
            }
        }

        private void deleteDirectoryTree(File directory) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                if (file.isDirectory()) {
                    this.deleteDirectoryTree(file);
                    continue;
                }
                file.delete();
            }
            directory.delete();
        }
    }
}

