/*
 * Decompiled with CFR 0.152.
 */
package TES4Plugin;

import TES4Plugin.FormInfo;
import TES4Plugin.PluginException;
import TES4Plugin.PluginGroup;
import TES4Plugin.PluginHeader;
import TES4Plugin.TES4Plugin;
import TES4Plugin.WorkerConfirmDialog;
import TES4Plugin.WorkerTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plugin {
    private File pluginFile;
    private PluginHeader pluginHeader;
    private List<PluginGroup> groupList;
    private List<FormInfo> formList;
    private Map<Integer, FormInfo> formMap;
    private static final String[] initialGroupList = new String[]{"GMST", "GLOB", "CLAS", "FACT", "HAIR", "EYES", "RACE", "SOUN", "SKIL", "MGEF", "SCPT", "LTEX", "ENCH", "SPEL", "BSGN", "ACTI", "APPA", "ARMO", "BOOK", "CLOT", "CONT", "DOOR", "INGR", "LIGH", "MISC", "STAT", "GRAS", "TREE", "FLOR", "FURN", "WEAP", "AMMO", "NPC_", "CREA", "LVLC", "SLGM", "KEYM", "ALCH", "SBSP", "SGST", "LVLI", "WTHR", "CLMT", "REGN", "CELL", "WRLD", "DIAL", "QUST", "IDLE", "PACK", "CSTY", "LSCR", "LVSP", "ANIO", "WATR", "EFSH"};

    public Plugin(File pluginFile) {
        this.pluginFile = pluginFile;
        this.pluginHeader = new PluginHeader(pluginFile);
        this.groupList = new ArrayList<PluginGroup>(initialGroupList.length);
    }

    public Plugin(File pluginFile, String creator, String summary, List<String> masterList) {
        this.pluginFile = pluginFile;
        this.pluginHeader = new PluginHeader(pluginFile);
        this.pluginHeader.setCreator(creator);
        this.pluginHeader.setSummary(summary);
        this.pluginHeader.setMasterList(masterList);
        this.groupList = new ArrayList<PluginGroup>(initialGroupList.length);
    }

    public void createInitialGroups() {
        this.groupList.clear();
        if (this.formList != null) {
            this.formList.clear();
        }
        if (this.formMap != null) {
            this.formMap.clear();
        }
        for (int i = 0; i < initialGroupList.length; ++i) {
            this.groupList.add(new PluginGroup(initialGroupList[i]));
        }
    }

    public String getName() {
        return this.pluginFile.getName();
    }

    public String getCreator() {
        return this.pluginHeader.getCreator();
    }

    public String getSummary() {
        return this.pluginHeader.getSummary();
    }

    public int getRecordCount() {
        return this.pluginHeader.getRecordCount();
    }

    public boolean isMaster() {
        return this.pluginHeader.isMaster();
    }

    public void setMaster(boolean master) {
        this.pluginHeader.setMaster(master);
    }

    public List<String> getMasterList() {
        return this.pluginHeader.getMasterList();
    }

    public List<FormInfo> getFormList() {
        return this.formList;
    }

    public Map<Integer, FormInfo> getFormMap() {
        return this.formMap;
    }

    public List<PluginGroup> getGroupList() {
        return this.groupList;
    }

    public String toString() {
        return this.pluginFile.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(WorkerTask task) throws PluginException, DataFormatException, IOException, InterruptedException {
        RandomAccessFile in = null;
        try {
            FormInfo playerInfo;
            Integer refFormID;
            int count;
            if (!this.pluginFile.exists() || !this.pluginFile.isFile()) {
                throw new IOException("Plugin file '" + this.pluginFile.getName() + "' does not exist");
            }
            in = new RandomAccessFile(this.pluginFile, "r");
            this.pluginHeader.read(in);
            int recordCount = this.pluginHeader.getRecordCount();
            this.formList = new ArrayList<FormInfo>(recordCount);
            this.formMap = new HashMap<Integer, FormInfo>(recordCount);
            byte[] prefix = new byte[20];
            int loadCount = 0;
            while ((count = in.read(prefix)) != -1) {
                if (count != 20) {
                    throw new PluginException(this.pluginFile.getName() + ": Group record prefix is too short");
                }
                String type = new String(prefix, 0, 4);
                if (!type.equals("GRUP")) {
                    throw new PluginException(this.pluginFile.getName() + ": Top-level record is not a group");
                }
                if (prefix[12] != 0) {
                    throw new PluginException(this.pluginFile.getName() + ": Top-level group type is not 0");
                }
                int length = (prefix[4] & 0xFF) + ((prefix[5] & 0xFF) << 8) + ((prefix[6] & 0xFF) << 16) + ((prefix[7] & 0xFF) << 24);
                length -= 20;
                PluginGroup group = new PluginGroup(prefix);
                if (TES4Plugin.debugMode) {
                    System.out.printf("%s: Loading group %s\n", this.pluginFile.getName(), group.getGroupRecordType());
                }
                group.load(this.pluginFile, in, length);
                group.updateFormList(this.formList);
                this.groupList.add(group);
                loadCount += group.getRecordCount() + 1;
                if (task == null) continue;
                if (!task.interrupted()) continue;
                throw new InterruptedException("Request canceled");
            }
            if (loadCount != recordCount) {
                String text = this.pluginFile.getName() + ": Load count " + loadCount + " does not match header count " + recordCount;
                int selection = WorkerConfirmDialog.showConfirmDialog(task.getParent(), text + ". Do you want to continue?", "Error", 0, 0);
                if (selection != 0) {
                    throw new PluginException(text);
                }
            }
            for (FormInfo info : this.formList) {
                info.setPlugin(this);
                this.formMap.put(new Integer(info.getFormID()), info);
            }
            if (this.pluginHeader.getMasterList().size() == 0 && this.formMap.get(refFormID = new Integer(20)) == null && (playerInfo = this.formMap.get(new Integer(7))) != null && playerInfo.getRecordType().equals("NPC_") && playerInfo.getEditorID().equals("Player")) {
                FormInfo playerRefInfo = new FormInfo(null, "REFR", 20, "PlayerREF");
                this.formList.add(playerRefInfo);
                this.formMap.put(refFormID, playerRefInfo);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(WorkerTask task) throws DataFormatException, IOException, InterruptedException {
        File outFile = null;
        FileOutputStream out = null;
        boolean groupsWritten = false;
        int recordCount = 0;
        for (PluginGroup group : this.groupList) {
            group.removeIgnoredRecords();
            int count = group.getRecordCount();
            if (count == 0) continue;
            recordCount += count + 1;
        }
        this.pluginHeader.setRecordCount(recordCount);
        try {
            outFile = new File(this.pluginFile.getParent() + "\\TES4Plugin.tmp");
            out = new FileOutputStream(outFile);
            this.pluginHeader.write(out);
            for (PluginGroup group : this.groupList) {
                byte[] buffer;
                if (!group.isEmpty() && (buffer = group.store()) != null) {
                    out.write(buffer);
                }
                if (task == null) continue;
                if (!task.interrupted()) continue;
                throw new InterruptedException("Request canceled");
            }
            groupsWritten = true;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (outFile.exists()) {
                if (groupsWritten) {
                    if (this.pluginFile.exists()) {
                        this.pluginFile.delete();
                    }
                    outFile.renameTo(this.pluginFile);
                } else {
                    outFile.delete();
                }
            }
        }
    }
}

