/*
 * Decompiled with CFR 0.152.
 */
package TES4Plugin;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class PluginFileFilter
extends FileFilter {
    private boolean selectMasterFiles;
    private boolean selectPluginFiles;

    public PluginFileFilter() {
        this.selectMasterFiles = true;
        this.selectPluginFiles = true;
    }

    public PluginFileFilter(boolean selectMasterFiles) {
        this.selectMasterFiles = selectMasterFiles;
        this.selectPluginFiles = !selectMasterFiles;
    }

    public String getDescription() {
        String text = this.selectMasterFiles ? (this.selectPluginFiles ? "TES Files (*.esm, *.esp)" : "TES Master Files (*.esm)") : "TES Plugin Files (*.esp)";
        return text;
    }

    public boolean accept(File file) {
        boolean accept = false;
        if (!file.isFile()) {
            accept = true;
        } else {
            String name = file.getName();
            int sep = name.lastIndexOf(46);
            if (sep > 0) {
                if (name.substring(sep).equalsIgnoreCase(".esm")) {
                    if (this.selectMasterFiles) {
                        accept = true;
                    }
                } else if (name.substring(sep).equalsIgnoreCase(".esp") && this.selectPluginFiles) {
                    accept = true;
                }
            }
        }
        return accept;
    }
}

