/*
 * Decompiled with CFR 0.152.
 */
package TES4Plugin;

import TES4Plugin.FormInfo;
import TES4Plugin.PluginException;
import TES4Plugin.PluginRecord;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.zip.DataFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginGroup
extends PluginRecord {
    public static final int TOP = 0;
    public static final int WORLDSPACE = 1;
    public static final int INTERIOR_BLOCK = 2;
    public static final int INTERIOR_SUBBLOCK = 3;
    public static final int EXTERIOR_BLOCK = 4;
    public static final int EXTERIOR_SUBBLOCK = 5;
    public static final int CELL = 6;
    public static final int TOPIC = 7;
    public static final int CELL_PERSISTENT = 8;
    public static final int CELL_TEMPORARY = 9;
    public static final int CELL_DISTANT = 10;
    private byte[] groupLabel;
    private String groupRecordType;
    private int groupParentID;
    private int groupType;
    private List<PluginRecord> recordList;
    private static Map<String, String> typeMap;
    private static String[][] groupDescriptions;

    public PluginGroup(byte[] prefix) {
        super("GRUP");
        this.groupLabel = new byte[4];
        System.arraycopy(prefix, 8, this.groupLabel, 0, 4);
        this.groupType = prefix[12] & 0xFF;
        this.recordList = new ArrayList<PluginRecord>();
        switch (this.groupType) {
            case 0: {
                if (this.groupLabel[0] >= 32) {
                    this.groupRecordType = new String(this.groupLabel);
                    break;
                }
                this.groupRecordType = new String();
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.groupParentID = this.groupLabel[0] & 0xFF | (this.groupLabel[1] & 0xFF) << 8 | (this.groupLabel[2] & 0xFF) << 16 | (this.groupLabel[3] & 0xFF) << 24;
            }
        }
        if (typeMap == null) {
            this.buildTypeMap();
        }
    }

    public PluginGroup(String recordType) {
        super("GRUP");
        this.groupLabel = recordType.getBytes();
        this.groupRecordType = recordType;
        this.recordList = new ArrayList<PluginRecord>();
        if (typeMap == null) {
            this.buildTypeMap();
        }
    }

    private void buildTypeMap() {
        typeMap = new HashMap<String, String>(groupDescriptions.length);
        for (int i = 0; i < groupDescriptions.length; ++i) {
            typeMap.put(groupDescriptions[i][0], groupDescriptions[i][1]);
        }
    }

    public int getRecordCount() {
        int recordCount = 0;
        for (PluginRecord record : this.recordList) {
            ++recordCount;
            if (!(record instanceof PluginGroup)) continue;
            recordCount += ((PluginGroup)record).getRecordCount();
        }
        return recordCount;
    }

    public boolean isEmpty() {
        return this.recordList.size() == 0;
    }

    public int getGroupType() {
        return this.groupType;
    }

    public byte[] getGroupLabel() {
        return this.groupLabel;
    }

    public void setGroupLabel(byte[] label) {
        this.groupLabel = label;
    }

    public String getGroupRecordType() {
        return this.groupRecordType;
    }

    public int getGroupParentID() {
        return this.groupParentID;
    }

    public List<PluginRecord> getRecordList() {
        return this.recordList;
    }

    public void updateFormList(List<FormInfo> formList) {
        for (PluginRecord record : this.recordList) {
            record.setParent(this);
            if (record instanceof PluginGroup) {
                PluginGroup subGroup = (PluginGroup)record;
                subGroup.updateFormList(formList);
                continue;
            }
            if (record.isIgnored()) continue;
            FormInfo formInfo = new FormInfo(record, record.getRecordType(), record.getFormID(), record.getEditorID());
            formInfo.setParentFormID(this.groupParentID);
            formList.add(formInfo);
        }
    }

    public void removeIgnoredRecords() {
        ListIterator<PluginRecord> lit = this.recordList.listIterator();
        PluginRecord prevRecord = null;
        while (lit.hasNext()) {
            PluginRecord record = lit.next();
            if (record instanceof PluginGroup) {
                PluginGroup group = (PluginGroup)record;
                group.removeIgnoredRecords();
                if (group.isEmpty()) {
                    int groupType = group.getGroupType();
                    if (groupType == 1 || groupType == 6 || groupType == 7) {
                        if (prevRecord == null || prevRecord.getRecordType().equals("GRUP")) {
                            lit.remove();
                            continue;
                        }
                        prevRecord = record;
                        continue;
                    }
                    lit.remove();
                    continue;
                }
                prevRecord = record;
                continue;
            }
            if (record.isIgnored()) {
                lit.remove();
                continue;
            }
            prevRecord = record;
        }
    }

    @Override
    public boolean equals(Object object) {
        List<PluginRecord> objRecordList;
        byte[] objGroupLabel;
        PluginGroup objGroup;
        boolean areEqual = false;
        if (object instanceof PluginGroup && (objGroup = (PluginGroup)object).getGroupType() == this.groupType && (objGroupLabel = objGroup.getGroupLabel())[0] == this.groupLabel[0] && objGroupLabel[1] == this.groupLabel[1] && objGroupLabel[2] == this.groupLabel[2] && objGroupLabel[3] == this.groupLabel[3] && (objRecordList = objGroup.getRecordList()).size() == this.recordList.size()) {
            areEqual = true;
            for (int i = 0; i < this.recordList.size(); ++i) {
                if (objRecordList.get(i).equals(this.recordList.get(i))) continue;
                areEqual = false;
                break;
            }
        }
        return areEqual;
    }

    @Override
    public String toString() {
        String text;
        int intValue = this.groupLabel[0] & 0xFF | (this.groupLabel[1] & 0xFF) << 8 | (this.groupLabel[2] & 0xFF) << 16 | (this.groupLabel[3] & 0xFF) << 24;
        switch (this.groupType) {
            case 0: {
                String type = new String(this.groupLabel);
                String description = typeMap.get(type);
                if (description != null) {
                    text = String.format("Group: %s", description);
                    break;
                }
                text = String.format("Group: Type %s", new String(this.groupLabel));
                break;
            }
            case 1: {
                text = String.format("Group: Worldspace (%08X) children", intValue);
                break;
            }
            case 2: {
                text = String.format("Group: Interior cell block %d", intValue);
                break;
            }
            case 3: {
                text = String.format("Group: Interior cell subblock %d", intValue);
                break;
            }
            case 4: {
                int y;
                int x = intValue >>> 16;
                if ((x & 0x8000) != 0) {
                    x |= 0xFFFF0000;
                }
                if (((y = intValue & 0xFFFF) & 0x8000) != 0) {
                    y |= 0xFFFF0000;
                }
                text = String.format("Group: Exterior cell block %d,%d", x, y);
                break;
            }
            case 5: {
                int y;
                int x = intValue >>> 16;
                if ((x & 0x8000) != 0) {
                    x |= 0xFFFF0000;
                }
                if (((y = intValue & 0xFFFF) & 0x8000) != 0) {
                    y |= 0xFFFF0000;
                }
                text = String.format("Group: Exterior cell subblock %d,%d", x, y);
                break;
            }
            case 6: {
                text = String.format("Group: Cell (%08X) children", intValue);
                break;
            }
            case 7: {
                text = String.format("Group: Topic (%08X) children", intValue);
                break;
            }
            case 8: {
                text = String.format("Group: Cell (%08X) persistent children", intValue);
                break;
            }
            case 9: {
                text = String.format("Group: Cell (%08X) temporary children", intValue);
                break;
            }
            case 10: {
                text = String.format("Group: Cell (%08X) visible distant children", intValue);
                break;
            }
            default: {
                text = String.format("Group: Type %d, Parent %08X", this.groupType, intValue);
            }
        }
        return text;
    }

    @Override
    public void load(File file, RandomAccessFile in, int groupLength) throws PluginException, IOException, DataFormatException {
        int dataLength;
        int length;
        byte[] prefix = new byte[20];
        for (dataLength = groupLength; dataLength >= 20; dataLength -= length) {
            PluginRecord record;
            int count = in.read(prefix);
            if (count != 20) {
                throw new PluginException(file.getName() + ": Record prefix is incomplete");
            }
            dataLength -= 20;
            String type = new String(prefix, 0, 4);
            length = (prefix[4] & 0xFF) + ((prefix[5] & 0xFF) << 8) + ((prefix[6] & 0xFF) << 16) + ((prefix[7] & 0xFF) << 24);
            if (type.equals("GRUP")) {
                length -= 20;
                record = new PluginGroup(prefix);
            } else {
                record = new PluginRecord(prefix);
            }
            record.load(file, in, length);
            this.recordList.add(record);
        }
        if (dataLength != 0) {
            if (this.groupType == 0) {
                throw new PluginException(file.getName() + ": Group " + this.groupRecordType + " is incomplete");
            }
            throw new PluginException(file.getName() + ": Subgroup type " + this.groupType + " is incomplete");
        }
    }

    @Override
    public byte[] store() throws IOException {
        Object recordBuffers = null;
        int length = 20;
        if (this.recordList.size() != 0) {
            recordBuffers = new byte[this.recordList.size()][];
            int count = 0;
            for (PluginRecord record : this.recordList) {
                recordBuffers[count] = record.store();
                length += recordBuffers[count].length;
                ++count;
            }
        }
        byte[] groupBuffer = new byte[length];
        System.arraycopy("GRUP".getBytes(), 0, groupBuffer, 0, 4);
        groupBuffer[4] = (byte)length;
        groupBuffer[5] = (byte)(length >>> 8);
        groupBuffer[6] = (byte)(length >>> 16);
        groupBuffer[7] = (byte)(length >>> 24);
        System.arraycopy(this.groupLabel, 0, groupBuffer, 8, 4);
        groupBuffer[12] = (byte)this.groupType;
        groupBuffer[13] = 0;
        groupBuffer[14] = 0;
        groupBuffer[15] = 0;
        if (recordBuffers != null) {
            int offset = 20;
            for (int i = 0; i < ((byte[][])recordBuffers).length; ++i) {
                System.arraycopy(recordBuffers[i], 0, groupBuffer, offset, recordBuffers[i].length);
                offset += recordBuffers[i].length;
            }
        }
        return groupBuffer;
    }

    @Override
    public Object clone() {
        Object clonedObject = super.clone();
        PluginGroup clonedGroup = (PluginGroup)clonedObject;
        clonedGroup.recordList = new ArrayList<PluginRecord>(this.recordList.size());
        for (PluginRecord record : this.recordList) {
            clonedGroup.recordList.add((PluginRecord)record.clone());
        }
        return clonedObject;
    }

    public PluginGroup createEmptyGroup() {
        PluginGroup clonedGroup = (PluginGroup)super.clone();
        clonedGroup.recordList = new ArrayList<PluginRecord>();
        return clonedGroup;
    }

    static {
        groupDescriptions = new String[][]{{"ACTI", "Activators"}, {"ALCH", "Potions"}, {"AMMO", "Ammunition"}, {"ANIO", "Animated Object"}, {"APPA", "Apparatus"}, {"ARMO", "Armor"}, {"BOOK", "Books"}, {"BSGN", "Birthsigns"}, {"CELL", "Cells"}, {"CLAS", "Classes"}, {"CLOT", "Clothing"}, {"CLMT", "Climate"}, {"CONT", "Containers"}, {"CREA", "Creatures"}, {"CSTY", "Combat Styles"}, {"DIAL", "Dialog"}, {"DOOR", "Doors"}, {"EFSH", "Effect Shaders"}, {"ENCH", "Enchantments"}, {"EYES", "Eyes"}, {"FACT", "Factions"}, {"FLOR", "Flora"}, {"FURN", "Furniture"}, {"GLOB", "Global Variables"}, {"GMST", "Game Settings"}, {"GRAS", "Grass"}, {"HAIR", "Hair"}, {"IDLE", "Idle Animations"}, {"INGR", "Ingredients"}, {"KEYM", "Keys"}, {"LIGH", "Lights"}, {"LSCR", "Load Screens"}, {"LTEX", "Land Textures"}, {"LVLC", "Leveled Creatures"}, {"LVLI", "Leveled Items"}, {"LVSP", "Leveled Spells"}, {"MGEF", "Magic Effects"}, {"MISC", "Miscellaneous Items"}, {"NPC_", "NPCs"}, {"PACK", "Packages"}, {"QUST", "Quests"}, {"RACE", "Races"}, {"REGN", "Regions"}, {"SBSP", "Subspaces"}, {"SCPT", "Scripts"}, {"SGST", "Sigil Stones"}, {"SKIL", "Skills"}, {"SLGM", "Soul Gems"}, {"SOUN", "Sounds"}, {"SPEL", "Spells"}, {"STAT", "Statics"}, {"TREE", "Trees"}, {"WATR", "Water"}, {"WEAP", "Weapons"}, {"WTHR", "Weather"}, {"WRLD", "World Spaces"}};
    }
}

