/*
 * Decompiled with CFR 0.152.
 */
package TES4Plugin;

import TES4Plugin.PluginException;
import TES4Plugin.TES4Plugin;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginHeader {
    private File pluginFile;
    private float pluginVersion;
    private boolean master;
    private String creator;
    private String summary;
    private int recordCount;
    private List<String> masterList;

    public PluginHeader(File pluginFile) {
        this.pluginFile = pluginFile;
        this.pluginVersion = 0.8f;
        this.master = false;
        this.creator = "DEFAULT";
        this.summary = new String();
        this.masterList = new ArrayList<String>();
    }

    public float getVersion() {
        return this.pluginVersion;
    }

    public void setVersion(float version) {
        this.pluginVersion = version;
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public List<String> getMasterList() {
        return this.masterList;
    }

    public void setMasterList(List<String> masterList) {
        this.masterList = masterList;
    }

    public void read(RandomAccessFile in) throws PluginException, IOException {
        byte[] prefix = new byte[20];
        byte[] buffer = new byte[1024];
        int count = in.read(prefix, 0, 20);
        if (count != 20) {
            throw new PluginException(this.pluginFile.getName() + ": File is not a TES4 file");
        }
        String type = new String(prefix, 0, 4);
        if (!type.equals("TES4")) {
            throw new PluginException(this.pluginFile.getName() + ": File is not a TES4 file");
        }
        this.master = (prefix[8] & 1) != 0;
        int headerLength = (prefix[4] & 0xFF) + ((prefix[5] & 0xFF) << 8) + ((prefix[6] & 0xFF) << 16) + ((prefix[7] & 0xFF) << 24);
        while (headerLength >= 6) {
            count = in.read(prefix, 0, 6);
            if (count != 6) {
                throw new PluginException(this.pluginFile.getName() + ": Header subrecord prefix truncated");
            }
            int length = (prefix[4] & 0xFF) + ((prefix[5] & 0xFF) << 8);
            if (length > (headerLength -= 6)) {
                throw new PluginException(this.pluginFile.getName() + ": Subrecord length exceeds header length");
            }
            if (length > buffer.length) {
                buffer = new byte[length];
            }
            if ((count = in.read(buffer, 0, length)) != length) {
                throw new PluginException(this.pluginFile.getName() + ": Header subrecord data truncated");
            }
            headerLength -= count;
            type = new String(prefix, 0, 4);
            if (type.equals("HEDR")) {
                if (length < 8) {
                    throw new PluginException(this.pluginFile.getName() + ": HEDR subrecord is too small");
                }
                int pluginIntVersion = buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8 | (buffer[2] & 0xFF) << 16 | (buffer[3] & 0xFF) << 24;
                this.pluginVersion = Float.intBitsToFloat(pluginIntVersion);
                if (TES4Plugin.debugMode) {
                    System.out.printf("%s: Version %f\n", this.pluginFile.getName(), Float.valueOf(this.pluginVersion));
                }
                this.recordCount = (buffer[4] & 0xFF) + ((buffer[5] & 0xFF) << 8) + ((buffer[6] & 0xFF) << 16) + ((buffer[7] & 0xFF) << 24);
                if (!TES4Plugin.debugMode) continue;
                System.out.printf("%s: %d records\n", this.pluginFile.getName(), this.recordCount);
                continue;
            }
            if (type.equals("CNAM")) {
                if (length <= 1) continue;
                this.creator = new String(buffer, 0, length - 1);
                continue;
            }
            if (type.equals("SNAM")) {
                if (length <= 1) continue;
                this.summary = new String(buffer, 0, length - 1);
                continue;
            }
            if (!type.equals("MAST") || length <= 1) continue;
            this.masterList.add(new String(buffer, 0, length - 1));
        }
        if (headerLength != 0) {
            throw new PluginException(this.pluginFile.getName() + ": Header is incomplete");
        }
    }

    public void write(FileOutputStream out) throws IOException {
        byte[] snamSubrecord;
        int pluginIntVersion = Float.floatToIntBits(this.pluginVersion);
        byte[] hedrSubrecord = new byte[18];
        System.arraycopy("HEDR".getBytes(), 0, hedrSubrecord, 0, 4);
        hedrSubrecord[4] = 12;
        hedrSubrecord[5] = 0;
        hedrSubrecord[6] = (byte)pluginIntVersion;
        hedrSubrecord[7] = (byte)(pluginIntVersion >>> 8);
        hedrSubrecord[8] = (byte)(pluginIntVersion >>> 16);
        hedrSubrecord[9] = (byte)(pluginIntVersion >>> 24);
        hedrSubrecord[10] = (byte)this.recordCount;
        hedrSubrecord[11] = (byte)(this.recordCount >>> 8);
        hedrSubrecord[12] = (byte)(this.recordCount >>> 16);
        hedrSubrecord[13] = (byte)(this.recordCount >>> 24);
        byte[] creatorBytes = this.creator.getBytes();
        int length = creatorBytes.length + 1;
        byte[] cnamSubrecord = new byte[6 + length];
        System.arraycopy("CNAM".getBytes(), 0, cnamSubrecord, 0, 4);
        cnamSubrecord[4] = (byte)length;
        cnamSubrecord[5] = (byte)(length >>> 8);
        if (length > 1) {
            System.arraycopy(creatorBytes, 0, cnamSubrecord, 6, creatorBytes.length);
        }
        cnamSubrecord[6 + creatorBytes.length] = 0;
        byte[] summaryBytes = this.summary.getBytes();
        length = summaryBytes.length + 1;
        if (length > 1) {
            snamSubrecord = new byte[6 + length];
            System.arraycopy("SNAM".getBytes(), 0, snamSubrecord, 0, 4);
            snamSubrecord[4] = (byte)length;
            snamSubrecord[5] = (byte)(length >>> 8);
            System.arraycopy(summaryBytes, 0, snamSubrecord, 6, summaryBytes.length);
            snamSubrecord[6 + summaryBytes.length] = 0;
        } else {
            snamSubrecord = new byte[]{};
        }
        byte[][] masterSubrecords = new byte[this.masterList.size()][];
        int count = 0;
        for (String master : this.masterList) {
            byte[] masterBytes = master.getBytes();
            length = masterBytes.length + 1;
            byte[] masterSubrecord = new byte[6 + length];
            System.arraycopy("MAST".getBytes(), 0, masterSubrecord, 0, 4);
            masterSubrecord[4] = (byte)length;
            masterSubrecord[5] = (byte)(length >>> 8);
            if (length > 1) {
                System.arraycopy(masterBytes, 0, masterSubrecord, 6, masterBytes.length);
            }
            masterSubrecord[6 + masterBytes.length] = 0;
            masterSubrecords[count++] = masterSubrecord;
        }
        length = hedrSubrecord.length + cnamSubrecord.length + snamSubrecord.length;
        for (int i = 0; i < masterSubrecords.length; ++i) {
            length += masterSubrecords[i].length + 14;
        }
        byte[] headerRecord = new byte[20 + length];
        System.arraycopy("TES4".getBytes(), 0, headerRecord, 0, 4);
        headerRecord[4] = (byte)length;
        headerRecord[5] = (byte)(length >> 8);
        headerRecord[6] = (byte)(length >> 16);
        headerRecord[7] = (byte)(length >> 24);
        headerRecord[8] = this.master ? (byte)1 : 0;
        int offset = 20;
        System.arraycopy(hedrSubrecord, 0, headerRecord, offset, hedrSubrecord.length);
        System.arraycopy(cnamSubrecord, 0, headerRecord, offset += hedrSubrecord.length, cnamSubrecord.length);
        offset += cnamSubrecord.length;
        if (snamSubrecord.length != 0) {
            System.arraycopy(snamSubrecord, 0, headerRecord, offset, snamSubrecord.length);
            offset += snamSubrecord.length;
        }
        for (int i = 0; i < masterSubrecords.length; ++i) {
            System.arraycopy(masterSubrecords[i], 0, headerRecord, offset, masterSubrecords[i].length);
            System.arraycopy("DATA".getBytes(), 0, headerRecord, offset += masterSubrecords[i].length, 4);
            headerRecord[offset + 4] = 8;
            offset += 14;
        }
        out.write(headerRecord);
    }
}

