/*
 * Decompiled with CFR 0.152.
 */
package TES4Plugin;

import TES4Plugin.PluginException;
import TES4Plugin.PluginSubrecord;
import TES4Plugin.TES4Plugin;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginRecord
implements Cloneable {
    private static final String dummyEditorID = new String();
    private String recordType;
    private int recordFlags1;
    private int recordFlags2;
    private int formID;
    private String editorID;
    private long recordPosition = -1L;
    private int recordLength;
    private PluginRecord parentRecord;

    public PluginRecord(String recordType) {
        this.recordType = recordType;
        this.editorID = dummyEditorID;
    }

    public PluginRecord(byte[] prefix) {
        if (prefix.length != 20) {
            throw new IllegalArgumentException("The record prefix is not 20 bytes");
        }
        this.recordType = new String(prefix, 0, 4);
        this.editorID = dummyEditorID;
        this.formID = prefix[12] & 0xFF | (prefix[13] & 0xFF) << 8 | (prefix[14] & 0xFF) << 16 | (prefix[15] & 0xFF) << 24;
        this.recordFlags1 = prefix[8] & 0xFF | (prefix[9] & 0xFF) << 8 | (prefix[10] & 0xFF) << 16 | (prefix[11] & 0xFF) << 24;
        this.recordFlags2 = prefix[16] & 0xFF | (prefix[17] & 0xFF) << 8 | (prefix[18] & 0xFF) << 16 | (prefix[19] & 0xFF) << 24;
    }

    public PluginRecord getParent() {
        return this.parentRecord;
    }

    public void setParent(PluginRecord parent) {
        this.parentRecord = parent;
    }

    public boolean isDeleted() {
        return (this.recordFlags1 & 0x20) != 0;
    }

    public void setDelete(boolean deleted) {
        if (deleted) {
            this.recordFlags1 |= 0x20;
        } else if ((this.recordFlags1 & 0x20) != 0) {
            this.recordFlags1 ^= 0x20;
        }
    }

    public boolean isIgnored() {
        return (this.recordFlags1 & 0x1000) != 0;
    }

    public void setIgnore(boolean ignored) {
        if (ignored) {
            this.recordFlags1 |= 0x1000;
        } else if ((this.recordFlags1 & 0x1000) != 0) {
            this.recordFlags1 ^= 0x1000;
        }
    }

    public boolean isCompressed() {
        return (this.recordFlags1 & 0x40000) != 0;
    }

    public String getRecordType() {
        return this.recordType;
    }

    public int getFormID() {
        return this.formID;
    }

    public void setFormID(int formID) {
        this.formID = formID;
    }

    public String getEditorID() {
        return this.editorID;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public byte[] getRecordData() throws DataFormatException, IOException, PluginException {
        byte[] recordData = TES4Plugin.pluginSpill.read(this.recordPosition, this.recordLength);
        if (!this.isCompressed()) {
            return recordData;
        }
        if (recordData.length < 5 || recordData[3] >= 32) {
            throw new PluginException("Compressed data prefix is not valid");
        }
        int length = recordData[0] & 0xFF | (recordData[1] & 0xFF) << 8 | (recordData[2] & 0xFF) << 16 | (recordData[3] & 0xFF) << 24;
        byte[] buffer = new byte[length];
        Inflater expand = new Inflater();
        expand.setInput(recordData, 4, recordData.length - 4);
        int count = expand.inflate(buffer);
        if (count != length) {
            throw new PluginException("Expanded data less than data length");
        }
        expand.end();
        return buffer;
    }

    public void setRecordData(byte[] buffer) throws DataFormatException, IOException {
        byte[] recordData;
        if (this.isCompressed()) {
            int length = buffer.length;
            Deflater comp = new Deflater(6);
            comp.setInput(buffer);
            comp.finish();
            byte[] compBuffer = new byte[length + 20];
            int compLength = comp.deflate(compBuffer);
            if (compLength == 0) {
                throw new DataFormatException("Unable to compress " + this.recordType + " record " + this.editorID);
            }
            if (!comp.finished()) {
                throw new DataFormatException("Compressed buffer is too small");
            }
            comp.end();
            recordData = new byte[4 + compLength];
            recordData[0] = (byte)length;
            recordData[1] = (byte)(length >>> 8);
            recordData[2] = (byte)(length >>> 16);
            recordData[3] = (byte)(length >>> 24);
            System.arraycopy(compBuffer, 0, recordData, 4, compLength);
        } else {
            recordData = buffer;
        }
        this.recordPosition = TES4Plugin.pluginSpill.write(recordData);
        this.recordLength = recordData.length;
    }

    public List<PluginSubrecord> getSubrecords() throws DataFormatException, IOException, PluginException {
        int subrecordLength;
        ArrayList<PluginSubrecord> subrecordList = new ArrayList<PluginSubrecord>();
        byte[] recordData = this.getRecordData();
        int overrideLength = 0;
        for (int offset = 0; offset < recordData.length; offset += 6 + subrecordLength) {
            String subrecordType = new String(recordData, offset, 4);
            subrecordLength = recordData[offset + 4] & 0xFF | (recordData[offset + 5] & 0xFF) << 8;
            if (subrecordType.equals("XXXX")) {
                overrideLength = recordData[offset + 6] & 0xFF | (recordData[offset + 7] & 0xFF) << 8 | (recordData[offset + 8] & 0xFF) << 16 | (recordData[offset + 9] & 0xFF) << 24;
                continue;
            }
            if (subrecordLength == 0) {
                subrecordLength = overrideLength;
                overrideLength = 0;
            }
            byte[] subrecordData = new byte[subrecordLength];
            System.arraycopy(recordData, offset + 6, subrecordData, 0, subrecordLength);
            subrecordList.add(new PluginSubrecord(this.recordType, subrecordType, subrecordData));
        }
        return subrecordList;
    }

    public void setSubrecords(List<PluginSubrecord> subrecordList) throws DataFormatException, IOException {
        int length = 0;
        for (PluginSubrecord subrecord : subrecordList) {
            int subrecordLength = subrecord.getSubrecordData().length;
            length += 6 + subrecordLength;
            if (subrecordLength <= 65535) continue;
            length += 10;
        }
        byte[] recordData = new byte[length];
        int offset = 0;
        for (PluginSubrecord subrecord : subrecordList) {
            byte[] subrecordData = subrecord.getSubrecordData();
            int subrecordLength = subrecordData.length;
            if (subrecordLength > 65535) {
                System.arraycopy("XXXX".getBytes(), 0, recordData, offset, 4);
                recordData[offset + 4] = 4;
                recordData[offset + 5] = 0;
                recordData[offset + 6] = (byte)subrecordLength;
                recordData[offset + 7] = (byte)(subrecordLength >>> 8);
                recordData[offset + 8] = (byte)(subrecordLength >>> 16);
                recordData[offset + 9] = (byte)(subrecordLength >>> 24);
                offset += 10;
            }
            System.arraycopy(subrecord.getSubrecordType().getBytes(), 0, recordData, offset, 4);
            if (subrecordLength > 65535) {
                recordData[offset + 4] = 0;
                recordData[offset + 5] = 0;
            } else {
                recordData[offset + 4] = (byte)subrecordLength;
                recordData[offset + 5] = (byte)(subrecordLength >>> 8);
            }
            System.arraycopy(subrecordData, 0, recordData, offset + 6, subrecordLength);
            offset += 6 + subrecordLength;
        }
        this.setRecordData(recordData);
    }

    public boolean equals(Object object) {
        PluginRecord objRecord;
        boolean areEqual = false;
        if (object instanceof PluginRecord && (objRecord = (PluginRecord)object).getRecordType().equals(this.recordType) && objRecord.getFormID() == this.formID) {
            areEqual = true;
        }
        return areEqual;
    }

    public boolean isIdentical(PluginRecord record) throws IOException {
        boolean areIdentical = this.equals(record);
        if (areIdentical) {
            byte[] cmpData;
            byte[] data = TES4Plugin.pluginSpill.read(this.recordPosition, this.recordLength);
            if (data.length != (cmpData = TES4Plugin.pluginSpill.read(record.recordPosition, record.recordLength)).length) {
                areIdentical = false;
            } else {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] == cmpData[i]) continue;
                    areIdentical = false;
                    break;
                }
            }
        }
        return areIdentical;
    }

    public String toString() {
        String text = String.format("%s record: %s (%08X)", this.recordType, this.editorID, this.formID);
        if (this.isIgnored()) {
            text = "(Ignore) " + text;
        } else if (this.isDeleted()) {
            text = "(Deleted) " + text;
        }
        return text;
    }

    public void load(File file, RandomAccessFile in, int recordLength) throws PluginException, IOException, DataFormatException {
        int dataLength;
        int length;
        int offset = 0;
        int overrideLength = 0;
        byte[] recordData = new byte[recordLength];
        int count = in.read(recordData);
        if (count != recordLength) {
            throw new PluginException(file.getName() + ": " + this.recordType + " record is incomplete");
        }
        this.recordPosition = TES4Plugin.pluginSpill.write(recordData);
        this.recordLength = recordData.length;
        byte[] buffer = this.getRecordData();
        for (dataLength = buffer.length; dataLength >= 6; dataLength -= 6 + length) {
            String subrecordType = new String(buffer, offset, 4);
            length = (buffer[offset + 4] & 0xFF) + ((buffer[offset + 5] & 0xFF) << 8);
            if (length == 0) {
                length = overrideLength;
                overrideLength = 0;
            }
            if (length > dataLength) {
                throw new PluginException(file.getName() + ": " + subrecordType + " subrecord is incomplete");
            }
            if (length > 0) {
                if (subrecordType.equals("XXXX")) {
                    if (length != 4) {
                        throw new PluginException(file.getName() + ": XXXX subrecord data length is not 4");
                    }
                    overrideLength = buffer[offset + 6] & 0xFF | (buffer[offset + 7] & 0xFF) << 8 | (buffer[offset + 8] & 0xFF) << 16 | (buffer[offset + 9] & 0xFF) << 24;
                } else if (subrecordType.equals("EDID") && length > 1) {
                    this.editorID = new String(buffer, offset + 6, length - 1);
                }
            }
            offset += 6 + length;
        }
        if (dataLength != 0) {
            throw new PluginException(file.getName() + ": " + this.recordType + " record is incomplete");
        }
    }

    public byte[] store() throws IOException {
        byte[] recordData = TES4Plugin.pluginSpill.read(this.recordPosition, this.recordLength);
        int length = recordData.length;
        byte[] buffer = new byte[20 + length];
        System.arraycopy(this.recordType.getBytes(), 0, buffer, 0, 4);
        buffer[4] = (byte)length;
        buffer[5] = (byte)(length >>> 8);
        buffer[6] = (byte)(length >>> 16);
        buffer[7] = (byte)(length >>> 24);
        buffer[8] = (byte)this.recordFlags1;
        buffer[9] = (byte)(this.recordFlags1 >>> 8);
        buffer[10] = (byte)(this.recordFlags1 >>> 16);
        buffer[11] = (byte)(this.recordFlags1 >>> 24);
        buffer[12] = (byte)this.formID;
        buffer[13] = (byte)(this.formID >>> 8);
        buffer[14] = (byte)(this.formID >>> 16);
        buffer[15] = (byte)(this.formID >>> 24);
        buffer[16] = (byte)this.recordFlags2;
        buffer[17] = (byte)(this.recordFlags2 >>> 8);
        buffer[18] = (byte)(this.recordFlags2 >>> 16);
        buffer[19] = (byte)(this.recordFlags2 >>> 24);
        if (length != 0) {
            System.arraycopy(recordData, 0, buffer, 20, length);
        }
        return buffer;
    }

    public Object clone() {
        Object clonedObject;
        try {
            clonedObject = super.clone();
        }
        catch (CloneNotSupportedException exc) {
            throw new UnsupportedOperationException("Unable to clone record", exc);
        }
        return clonedObject;
    }
}

