/*
 * Decompiled with CFR 0.152.
 */
package TES4Plugin;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PluginSpill {
    private File spillFile;
    private RandomAccessFile spill;
    private long nextWrite = 0L;
    private long cachePosition = -1L;
    private byte[] cacheData;

    public PluginSpill(File spillFile) throws IOException {
        this.spillFile = spillFile;
        if (spillFile.exists()) {
            spillFile.delete();
        }
        this.spill = new RandomAccessFile(spillFile, "rw");
    }

    public void close() throws IOException {
        if (this.spill != null) {
            this.spill.close();
        }
        if (this.spillFile.exists()) {
            this.spillFile.delete();
        }
    }

    public long write(byte[] data) throws IOException {
        long position = this.nextWrite;
        this.spill.seek(this.nextWrite);
        this.spill.write(data);
        this.nextWrite += (long)data.length;
        this.cachePosition = position;
        this.cacheData = data;
        return position;
    }

    public byte[] read(long position, int length) throws IOException {
        if (position < 0L) {
            return new byte[0];
        }
        if (this.cachePosition == position) {
            this.cachePosition = -1L;
            return this.cacheData;
        }
        byte[] data = new byte[length];
        if (length != 0) {
            this.spill.seek(position);
            int count = this.spill.read(data);
            if (count != length) {
                throw new IOException("Premature end-of-data on spill file");
            }
        }
        return data;
    }

    public void reset() {
        this.nextWrite = 0L;
    }
}

