/*
 * Decompiled with CFR 0.152.
 */
package TES4Plugin;

import TES4Plugin.FunctionInfo;
import TES4Plugin.SubrecordInfo;
import TES4Plugin.TES4Plugin;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PluginSubrecord {
    private String recordType;
    private String subrecordType;
    private boolean spillMode = false;
    private long subrecordPosition = -1L;
    private int subrecordLength;
    private byte[] subrecordData;
    private static Map<String, SubrecordInfo> typeMap;
    private static Map<Integer, FunctionInfo> functionMap;
    private static final int[] offsetRepeating4;
    private static final int[] offsetRepeating8;
    private static final int[] offsetRepeating12;
    private static final int[] offsetRepeating52;
    private static final int[] offsetZero;
    private static final int[] offsetFour;
    private static final int[] offsetZeroFour;
    private static final int[] offsetTwelveSixteen;
    private static final SubrecordInfo[] subrecordInfo;
    private static final FunctionInfo[] functionInfo;

    public PluginSubrecord(String recordType, String subrecordType, byte[] subrecordData) {
        this.recordType = recordType;
        this.subrecordType = subrecordType;
        this.subrecordData = subrecordData;
        if (typeMap == null) {
            typeMap = new HashMap<String, SubrecordInfo>(subrecordInfo.length);
            for (SubrecordInfo subrecordInfo : PluginSubrecord.subrecordInfo) {
                typeMap.put(subrecordInfo.getSubrecordType(), subrecordInfo);
            }
        }
        if (functionMap == null) {
            functionMap = new HashMap<Integer, FunctionInfo>(functionInfo.length);
            for (FunctionInfo functionInfo : PluginSubrecord.functionInfo) {
                functionMap.put(new Integer(functionInfo.getCode()), functionInfo);
            }
        }
    }

    public void setSpillMode(boolean mode) throws IOException {
        if (mode != this.spillMode) {
            if (this.spillMode) {
                this.subrecordData = TES4Plugin.pluginSpill.read(this.subrecordPosition, this.subrecordLength);
                this.subrecordPosition = -1L;
                this.subrecordLength = 0;
            } else if (this.subrecordData != null) {
                this.subrecordPosition = TES4Plugin.pluginSpill.write(this.subrecordData);
                this.subrecordLength = this.subrecordData.length;
                this.subrecordData = null;
            } else {
                this.subrecordPosition = -1L;
                this.subrecordLength = 0;
            }
            this.spillMode = mode;
        }
    }

    public String getSubrecordType() {
        return this.subrecordType;
    }

    public byte[] getSubrecordData() throws IOException {
        if (this.spillMode) {
            return TES4Plugin.pluginSpill.read(this.subrecordPosition, this.subrecordLength);
        }
        return this.subrecordData;
    }

    public void setSubrecordData(byte[] subrecordData) throws IOException {
        if (this.spillMode) {
            this.subrecordPosition = TES4Plugin.pluginSpill.write(subrecordData);
            this.subrecordLength = subrecordData.length;
        } else {
            this.subrecordData = subrecordData;
        }
    }

    public int[][] getReferences() throws IOException {
        int[][] references = null;
        if (this.subrecordType.equals("CTDA")) {
            byte[] subrecordData = this.getSubrecordData();
            int functionCode = subrecordData[8] & 0xFF | (subrecordData[9] & 0xFF) << 8 | (subrecordData[10] & 0xFF) << 16 | (subrecordData[11] & 0xFF) << 24;
            FunctionInfo functionInfo = functionMap.get(new Integer(functionCode));
            if (functionInfo != null) {
                references = new int[2][2];
                int index = 0;
                if (functionInfo.isFirstReference() && subrecordData.length >= 16) {
                    references[index][0] = 12;
                    references[index][1] = subrecordData[12] & 0xFF | (subrecordData[13] & 0xFF) << 8 | (subrecordData[14] & 0xFF) << 16 | (subrecordData[15] & 0xFF) << 24;
                    ++index;
                }
                if (functionInfo.isSecondReference() && subrecordData.length >= 20) {
                    references[index][0] = 16;
                    references[index][1] = subrecordData[16] & 0xFF | (subrecordData[17] & 0xFF) << 8 | (subrecordData[18] & 0xFF) << 16 | (subrecordData[19] & 0xFF) << 24;
                }
            }
        } else if (this.subrecordType.equals("DATA") && this.recordType.equals("MGEF")) {
            int refOffset;
            byte[] subrecordData = this.getSubrecordData();
            int[] mgefOffsets = new int[]{24, 32, 36, 40, 44, 48, 52};
            references = new int[mgefOffsets.length][2];
            for (int index = 0; index < mgefOffsets.length && (refOffset = mgefOffsets[index]) + 4 <= subrecordData.length; ++index) {
                references[index][0] = refOffset;
                references[index][1] = subrecordData[refOffset] & 0xFF | (subrecordData[refOffset + 1] & 0xFF) << 8 | (subrecordData[refOffset + 2] & 0xFF) << 16 | (subrecordData[refOffset + 3] & 0xFF) << 24;
            }
        } else if (this.subrecordType.equals("PLDT") && this.recordType.equals("PACK")) {
            byte[] subrecordData = this.getSubrecordData();
            int type = subrecordData[0] & 0xFF | (subrecordData[1] & 0xFF) << 8 | (subrecordData[2] & 0xFF) << 16 | (subrecordData[3] & 0xFF) << 24;
            if (type == 0 || type == 1 || type == 4) {
                references = new int[1][2];
                references[0][0] = 4;
                references[0][1] = subrecordData[4] & 0xFF | (subrecordData[5] & 0xFF) << 8 | (subrecordData[6] & 0xFF) << 16 | (subrecordData[7] & 0xFF) << 24;
            }
        } else if (this.subrecordType.equals("PTDT") && this.recordType.equals("PACK")) {
            byte[] subrecordData = this.getSubrecordData();
            int type = subrecordData[0] & 0xFF | (subrecordData[1] & 0xFF) << 8 | (subrecordData[2] & 0xFF) << 16 | (subrecordData[3] & 0xFF) << 24;
            if (type == 0 || type == 1) {
                references = new int[1][2];
                references[0][0] = 4;
                references[0][1] = subrecordData[4] & 0xFF | (subrecordData[5] & 0xFF) << 8 | (subrecordData[6] & 0xFF) << 16 | (subrecordData[7] & 0xFF) << 24;
            }
        } else {
            boolean returnReferences = false;
            SubrecordInfo subrecordInfo = typeMap.get(this.subrecordType);
            if (subrecordInfo != null) {
                String[] recordTypes = subrecordInfo.getRecordTypes();
                if (recordTypes.length == 0) {
                    returnReferences = true;
                } else {
                    for (int i = 0; i < recordTypes.length; ++i) {
                        if (!this.recordType.equals(recordTypes[i])) continue;
                        returnReferences = true;
                        break;
                    }
                }
            }
            if (returnReferences) {
                boolean repeating;
                byte[] subrecordData = this.getSubrecordData();
                int[] refOffsets = subrecordInfo.getReferenceOffsets();
                int refOffset = 0;
                int refSize = 4;
                int i = -1;
                int index = 0;
                if (refOffsets[0] < 0) {
                    repeating = true;
                    refSize = -refOffsets[0];
                    refOffset = -refSize;
                    references = new int[subrecordData.length / refSize][2];
                } else {
                    repeating = false;
                    references = new int[refOffsets.length][2];
                }
                while (true) {
                    if (repeating) {
                        refOffset += refSize;
                    } else {
                        if (++i == refOffsets.length) break;
                        refOffset = refOffsets[i];
                    }
                    if (refOffset + refSize > subrecordData.length) break;
                    references[index][0] = refOffset;
                    references[index][1] = subrecordData[refOffset] & 0xFF | (subrecordData[refOffset + 1] & 0xFF) << 8 | (subrecordData[refOffset + 2] & 0xFF) << 16 | (subrecordData[refOffset + 3] & 0xFF) << 24;
                    ++index;
                }
            }
        }
        return references;
    }

    public boolean equals(Object object) {
        boolean areEqual;
        block4: {
            PluginSubrecord objSubrecord;
            areEqual = false;
            if (object instanceof PluginSubrecord && (objSubrecord = (PluginSubrecord)object).getSubrecordType().equals(this.subrecordType)) {
                try {
                    byte[] subrecordData = this.getSubrecordData();
                    byte[] objSubrecordData = objSubrecord.getSubrecordData();
                    if (objSubrecordData.length != subrecordData.length) break block4;
                    areEqual = true;
                    for (int i = 0; i < subrecordData.length; ++i) {
                        if (subrecordData[i] == objSubrecordData[i]) continue;
                        areEqual = false;
                        break;
                    }
                }
                catch (IOException exc) {
                    areEqual = false;
                }
            }
        }
        return areEqual;
    }

    public String toString() {
        return this.subrecordType + " subrecord";
    }

    static {
        offsetRepeating4 = new int[]{-4};
        offsetRepeating8 = new int[]{-8};
        offsetRepeating12 = new int[]{-12};
        offsetRepeating52 = new int[]{-52};
        offsetZero = new int[]{0};
        offsetFour = new int[]{4};
        offsetZeroFour = new int[]{0, 4};
        offsetTwelveSixteen = new int[]{12, 16};
        subrecordInfo = new SubrecordInfo[]{new SubrecordInfo("ANAM", offsetZero, "DOOR"), new SubrecordInfo("BNAM", offsetZero, "DOOR"), new SubrecordInfo("BTXT", offsetZero, "LAND"), new SubrecordInfo("CNAM", offsetZero, "NPC_", "WRLD"), new SubrecordInfo("CNTO", offsetZero), new SubrecordInfo("CSCR", offsetZero, "CREA"), new SubrecordInfo("CSDI", offsetZero, "CREA"), new SubrecordInfo("DATA", offsetZero, "ANIO"), new SubrecordInfo("DNAM", offsetZeroFour, "RACE"), new SubrecordInfo("ENAM", offsetRepeating4, "AMMO", "ARMO", "BOOK", "CLOT", "NPC_", "RACE", "WEAP"), new SubrecordInfo("GNAM", offsetZero, "LTEX"), new SubrecordInfo("HNAM", offsetRepeating4, "NPC_", "RACE"), new SubrecordInfo("INAM", offsetZero, "CREA", "NPC_"), new SubrecordInfo("LVLO", offsetFour, "LVLC", "LVLI", "LVSP"), new SubrecordInfo("NAME", offsetZero), new SubrecordInfo("NAM2", offsetZero, "WRLD"), new SubrecordInfo("PFIG", offsetZero, "FLOR"), new SubrecordInfo("PKID", offsetZero), new SubrecordInfo("PNAM", offsetZero, "INFO"), new SubrecordInfo("QNAM", offsetZero, "CONT"), new SubrecordInfo("QSTA", offsetZero, "QUST"), new SubrecordInfo("QSTI", offsetZero), new SubrecordInfo("RDSD", offsetRepeating12, "REGN"), new SubrecordInfo("RDOT", offsetRepeating52, "REGN"), new SubrecordInfo("RDWT", offsetRepeating8, "REGN"), new SubrecordInfo("RNAM", offsetZero, "NPC_"), new SubrecordInfo("SCIT", offsetZero, "ENCH", "INGR", "SPEL"), new SubrecordInfo("SCRI", offsetZero), new SubrecordInfo("SCRO", offsetZero), new SubrecordInfo("SNAM", offsetZero, "ACTI", "CONT", "CREA", "DOOR", "LIGH", "NPC_", "WATR", "WRLD"), new SubrecordInfo("SPLO", offsetZero), new SubrecordInfo("TCLF", offsetZero, "INFO"), new SubrecordInfo("TCLT", offsetZero, "INFO"), new SubrecordInfo("TNAM", offsetZero, "DOOR", "LVLC"), new SubrecordInfo("VNAM", offsetZeroFour, "RACE"), new SubrecordInfo("WNAM", offsetZero, "REGN", "WRLD"), new SubrecordInfo("XCCM", offsetZero, "CELL"), new SubrecordInfo("XCLR", offsetRepeating4, "CELL"), new SubrecordInfo("XCWT", offsetZero, "CELL"), new SubrecordInfo("XESP", offsetZero), new SubrecordInfo("XGLB", offsetZero), new SubrecordInfo("XHRS", offsetZero, "ACHR"), new SubrecordInfo("XLOC", offsetFour, "REFR"), new SubrecordInfo("XMRC", offsetZero, "ACHR"), new SubrecordInfo("XNAM", offsetZero, "FACT", "RACE"), new SubrecordInfo("XOWN", offsetZero), new SubrecordInfo("XPCI", offsetZero), new SubrecordInfo("XRTM", offsetZero, "REFR"), new SubrecordInfo("XTEL", offsetZero, "REFR"), new SubrecordInfo("ZNAM", offsetZero)};
        functionInfo = new FunctionInfo[]{new FunctionInfo("GetCrime", 122, true, false), new FunctionInfo("GetDeadCount", 84, true, false), new FunctionInfo("GetDetected", 45, true, false), new FunctionInfo("GetDetectionLevel", 180, true, false), new FunctionInfo("GetDisposition", 76, true, false), new FunctionInfo("GetDistance", 1, true, false), new FunctionInfo("GetEquipped", 182, true, false), new FunctionInfo("GetFactionRank", 73, true, false), new FunctionInfo("GetFactionRankDifference", 60, true, true), new FunctionInfo("GetFriendHit", 288, true, false), new FunctionInfo("GetGlobalValue", 74, true, false), new FunctionInfo("GetHeadingAngle", 99, true, false), new FunctionInfo("GetInCell", 67, true, false), new FunctionInfo("GetInCellParam", 230, true, true), new FunctionInfo("GetInFaction", 71, true, false), new FunctionInfo("GetInSameCell", 32, true, false), new FunctionInfo("GetInWorldspace", 310, true, false), new FunctionInfo("GetIsClass", 68, true, false), new FunctionInfo("GetIsClassDefault", 228, true, false), new FunctionInfo("GetIsCurrentPackage", 161, true, false), new FunctionInfo("GetIsCurrentWeather", 149, true, false), new FunctionInfo("GetIsID", 72, true, false), new FunctionInfo("GetIsPlayerBirthsign", 224, true, false), new FunctionInfo("GetIsRace", 69, true, false), new FunctionInfo("GetIsReference", 136, true, false), new FunctionInfo("GetIsUsedItem", 246, true, false), new FunctionInfo("GetItemCount", 47, true, false), new FunctionInfo("GetLineOfSight", 27, true, false), new FunctionInfo("GetPCExpelled", 193, true, false), new FunctionInfo("GetPCFactionAttack", 199, true, false), new FunctionInfo("GetPCFactionMurder", 195, true, false), new FunctionInfo("GetPCFactionSteal", 197, true, false), new FunctionInfo("GetPCFactionSubmitAuthority", 201, true, false), new FunctionInfo("GetPCInFaction", 132, true, false), new FunctionInfo("GetPCIsClass", 129, true, false), new FunctionInfo("GetPCIsRace", 130, true, false), new FunctionInfo("GetQuestRunning", 56, true, false), new FunctionInfo("GetQuestVariable", 79, true, false), new FunctionInfo("GetScriptVariable", 53, true, false), new FunctionInfo("GetShouldAttack", 66, true, false), new FunctionInfo("GetStage", 58, true, false), new FunctionInfo("GetStageDone", 59, true, false), new FunctionInfo("GetTalkedToPCParam", 172, true, false), new FunctionInfo("HasMagicEffect", 214, true, false), new FunctionInfo("IsCellOwner", 280, true, true), new FunctionInfo("IsCurrentFurnitureObj", 163, true, false), new FunctionInfo("IsCurrentFurnitureRef", 162, true, false), new FunctionInfo("IsOwner", 278, true, false), new FunctionInfo("IsSpellTarget", 223, true, false), new FunctionInfo("SameFaction", 42, true, false), new FunctionInfo("SameRace", 43, true, false), new FunctionInfo("SameSex", 44, true, false)};
    }
}

