/*
 * Decompiled with CFR 0.152.
 */
package TES4Plugin;

import TES4Plugin.Plugin;
import TES4Plugin.PluginException;
import TES4Plugin.TES4Plugin;
import TES4Plugin.WorkerTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SaveTask
extends JDialog
implements ActionListener {
    private JDialog parent;
    private File pluginFile;
    private Plugin plugin;
    private WorkerTask worker;
    private boolean pluginSaved = false;

    public SaveTask(JDialog parent, File pluginFile, Plugin plugin) {
        super(parent, "Save Plugin", true);
        this.setDefaultCloseOperation(2);
        this.parent = parent;
        this.pluginFile = pluginFile;
        this.plugin = plugin;
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        JButton button = new JButton("Cancel");
        button.setActionCommand("cancel");
        button.addActionListener(this);
        buttonPane.add(button);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setOpaque(true);
        contentPane.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        JLabel label = new JLabel("Saving " + pluginFile.getName(), 0);
        contentPane.add((Component)label, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.setContentPane(contentPane);
        this.worker = new WorkerThread(this);
    }

    public static boolean savePlugin(JDialog parent, File pluginFile, Plugin plugin) {
        SaveTask task = new SaveTask(parent, pluginFile, plugin);
        task.worker.start();
        task.pack();
        task.setLocationRelativeTo(parent);
        task.setVisible(true);
        return task.pluginSaved;
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            String action = ae.getActionCommand();
            if (action.equals("save complete")) {
                this.setVisible(false);
                this.dispose();
                this.pluginSaved = true;
            } else if (action.equals("save failed")) {
                this.setVisible(false);
                this.dispose();
                Exception exc = (Exception)ae.getSource();
                if (exc instanceof PluginException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "Format Error", 0);
                } else if (exc instanceof IOException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "I/O Error", 0);
                } else if (exc instanceof InterruptedException) {
                    JOptionPane.showMessageDialog(this.parent, exc.getMessage(), "Interrupted", 0);
                } else {
                    TES4Plugin.logException("Plugin save failed", exc);
                }
            } else if (action.equals("cancel")) {
                this.worker.interrupt();
            }
        }
        catch (Throwable exc) {
            TES4Plugin.logException("Exception while processing action event", exc);
        }
    }

    private class WorkerThread
    extends WorkerTask {
        private Throwable exception;

        public WorkerThread(ActionListener listener) {
            super(listener);
        }

        public void run() {
            try {
                SaveTask.this.plugin.store(this);
            }
            catch (Throwable exc) {
                this.exception = exc;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ActionEvent ae = WorkerThread.this.exception == null ? new ActionEvent(this, 1001, "save complete") : new ActionEvent(WorkerThread.this.exception, 1001, "save failed");
                    WorkerThread.this.getListener().actionPerformed(ae);
                }
            });
        }
    }
}

