/*
 * Decompiled with CFR 0.152.
 */
package TES4Plugin;

import TES4Plugin.MainWindow;
import TES4Plugin.PluginSpill;
import TES4Plugin.WorkerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class TES4Plugin {
    public static JFrame mainWindow;
    public static String dataPath;
    public static String fileSeparator;
    public static File propFile;
    public static PluginSpill pluginSpill;
    public static Properties properties;
    public static boolean debugMode;

    public static void main(String[] args) {
        try {
            String tempPath;
            File dirFile;
            String debugString = System.getProperty("debug.plugin");
            if (debugString != null && debugString.equals("1")) {
                debugMode = true;
            }
            fileSeparator = System.getProperty("file.separator");
            dataPath = System.getProperty("user.home") + fileSeparator + "Local Settings" + fileSeparator + "Application Data" + fileSeparator + "Oblivion";
            if (debugMode) {
                System.out.printf("Application data path: %s\n", dataPath);
            }
            if (!(dirFile = new File(dataPath)).exists()) {
                dirFile.mkdirs();
            }
            propFile = new File(dataPath + fileSeparator + "TES4Plugin.properties");
            properties = new Properties();
            if (propFile.exists()) {
                FileInputStream in = new FileInputStream(propFile);
                properties.load(in);
                in.close();
            }
            if ((tempPath = System.getenv("TEMP")) == null || tempPath.length() == 0) {
                tempPath = dataPath;
            }
            if (debugMode) {
                System.out.printf("Temporary data path: %s\n", tempPath);
            }
            File spillFile = new File(tempPath + fileSeparator + "TES4Plugin.spill");
            pluginSpill = new PluginSpill(spillFile);
            if (debugMode) {
                System.out.println("Starting the Swing GUI");
            }
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TES4Plugin.createAndShowGUI();
                }
            });
        }
        catch (Exception exc) {
            TES4Plugin.logException("Exception during program initialization", exc);
        }
    }

    private static void createAndShowGUI() {
        try {
            JFrame.setDefaultLookAndFeelDecorated(true);
            mainWindow = new MainWindow();
            mainWindow.pack();
            mainWindow.setVisible(true);
        }
        catch (Exception exc) {
            TES4Plugin.logException("Exception during GUI initialization", exc);
        }
    }

    public static void saveProperties() {
        try {
            FileOutputStream out = new FileOutputStream(propFile);
            properties.store(out, "TES4Plugin Properties");
            out.close();
        }
        catch (Exception exc) {
            TES4Plugin.logException("Exception while saving application properties", exc);
        }
    }

    public static void logException(String text, Throwable exc) {
        System.runFinalization();
        System.gc();
        if (SwingUtilities.isEventDispatchThread()) {
            StringBuilder string = new StringBuilder(512);
            string.append("<html><b>");
            string.append(text);
            string.append("</b><br><br>");
            string.append(exc.toString());
            string.append("<br>");
            StackTraceElement[] trace = exc.getStackTrace();
            int count = 0;
            for (StackTraceElement elem : trace) {
                string.append(elem.toString());
                string.append("<br>");
                if (++count == 25) break;
            }
            string.append("</html>");
            JOptionPane.showMessageDialog(mainWindow, string, "Error", 0);
        } else {
            WorkerException.logException(mainWindow, text, exc);
        }
    }

    public static void dumpData(String text, byte[] data, int length) {
        System.out.println(text);
        for (int i = 0; i < length; ++i) {
            if (i % 32 == 0) {
                System.out.print(String.format(" %14X  ", i));
            } else if (i % 4 == 0) {
                System.out.print(" ");
            }
            System.out.print(String.format("%02X", data[i]));
            if (i % 32 != 31) continue;
            System.out.println();
        }
        if (length % 32 != 0) {
            System.out.println();
        }
    }

    static {
        debugMode = false;
    }
}

