/*
 * Decompiled with CFR 0.152.
 */
package TES4Gecko;

import TES4Gecko.DisplayPlugin;
import TES4Gecko.DisplaySubrecordDialog;
import TES4Gecko.FormAdjust;
import TES4Gecko.FormInfo;
import TES4Gecko.GroupNode;
import TES4Gecko.Main;
import TES4Gecko.Plugin;
import TES4Gecko.PluginException;
import TES4Gecko.PluginGroup;
import TES4Gecko.PluginNode;
import TES4Gecko.PluginRecord;
import TES4Gecko.PluginSubrecord;
import TES4Gecko.RecordNode;
import TES4Gecko.SaveTask;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.DataFormatException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DisplayDialog
extends DisplayPlugin
implements ActionListener,
TreeExpansionListener {
    private Plugin plugin;
    private PluginNode pluginNode;
    private File pluginFile;
    private DefaultTreeModel pluginTreeModel;
    private JTree pluginTree;
    private boolean pluginModified = false;
    private int masterCount;
    private JTextField searchField;
    private FormInfo searchFormInfo;
    private JTextField formField;
    private JCheckBox copyReferencesField;

    public DisplayDialog(JFrame parent, File pluginFile, PluginNode pluginNode) {
        super(parent, "Display " + pluginFile.getName());
        this.pluginFile = pluginFile;
        this.pluginNode = pluginNode;
        this.plugin = pluginNode.getPlugin();
        List<FormInfo> formList = this.plugin.getFormList();
        pluginNode.setFormAdjust(new FormAdjust());
        this.clipboardFile = new File(pluginFile.getParent() + Main.fileSeparator + "Gecko Clipboard.esp");
        this.clipboard = new Plugin(this.clipboardFile, this.plugin.getCreator(), this.plugin.getSummary(), this.plugin.getMasterList());
        this.clipboard.setVersion(this.plugin.getVersion());
        this.clipboard.createInitialGroups();
        List<String> masterList = this.plugin.getMasterList();
        this.masterCount = masterList.size();
        Object[] masterNames = new Object[]{"Index", "Master"};
        Object[][] masterData = new Object[this.masterCount][2];
        for (int i = 0; i < this.masterCount; ++i) {
            masterData[i][0] = String.format("%02X", i);
            masterData[i][1] = masterList.get(i);
        }
        JTable masterTable = new JTable(masterData, masterNames);
        masterTable.setColumnSelectionAllowed(false);
        masterTable.setRowSelectionAllowed(false);
        masterTable.getColumnModel().getColumn(0).setMaxWidth(45);
        masterTable.setAutoResizeMode(3);
        masterTable.setPreferredScrollableViewportSize(new Dimension(200, masterTable.getRowHeight() * Math.max(this.masterCount, 1)));
        JScrollPane masterScrollPane = new JScrollPane(masterTable);
        masterScrollPane.getViewport().setBackground(Main.backgroundColor);
        JLabel searchLabel = new JLabel("Editor ID Search");
        searchLabel.setHorizontalAlignment(0);
        this.searchField = new JTextField(20);
        this.searchField.setActionCommand("find editor id");
        this.searchField.addActionListener(this);
        JPanel buttonPane = new JPanel();
        buttonPane.setBackground(Main.backgroundColor);
        buttonPane.add(Box.createGlue());
        JButton button = new JButton("Find");
        button.setActionCommand("find editor id");
        button.addActionListener(this);
        buttonPane.add(button);
        buttonPane.add(Box.createHorizontalStrut(10));
        button = new JButton("Find Next");
        button.setActionCommand("find next editor id");
        button.addActionListener(this);
        buttonPane.add(button);
        buttonPane.add(Box.createGlue());
        BorderLayout searchLayout = new BorderLayout();
        searchLayout.setVgap(10);
        JPanel searchPane = new JPanel(searchLayout);
        searchPane.setBackground(Main.backgroundColor);
        searchPane.setBorder(BorderFactory.createEtchedBorder(Color.WHITE, Color.BLACK));
        searchPane.add((Component)searchLabel, "North");
        searchPane.add((Component)this.searchField, "Center");
        searchPane.add((Component)buttonPane, "South");
        searchPane.setMaximumSize(new Dimension(200, 50));
        searchLabel = new JLabel("Form ID Search");
        searchLabel.setHorizontalAlignment(0);
        this.formField = new JTextField(10);
        this.formField.setActionCommand("find form id");
        this.formField.addActionListener(this);
        button = new JButton("Find");
        button.setActionCommand("find form id");
        button.addActionListener(this);
        buttonPane = new JPanel();
        buttonPane.setBackground(Main.backgroundColor);
        buttonPane.add(Box.createGlue());
        buttonPane.add(button);
        buttonPane.add(Box.createGlue());
        searchLayout = new BorderLayout();
        searchLayout.setVgap(10);
        JPanel formPane = new JPanel(searchLayout);
        formPane.setBackground(Main.backgroundColor);
        formPane.setBorder(BorderFactory.createEtchedBorder(Color.WHITE, Color.BLACK));
        formPane.add((Component)searchLabel, "North");
        formPane.add((Component)this.formField, "Center");
        formPane.add((Component)buttonPane, "South");
        formPane.setMaximumSize(new Dimension(200, 50));
        this.copyReferencesField = new JCheckBox("Copy referenced items", this.copyReferences);
        this.copyReferencesField.setBackground(Main.backgroundColor);
        this.copyReferencesField.setActionCommand("copy references");
        this.copyReferencesField.addActionListener(this);
        JPanel copyReferencesPanel = new JPanel();
        copyReferencesPanel.setBackground(Main.backgroundColor);
        copyReferencesPanel.add(this.copyReferencesField);
        JPanel sidePane = new JPanel();
        sidePane.setLayout(new BoxLayout(sidePane, 1));
        sidePane.setBackground(Main.backgroundColor);
        sidePane.add(Box.createGlue());
        sidePane.add(masterScrollPane);
        sidePane.add(Box.createVerticalStrut(25));
        sidePane.add(searchPane);
        sidePane.add(Box.createVerticalStrut(25));
        sidePane.add(formPane);
        sidePane.add(Box.createVerticalStrut(25));
        sidePane.add(copyReferencesPanel);
        sidePane.add(Box.createGlue());
        this.pluginTreeModel = new DefaultTreeModel(pluginNode);
        this.pluginTree = new JTree(this.pluginTreeModel);
        this.pluginTree.setCellRenderer(new DisplayCellRenderer());
        this.pluginTree.setScrollsOnExpand(true);
        this.pluginTree.setExpandsSelectedPaths(true);
        this.pluginTree.addTreeExpansionListener(this);
        JScrollPane pluginScrollPane = new JScrollPane(this.pluginTree);
        pluginScrollPane.setHorizontalScrollBarPolicy(32);
        pluginScrollPane.setVerticalScrollBarPolicy(22);
        pluginScrollPane.setPreferredSize(new Dimension(300, 500));
        JPanel labelPane = new JPanel();
        labelPane.setBackground(Main.backgroundColor);
        labelPane.add(new JLabel(pluginFile.getName()));
        buttonPane = new JPanel(new GridLayout(3, 2, 5, 5));
        buttonPane.setBackground(Main.backgroundColor);
        button = new JButton("Toggle Ignore");
        button.setActionCommand("toggle ignore");
        button.addActionListener(this);
        buttonPane.add(button);
        button = new JButton("Copy to Clipboard");
        button.setActionCommand("copy record");
        button.addActionListener(this);
        buttonPane.add(button);
        button = new JButton("Display Subrecord");
        button.setActionCommand("display subrecord");
        button.addActionListener(this);
        buttonPane.add(button);
        button = new JButton("Delete Subrecord");
        button.setActionCommand("delete subrecord");
        button.addActionListener(this);
        buttonPane.add(button);
        button = new JButton("Save Plugin");
        button.setActionCommand("save plugin");
        button.addActionListener(this);
        buttonPane.add(button);
        JPanel pluginPane = new JPanel();
        pluginPane.setLayout(new BoxLayout(pluginPane, 1));
        pluginPane.setBackground(Main.backgroundColor);
        pluginPane.setBorder(BorderFactory.createEtchedBorder(Color.WHITE, Color.BLACK));
        pluginPane.add(labelPane);
        pluginPane.add(pluginScrollPane);
        pluginPane.add(Box.createVerticalStrut(10));
        pluginPane.add(buttonPane);
        PluginNode rootNode = new PluginNode(this.clipboard);
        List<PluginGroup> groupList = this.clipboard.getGroupList();
        for (PluginGroup group : groupList) {
            GroupNode groupNode = new GroupNode(group);
            rootNode.insert(groupNode);
        }
        this.clipboardTreeModel = new DefaultTreeModel(rootNode);
        this.clipboardTree = new JTree(this.clipboardTreeModel);
        this.clipboardTree.setScrollsOnExpand(true);
        this.clipboardTree.setSelectionModel(null);
        this.clipboardTree.addTreeExpansionListener(this);
        JScrollPane clipboardScrollPane = new JScrollPane(this.clipboardTree);
        clipboardScrollPane.setHorizontalScrollBarPolicy(32);
        clipboardScrollPane.setVerticalScrollBarPolicy(22);
        clipboardScrollPane.setPreferredSize(new Dimension(300, 500));
        labelPane = new JPanel();
        labelPane.setBackground(Main.backgroundColor);
        labelPane.add(new JLabel(this.clipboardFile.getName()));
        buttonPane = new JPanel(new GridLayout(3, 2, 5, 5));
        buttonPane.setBackground(Main.backgroundColor);
        button = new JButton("Save Clipboard");
        button.setActionCommand("save clipboard");
        button.addActionListener(this);
        buttonPane.add(button);
        buttonPane.add(Box.createGlue());
        buttonPane.add(Box.createGlue());
        buttonPane.add(Box.createGlue());
        buttonPane.add(Box.createGlue());
        JPanel clipboardPane = new JPanel();
        clipboardPane.setLayout(new BoxLayout(clipboardPane, 1));
        clipboardPane.setBackground(Main.backgroundColor);
        clipboardPane.setBorder(BorderFactory.createEtchedBorder(Color.WHITE, Color.BLACK));
        clipboardPane.add(labelPane);
        clipboardPane.add(clipboardScrollPane);
        clipboardPane.add(Box.createVerticalStrut(10));
        clipboardPane.add(buttonPane);
        JPanel treePane = new JPanel();
        treePane.setLayout(new BoxLayout(treePane, 0));
        treePane.setBackground(Main.backgroundColor);
        treePane.add(sidePane);
        treePane.add(Box.createHorizontalStrut(15));
        treePane.add(pluginPane);
        treePane.add(Box.createHorizontalStrut(15));
        treePane.add(clipboardPane);
        buttonPane = new JPanel();
        buttonPane.setBackground(Main.backgroundColor);
        button = new JButton("Done");
        button.setActionCommand("done");
        button.addActionListener(this);
        buttonPane.add(button);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.setOpaque(true);
        contentPane.setBackground(Main.backgroundColor);
        contentPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        contentPane.add(treePane);
        contentPane.add(Box.createVerticalStrut(15));
        contentPane.add(buttonPane);
        contentPane.setPreferredSize(new Dimension(975, 650));
        this.setContentPane(contentPane);
        this.addWindowListener(new DialogWindowListener());
    }

    public static void showDialog(JFrame parent, File pluginFile, PluginNode pluginNode) {
        DisplayDialog dialog = new DisplayDialog(parent, pluginFile, pluginNode);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            String action = ae.getActionCommand();
            if (action.equals("save plugin")) {
                if (this.pluginModified && SaveTask.savePlugin(this, this.pluginFile, this.plugin)) {
                    this.pluginModified = false;
                    this.validateTree(this.pluginTree);
                }
            } else if (action.equals("save clipboard")) {
                if (this.clipboardModified && SaveTask.savePlugin(this, this.clipboardFile, this.clipboard)) {
                    this.clipboardModified = false;
                    this.validateTree(this.clipboardTree);
                }
            } else if (action.equals("copy record")) {
                this.copyRecords(this.pluginTree);
            } else if (action.equals("display subrecord")) {
                this.displaySubrecordData();
            } else if (action.equals("delete subrecord")) {
                this.deleteSubrecords();
            } else if (action.equals("toggle ignore")) {
                if (this.toggleIgnore(this.pluginTree)) {
                    this.pluginModified = true;
                }
            } else if (action.equals("find editor id")) {
                this.findEditorID(false);
            } else if (action.equals("find next editor id")) {
                this.findEditorID(true);
            } else if (action.equals("find form id")) {
                this.findFormID();
            } else if (action.equals("copy references")) {
                this.copyReferences = this.copyReferencesField.isSelected();
            } else if (action.equals("done")) {
                this.closeDialog();
                this.setVisible(false);
                this.dispose();
            }
        }
        catch (Throwable exc) {
            Main.logException("Exception while processing action event", exc);
        }
    }

    private void findFormID() {
        String text = this.formField.getText();
        if (text == null || text.length() == 0) {
            JOptionPane.showMessageDialog(this, "You must enter a search term", "Enter search term", 0);
            return;
        }
        FormInfo formInfo = null;
        try {
            int formID = Integer.parseInt(text, 16);
            formInfo = this.plugin.getFormMap().get(new Integer(formID));
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        if (formInfo == null) {
            JOptionPane.showMessageDialog(this, "No match found for '" + text + "'", "No match found", 0);
        } else {
            this.pluginTree.clearSelection();
            RecordNode recordNode = formInfo.getRecordNode();
            TreePath treePath = new TreePath(recordNode.getPath());
            this.pluginTree.setSelectionPath(treePath);
            this.pluginTree.scrollPathToVisible(treePath);
        }
    }

    private void findEditorID(boolean resume) {
        String text;
        if (!resume) {
            this.searchFormInfo = null;
        }
        if ((text = this.searchField.getText()) == null || text.length() == 0) {
            JOptionPane.showMessageDialog(this, "You must enter a search term", "Enter search term", 0);
            return;
        }
        Pattern p = null;
        try {
            p = Pattern.compile(text, 2);
        }
        catch (PatternSyntaxException exc) {
            JOptionPane.showMessageDialog(this, "'" + text + "' is not a valid regular expression", "Invalid regular expression", 0);
        }
        if (p == null) {
            return;
        }
        List<FormInfo> formList = this.plugin.getFormList();
        for (FormInfo formInfo : formList) {
            Matcher m;
            if (this.searchFormInfo != null) {
                if (this.searchFormInfo != formInfo) continue;
                this.searchFormInfo = null;
                continue;
            }
            String editorID = formInfo.getEditorID();
            if (editorID == null || editorID.length() <= 0 || !(m = p.matcher(editorID)).matches()) continue;
            this.searchFormInfo = formInfo;
            break;
        }
        if (this.searchFormInfo == null) {
            JOptionPane.showMessageDialog(this, "No match found for '" + text + "'", "No match found", 0);
        } else {
            this.pluginTree.clearSelection();
            RecordNode recordNode = this.searchFormInfo.getRecordNode();
            TreePath treePath = new TreePath(recordNode.getPath());
            this.pluginTree.setSelectionPath(treePath);
            this.pluginTree.scrollPathToVisible(treePath);
        }
    }

    private void closeDialog() {
        int selection;
        if (this.pluginModified && (selection = JOptionPane.showConfirmDialog(this, "The plugin has been modified. Do you want to save the changes?", "Plugin Modified", 0, 3)) == 0) {
            SaveTask.savePlugin(this, this.pluginFile, this.plugin);
        }
        if (this.clipboardModified && (selection = JOptionPane.showConfirmDialog(this, "The clipboard has been modified. Do you want to save the changes?", "Clipboard Modified", 0, 3)) == 0) {
            SaveTask.savePlugin(this, this.clipboardFile, this.clipboard);
        }
    }

    private void displaySubrecordData() {
        Object userObject;
        DefaultMutableTreeNode node;
        TreePath[] treePaths = this.pluginTree.getSelectionPaths();
        if (treePaths == null) {
            JOptionPane.showMessageDialog(this, "You must select a subrecord to display.", "Error", 0);
            return;
        }
        for (TreePath treePath : treePaths) {
            node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            userObject = node.getUserObject();
            if (userObject instanceof PluginSubrecord) continue;
            JOptionPane.showMessageDialog(this, "Only subrecords may be displayed.", "Error", 0);
            return;
        }
        for (TreePath treePath : treePaths) {
            node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            userObject = node.getUserObject();
            DisplaySubrecordDialog.showDialog(this, (PluginSubrecord)userObject);
        }
    }

    private void deleteSubrecords() throws DataFormatException, IOException, PluginException {
        TreePath[] treePaths = this.pluginTree.getSelectionPaths();
        if (treePaths == null) {
            JOptionPane.showMessageDialog(this, "You must select a subrecord to delete.", "Error", 0);
            return;
        }
        for (TreePath treePath : treePaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (userObject instanceof PluginSubrecord) continue;
            JOptionPane.showMessageDialog(this, "Only subrecords may be deleted.", "Error", 0);
            return;
        }
        for (TreePath treePath : treePaths) {
            DefaultMutableTreeNode subrecordNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            RecordNode recordNode = (RecordNode)subrecordNode.getParent();
            PluginRecord record = recordNode.getRecord();
            PluginSubrecord subrecord = (PluginSubrecord)subrecordNode.getUserObject();
            List<PluginSubrecord> subrecords = record.getSubrecords();
            ListIterator<PluginSubrecord> lit = subrecords.listIterator();
            while (lit.hasNext()) {
                PluginSubrecord checkSubrecord = lit.next();
                if (!checkSubrecord.equals(subrecord)) continue;
                lit.remove();
                break;
            }
            record.setSubrecords(subrecords);
            this.pluginModified = true;
            recordNode.remove(subrecordNode);
            DefaultTreeModel model = (DefaultTreeModel)this.pluginTree.getModel();
            model.nodeStructureChanged(recordNode);
        }
    }

    public void treeExpanded(TreeExpansionEvent event) {
        RecordNode recordNode;
        DefaultMutableTreeNode subrecordNode;
        JTree tree = (JTree)event.getSource();
        TreePath treePath = event.getPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (node instanceof RecordNode && (subrecordNode = (DefaultMutableTreeNode)(recordNode = (RecordNode)node).getFirstChild()).getUserObject() == null) {
            try {
                recordNode.removeAllChildren();
                this.createRecordChildren(recordNode);
                DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
                model.nodeStructureChanged(recordNode);
            }
            catch (Throwable exc) {
                Main.logException("Exception while creating subrecords", exc);
            }
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    private class DisplayCellRenderer
    extends DefaultTreeCellRenderer {
        public DisplayCellRenderer() {
            this.setTextSelectionColor(Color.WHITE);
            this.setTextNonSelectionColor(Color.BLACK);
            this.setBackgroundSelectionColor(Color.BLUE);
            this.setBackgroundNonSelectionColor(Color.WHITE);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
            Component component = super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
            if (value instanceof RecordNode) {
                this.setBackgroundNonSelectionColor(((RecordNode)value).getRecord().getFormID() >>> 24 < DisplayDialog.this.masterCount ? Color.YELLOW : Color.WHITE);
            } else {
                this.setBackgroundNonSelectionColor(Color.WHITE);
            }
            return component;
        }
    }

    private class DialogWindowListener
    extends WindowAdapter {
        public void windowClosing(WindowEvent we) {
            DisplayDialog.this.closeDialog();
        }
    }
}

