/*
 * Decompiled with CFR 0.152.
 */
package TES4Gecko;

import TES4Gecko.FormAdjust;
import TES4Gecko.FormInfo;
import TES4Gecko.GroupNode;
import TES4Gecko.Plugin;
import TES4Gecko.PluginException;
import TES4Gecko.PluginGroup;
import TES4Gecko.PluginNode;
import TES4Gecko.PluginRecord;
import TES4Gecko.PluginSubrecord;
import TES4Gecko.RecordNode;
import TES4Gecko.SerializedElement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class DisplayPlugin
extends JDialog {
    protected Plugin clipboard;
    protected File clipboardFile;
    protected JTree clipboardTree;
    protected DefaultTreeModel clipboardTreeModel;
    protected boolean clipboardModified = false;
    protected boolean copyReferences = true;

    public DisplayPlugin(JFrame parent, String title) {
        super(parent, title, true);
        this.setDefaultCloseOperation(2);
    }

    protected void createRecordChildren(RecordNode recordNode) throws DataFormatException, IOException, PluginException {
        List<PluginSubrecord> subrecordList = recordNode.getRecord().getSubrecords();
        for (PluginSubrecord subrecord : subrecordList) {
            subrecord.setSpillMode(true);
            DefaultMutableTreeNode subrecordNode = new DefaultMutableTreeNode(subrecord);
            recordNode.add(subrecordNode);
        }
    }

    protected boolean toggleIgnore(JTree tree) {
        boolean pluginModified = false;
        TreePath[] treePaths = tree.getSelectionPaths();
        if (treePaths == null) {
            JOptionPane.showMessageDialog(this, "You must select at least one record.", "Error", 0);
        } else {
            for (TreePath treePath : treePaths) {
                TreeNode node = (TreeNode)treePath.getLastPathComponent();
                if (node instanceof PluginNode) {
                    JOptionPane.showMessageDialog(this, "The entire plugin can not be selected.  The selection will be ignored.", "Warning", 2);
                    continue;
                }
                if (node instanceof GroupNode) {
                    if (!this.toggleGroupIgnore(tree, treePath, (GroupNode)node)) continue;
                    pluginModified = true;
                    continue;
                }
                if (node instanceof RecordNode) {
                    if (!this.toggleRecordIgnore(tree, treePath, (RecordNode)node)) continue;
                    DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                    treeModel.nodeChanged(node);
                    pluginModified = true;
                    continue;
                }
                JOptionPane.showMessageDialog(this, "A subrecord can not be ignored.  The selection will be ignored.", "Warning", 2);
            }
        }
        return pluginModified;
    }

    private boolean toggleGroupIgnore(JTree tree, TreePath groupPath, GroupNode groupNode) {
        boolean pluginModified = false;
        int childCount = groupNode.getChildCount();
        ArrayList<Integer> childList = new ArrayList<Integer>(childCount);
        for (int i = 0; i < childCount; ++i) {
            TreeNode node = groupNode.getChildAt(i);
            TreePath treePath = groupPath.pathByAddingChild(node);
            if (node instanceof GroupNode) {
                if (!this.toggleGroupIgnore(tree, treePath, (GroupNode)node)) continue;
                pluginModified = true;
                continue;
            }
            if (!(node instanceof RecordNode) || !this.toggleRecordIgnore(tree, treePath, (RecordNode)node)) continue;
            childList.add(new Integer(i));
            pluginModified = true;
        }
        childCount = childList.size();
        if (childCount > 0) {
            int[] childIndices = new int[childCount];
            for (int i = 0; i < childCount; ++i) {
                childIndices[i] = (Integer)childList.get(i);
            }
            DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
            treeModel.nodesChanged(groupNode, childIndices);
        }
        return pluginModified;
    }

    private boolean toggleRecordIgnore(JTree tree, TreePath treePath, RecordNode recordNode) {
        Integer objFormID;
        Map<Integer, FormInfo> formMap;
        PluginRecord record;
        Plugin plugin = ((PluginNode)treePath.getPathComponent(0)).getPlugin();
        record.setIgnore(!(record = recordNode.getRecord()).isIgnored());
        if (!record.isIgnored() && (formMap = plugin.getFormMap()).get(objFormID = new Integer(record.getFormID())) == null) {
            GroupNode parentNode = (GroupNode)recordNode.getParent();
            PluginGroup parentGroup = parentNode.getGroup();
            FormInfo formInfo = new FormInfo(record, record.getRecordType(), record.getFormID(), record.getEditorID());
            formInfo.setRecordNode(recordNode);
            formInfo.setParentFormID(parentGroup.getGroupParentID());
            plugin.getFormList().add(formInfo);
            formMap.put(objFormID, formInfo);
        }
        return true;
    }

    protected void copyRecords(JTree pluginTree) throws DataFormatException, IOException, PluginException {
        PluginNode pluginNode = (PluginNode)pluginTree.getModel().getRoot();
        Plugin plugin = pluginNode.getPlugin();
        FormAdjust formAdjust = pluginNode.getFormAdjust();
        TreePath[] treePaths = pluginTree.getSelectionPaths();
        if (treePaths == null) {
            JOptionPane.showMessageDialog(this, "You must select at least one record to copy.", "Error", 0);
            return;
        }
        block0: for (TreePath treePath : treePaths) {
            GroupNode parentNode;
            DefaultMutableTreeNode pathNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (pathNode instanceof PluginNode) {
                JOptionPane.showMessageDialog(this, "The entire plugin can not be selected.  The selection will be ignored.", "Warning", 2);
                continue;
            }
            if (pathNode instanceof GroupNode) {
                PluginGroup group = ((GroupNode)pathNode).getGroup();
                if (group.getGroupType() == 0) {
                    PluginNode rootNode = (PluginNode)this.clipboardTreeModel.getRoot();
                    int childCount = rootNode.getChildCount();
                    String groupRecordType = group.getGroupRecordType();
                    for (int i = 0; i < childCount; ++i) {
                        GroupNode parentNode2 = (GroupNode)rootNode.getChildAt(i);
                        if (!parentNode2.getGroup().getGroupRecordType().equals(groupRecordType)) continue;
                        List<PluginRecord> recordList = group.getRecordList();
                        for (PluginRecord record : recordList) {
                            if (record instanceof PluginGroup) {
                                this.copyGroup(plugin, formAdjust, (PluginGroup)record, parentNode2);
                                continue;
                            }
                            this.copyRecord(plugin, formAdjust, record, parentNode2);
                        }
                        continue block0;
                    }
                    continue;
                }
                parentNode = this.createHierarchy(plugin, formAdjust, group);
                this.copyGroup(plugin, formAdjust, group, parentNode);
                continue;
            }
            if (pathNode instanceof RecordNode) {
                PluginRecord record = ((RecordNode)pathNode).getRecord();
                parentNode = this.createHierarchy(plugin, formAdjust, record);
                this.copyRecord(plugin, formAdjust, record, parentNode);
                continue;
            }
            JOptionPane.showMessageDialog(this, "An individual subrecord can not be copied.  The selection will be ignored.", "Warning", 2);
        }
    }

    private GroupNode createHierarchy(Plugin plugin, FormAdjust formAdjust, PluginRecord record) throws DataFormatException, IOException, PluginException {
        PluginGroup group;
        int groupType;
        RecordNode recordNode;
        List<PluginRecord> recordList;
        DefaultMutableTreeNode node;
        GroupNode groupNode;
        int i;
        GroupNode parentNode = null;
        PluginGroup parentGroup = this.clipboard.createHierarchy(record, formAdjust);
        ArrayList<PluginGroup> groupList = new ArrayList<PluginGroup>(10);
        PluginGroup topGroup = parentGroup;
        while (topGroup.getGroupType() != 0) {
            groupList.add(topGroup);
            topGroup = (PluginGroup)topGroup.getParent();
        }
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.clipboardTreeModel.getRoot();
        int childCount = rootNode.getChildCount();
        for (i = 0; i < childCount && (parentNode = (GroupNode)rootNode.getChildAt(i)).getGroup() != topGroup; ++i) {
        }
        for (i = groupList.size() - 1; i >= 0; --i) {
            PluginGroup group2 = (PluginGroup)groupList.get(i);
            groupNode = null;
            childCount = parentNode.getChildCount();
            boolean foundGroup = false;
            for (int j = 0; j < childCount; ++j) {
                node = (DefaultMutableTreeNode)parentNode.getChildAt(j);
                if (node.getUserObject() != group2) continue;
                groupNode = (GroupNode)node;
                foundGroup = true;
                break;
            }
            if (!foundGroup) {
                int groupType2 = group2.getGroupType();
                if (groupType2 == 1 || groupType2 == 6 || groupType2 == 7) {
                    int formID = group2.getGroupParentID();
                    parentGroup = parentNode.getGroup();
                    recordList = parentGroup.getRecordList();
                    int index = recordList.indexOf(group2);
                    if (index < 1) {
                        throw new PluginException("Type " + groupType2 + " subgroup not preceded by WRLD/CELL/DIAL record");
                    }
                    PluginRecord prevRecord = recordList.get(index - 1);
                    String recordType = prevRecord.getRecordType();
                    if (!(recordType.equals("WRLD") || recordType.equals("CELL") || recordType.equals("DIAL"))) {
                        throw new PluginException("Type " + groupType2 + " subgroup not preceded by WRLD/CELL/DIAL record");
                    }
                    if (prevRecord.getFormID() != formID) {
                        throw new PluginException("WRLD/CELL/DIAL record form ID mismatch");
                    }
                    recordNode = new RecordNode(prevRecord);
                    this.createRecordChildren(recordNode);
                    parentNode.add(recordNode);
                    groupNode = new GroupNode(group2);
                    parentNode.add(groupNode);
                    int[] childIndices = new int[]{childCount, childCount + 1};
                    this.clipboardTreeModel.nodesWereInserted(parentNode, childIndices);
                } else {
                    groupNode = new GroupNode(group2);
                    int[] childIndices = new int[1];
                    if (groupType2 == 10 || groupType2 == 8) {
                        childIndices[0] = 0;
                        parentNode.insert(groupNode, 0);
                    } else {
                        parentNode.add(groupNode);
                        childIndices[0] = childCount;
                    }
                    this.clipboardTreeModel.nodesWereInserted(parentNode, childIndices);
                }
                this.clipboardModified = true;
            }
            parentNode = groupNode;
        }
        if (record instanceof PluginGroup && ((groupType = (group = (PluginGroup)record).getGroupType()) == 1 || groupType == 6 || groupType == 7)) {
            int i2;
            int formID = formAdjust.adjustFormID(group.getGroupParentID());
            childCount = parentNode.getChildCount();
            boolean foundRecord = false;
            for (i2 = 0; i2 < childCount; ++i2) {
                node = (DefaultMutableTreeNode)parentNode.getChildAt(i2);
                if (!(node instanceof RecordNode) || ((RecordNode)node).getRecord().getFormID() != formID) continue;
                foundRecord = true;
                break;
            }
            if (!foundRecord) {
                recordList = parentNode.getGroup().getRecordList();
                int recordCount = recordList.size();
                for (i2 = 0; i2 < recordCount; ++i2) {
                    PluginRecord checkRecord = recordList.get(i2);
                    if (checkRecord instanceof PluginGroup || checkRecord.getFormID() != formID) continue;
                    if (i2 > recordCount - 2) {
                        throw new PluginException("WRLD/CELL/DIAL record not followed by subgroup");
                    }
                    recordNode = new RecordNode(checkRecord);
                    if (checkRecord.getRecordLength() != 0) {
                        recordNode.add(new DefaultMutableTreeNode(null));
                    }
                    parentNode.add(recordNode);
                    groupNode = new GroupNode((PluginGroup)recordList.get(i2 + 1));
                    parentNode.add(groupNode);
                    int[] childIndices = new int[]{childCount, childCount + 1};
                    this.clipboardTreeModel.nodesWereInserted(parentNode, childIndices);
                    this.clipboardModified = true;
                    break;
                }
            }
        }
        return parentNode;
    }

    private void copyGroup(Plugin plugin, FormAdjust formAdjust, PluginGroup group, GroupNode parentNode) throws DataFormatException, IOException, PluginException {
        PluginGroup parentGroup = parentNode.getGroup();
        int groupType = group.getGroupType();
        byte[] groupLabel = group.getGroupLabel();
        switch (groupType) {
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                int oldFormID = SerializedElement.getInteger(groupLabel, 0);
                int newFormID = formAdjust.adjustFormID(oldFormID);
                SerializedElement.setInteger(newFormID, groupLabel, 0);
            }
        }
        int childCount = parentNode.getChildCount();
        GroupNode clipboardNode = null;
        boolean foundGroup = false;
        for (int index = 0; index < childCount; ++index) {
            byte[] checkLabel;
            PluginGroup checkGroup;
            TreeNode node = parentNode.getChildAt(index);
            if (!(node instanceof GroupNode) || (checkGroup = (clipboardNode = (GroupNode)node).getGroup()).getGroupType() != groupType || groupLabel[0] != (checkLabel = checkGroup.getGroupLabel())[0] || groupLabel[1] != checkLabel[1] || groupLabel[2] != checkLabel[2] || groupLabel[3] != checkLabel[3]) continue;
            foundGroup = true;
            break;
        }
        if (!foundGroup) {
            PluginGroup clipboardGroup = new PluginGroup(groupType, groupLabel);
            clipboardGroup.setParent(parentGroup);
            if (groupType == 10 || groupType == 8) {
                parentGroup.getRecordList().add(0, clipboardGroup);
            } else {
                parentGroup.getRecordList().add(clipboardGroup);
            }
            clipboardNode = new GroupNode(clipboardGroup);
            int[] childIndices = new int[1];
            if (groupType == 10 || groupType == 8) {
                childIndices[0] = 0;
                parentNode.insert(clipboardNode, 0);
            } else {
                childIndices[0] = childCount;
                parentNode.add(clipboardNode);
            }
            this.clipboardTreeModel.nodesWereInserted(parentNode, childIndices);
            this.clipboardModified = true;
        }
        List<PluginRecord> recordList = group.getRecordList();
        for (PluginRecord record : recordList) {
            if (record instanceof PluginGroup) {
                this.copyGroup(plugin, formAdjust, (PluginGroup)record, clipboardNode);
                continue;
            }
            this.copyRecord(plugin, formAdjust, record, clipboardNode);
        }
    }

    private void copyRecord(Plugin plugin, FormAdjust formAdjust, PluginRecord record, GroupNode parentNode) throws DataFormatException, IOException, PluginException {
        PluginGroup parentGroup = parentNode.getGroup();
        String recordType = record.getRecordType();
        int formID = formAdjust.adjustFormID(record.getFormID());
        Integer mapID = new Integer(formID);
        Map<Integer, FormInfo> formMap = this.clipboard.getFormMap();
        if (formMap.get(mapID) != null) {
            return;
        }
        this.clipboard.copyRecord(record, formAdjust);
        PluginRecord clipboardRecord = (PluginRecord)formMap.get(mapID).getSource();
        this.clipboardModified = true;
        List<PluginRecord> recordList = parentGroup.getRecordList();
        int recordCount = recordList.size();
        int childCount = parentNode.getChildCount();
        for (int i = 0; i < recordCount; ++i) {
            TreeNode node;
            int index;
            PluginRecord checkRecord = recordList.get(i);
            if (checkRecord != clipboardRecord) continue;
            if (recordType.equals("WRLD") || recordType.equals("CELL") || recordType.equals("DIAL")) {
                if (i > recordCount - 2) {
                    throw new PluginException("WRLD/CELL/DIAL record not followed by subgroup");
                }
                checkRecord = recordList.get(i + 1);
                if (!(checkRecord instanceof PluginGroup)) {
                    throw new PluginException("WRLD/CELL/DIAL record not followed by subgroup");
                }
                PluginGroup clipboardGroup = (PluginGroup)checkRecord;
                if (clipboardGroup.getGroupParentID() != formID) {
                    throw new PluginException("WRLD/CELL/DIAL record not followed by subgroup");
                }
                RecordNode recordNode = new RecordNode(clipboardRecord);
                this.createRecordChildren(recordNode);
                parentNode.add(recordNode);
                GroupNode groupNode = new GroupNode(clipboardGroup);
                parentNode.add(groupNode);
                int[] childIndices = new int[]{childCount, childCount + 1};
                this.clipboardTreeModel.nodesWereInserted(parentNode, childIndices);
                continue;
            }
            RecordNode recordNode = new RecordNode(clipboardRecord);
            this.createRecordChildren(recordNode);
            for (index = 0; !(index >= childCount || (node = parentNode.getChildAt(index)) instanceof RecordNode && recordNode.compareTo((RecordNode)node) < 0); ++index) {
            }
            parentNode.insert(recordNode, index);
            int[] childIndices = new int[]{index};
            this.clipboardTreeModel.nodesWereInserted(parentNode, childIndices);
        }
        if (this.copyReferences) {
            this.copyRecordReferences(plugin, formAdjust, record);
        }
    }

    private void copyRecordReferences(Plugin plugin, FormAdjust formAdjust, PluginRecord record) throws DataFormatException, IOException, PluginException {
        Map<Integer, FormInfo> formMap = plugin.getFormMap();
        int masterCount = plugin.getMasterList().size();
        Map<Integer, FormInfo> clipboardMap = this.clipboard.getFormMap();
        List<PluginSubrecord> subrecordList = record.getSubrecords();
        for (PluginSubrecord subrecord : subrecordList) {
            int[][] references = subrecord.getReferences();
            if (references == null) continue;
            for (int i = 0; i < references.length; ++i) {
                PluginRecord refRecord;
                FormInfo formInfo;
                Integer objFormID;
                int masterID;
                int formID = references[i][1];
                if (formID == 0 || (masterID = formID >>> 24) < masterCount || clipboardMap.get(objFormID = new Integer(formID)) != null || (formInfo = formMap.get(objFormID)) == null || (refRecord = (PluginRecord)formInfo.getSource()) == null) continue;
                GroupNode parentNode = this.createHierarchy(plugin, formAdjust, refRecord);
                this.copyRecord(plugin, formAdjust, refRecord, parentNode);
            }
        }
    }

    protected void validateTree(JTree tree) {
        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        PluginNode root = (PluginNode)treeModel.getRoot();
        Enumeration<TreeNode> nodes = root.children();
        while (nodes.hasMoreElements()) {
            GroupNode groupNode = (GroupNode)nodes.nextElement();
            boolean subtreeChanged = this.validateTreeGroup(treeModel, groupNode);
            if (!subtreeChanged) continue;
            treeModel.nodeStructureChanged(groupNode);
        }
    }

    private boolean validateTreeGroup(DefaultTreeModel treeModel, GroupNode parentNode) {
        boolean nodeStructureChanged = false;
        PluginGroup parentGroup = parentNode.getGroup();
        int index = 0;
        while (index < parentNode.getChildCount()) {
            RecordNode recordNode;
            PluginRecord record;
            boolean removeNode = false;
            TreeNode node = parentNode.getChildAt(index);
            if (node instanceof GroupNode) {
                GroupNode groupNode = (GroupNode)node;
                PluginGroup group = groupNode.getGroup();
                boolean subtreeChanged = this.validateTreeGroup(treeModel, groupNode);
                if (subtreeChanged) {
                    nodeStructureChanged = true;
                }
                if (group.isEmpty()) {
                    List<PluginRecord> recordList = parentGroup.getRecordList();
                    removeNode = true;
                    for (PluginRecord groupRecord : recordList) {
                        if (groupRecord != group) continue;
                        removeNode = false;
                        break;
                    }
                }
            } else if (node instanceof RecordNode && (record = (recordNode = (RecordNode)node).getRecord()).isIgnored()) {
                removeNode = true;
            }
            if (removeNode) {
                parentNode.remove(index);
                nodeStructureChanged = true;
                continue;
            }
            ++index;
        }
        return nodeStructureChanged;
    }
}

