/*
 * Decompiled with CFR 0.152.
 */
package TES4Gecko;

import TES4Gecko.Main;
import TES4Gecko.PluginSubrecord;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DisplaySubrecordDialog
extends JDialog
implements ActionListener {
    public DisplaySubrecordDialog(JDialog parent, PluginSubrecord subrecord) {
        super(parent, "Subrecord Data", true);
        byte[] subrecordData;
        this.setDefaultCloseOperation(2);
        try {
            subrecordData = subrecord.getSubrecordData();
        }
        catch (IOException exc) {
            Main.logException("Exception while getting subrecord data", exc);
            subrecordData = new byte[]{};
        }
        StringBuilder dumpData = new StringBuilder(128 + 3 * subrecordData.length + 6 * (subrecordData.length / 16));
        dumpData.append(String.format("%s subrecord: Data length x'%X'\n", subrecord.getSubrecordType(), subrecordData.length));
        dumpData.append("\n       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F\n");
        StringBuilder dumpHex = new StringBuilder(48);
        StringBuilder dumpLine = new StringBuilder(16);
        for (int i = 0; i < subrecordData.length; i += 16) {
            int offset;
            for (int j = 0; j < 16 && (offset = i + j) != subrecordData.length; ++j) {
                dumpHex.append(String.format(" %02X", subrecordData[offset]));
                if (subrecordData[offset] >= 32 && subrecordData[offset] < 127) {
                    dumpLine.append(new String(subrecordData, offset, 1));
                    continue;
                }
                dumpLine.append(".");
            }
            while (dumpHex.length() < 48) {
                dumpHex.append("   ");
            }
            while (dumpLine.length() < 16) {
                dumpLine.append(" ");
            }
            dumpData.append(String.format("%04X:", i));
            dumpData.append((CharSequence)dumpHex);
            dumpData.append("  *");
            dumpData.append((CharSequence)dumpLine);
            dumpData.append("*");
            if (i + 16 < subrecordData.length) {
                dumpData.append("\n");
            }
            dumpHex.delete(0, 48);
            dumpLine.delete(0, 16);
        }
        JTextArea textArea = new JTextArea(dumpData.toString());
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setVerticalScrollBarPolicy(22);
        JPanel buttonPane = new JPanel();
        buttonPane.setBackground(Main.backgroundColor);
        JButton button = new JButton("Done");
        button.setActionCommand("done");
        button.setHorizontalAlignment(0);
        button.addActionListener(this);
        buttonPane.add(button);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.setOpaque(true);
        contentPane.setBackground(Main.backgroundColor);
        contentPane.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        contentPane.add(scrollPane);
        contentPane.add(Box.createVerticalStrut(15));
        contentPane.add(buttonPane);
        this.setContentPane(contentPane);
    }

    public static void showDialog(JDialog parent, PluginSubrecord subrecord) {
        DisplaySubrecordDialog dialog = new DisplaySubrecordDialog(parent, subrecord);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            String action = ae.getActionCommand();
            if (action.equals("done")) {
                this.setVisible(false);
                this.dispose();
            }
        }
        catch (Throwable exc) {
            Main.logException("Exception while processing action event", exc);
        }
    }
}

