/*
 * Decompiled with CFR 0.152.
 */
package TES4Gecko;

import TES4Gecko.Main;
import TES4Gecko.PluginInfo;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class EditDialog
extends JDialog
implements ActionListener {
    private PluginInfo pluginInfo;
    private Float[] versions;
    private JComboBox versionField;
    private JTextField creatorField;
    private JTextArea summaryField;
    private boolean descriptionUpdated = false;

    public EditDialog(JFrame parent, PluginInfo pluginInfo) {
        super(parent, pluginInfo.getName(), true);
        this.setDefaultCloseOperation(2);
        this.pluginInfo = pluginInfo;
        this.versions = new Float[2];
        this.versions[0] = new Float(0.8f);
        this.versions[1] = new Float(1.0f);
        StringBuilder summary = new StringBuilder(pluginInfo.getSummary());
        int index = 0;
        while ((index = summary.indexOf("\r\n", index)) >= 0) {
            summary.delete(index, index + 1);
            ++index;
        }
        Dimension labelSize = new Dimension(70, 12);
        JPanel versionPane = new JPanel();
        versionPane.setOpaque(false);
        JLabel label = new JLabel("Version: ", 10);
        label.setPreferredSize(labelSize);
        this.versionField = new JComboBox<Float>(this.versions);
        this.versionField.setSelectedItem(new Float(pluginInfo.getVersion()));
        versionPane.add(label);
        versionPane.add(this.versionField);
        JPanel creatorPane = new JPanel();
        creatorPane.setOpaque(false);
        label = new JLabel("Creator: ", 10);
        label.setPreferredSize(labelSize);
        this.creatorField = new JTextField(pluginInfo.getCreator(), 32);
        creatorPane.add(label);
        creatorPane.add(this.creatorField);
        JPanel summaryPane = new JPanel();
        summaryPane.setOpaque(false);
        label = new JLabel("Summary :", 10);
        label.setPreferredSize(labelSize);
        this.summaryField = new JTextArea(summary.toString(), 8, 32);
        this.summaryField.setLineWrap(true);
        this.summaryField.setWrapStyleWord(true);
        this.summaryField.setFont(this.creatorField.getFont());
        JScrollPane scrollPane = new JScrollPane(this.summaryField);
        summaryPane.add(label);
        summaryPane.add(scrollPane);
        JPanel buttonPane = new JPanel();
        buttonPane.setBackground(Main.backgroundColor);
        JButton button = new JButton("Update");
        button.setActionCommand("update");
        button.addActionListener(this);
        buttonPane.add(button);
        button = new JButton("Cancel");
        button.setActionCommand("cancel");
        button.addActionListener(this);
        buttonPane.add(button);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.setOpaque(true);
        contentPane.setBackground(Main.backgroundColor);
        contentPane.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        contentPane.add(creatorPane);
        contentPane.add(summaryPane);
        contentPane.add(versionPane);
        contentPane.add(Box.createVerticalStrut(15));
        contentPane.add(buttonPane);
        this.setContentPane(contentPane);
    }

    public boolean isUpdated() {
        return this.descriptionUpdated;
    }

    public static boolean showDialog(JFrame parent, PluginInfo pluginInfo) {
        EditDialog dialog = new EditDialog(parent, pluginInfo);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.isUpdated();
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            String action = ae.getActionCommand();
            if (action.equals("update")) {
                Float version = (Float)this.versionField.getSelectedItem();
                String creator = this.creatorField.getText();
                StringBuilder summary = new StringBuilder(this.summaryField.getText());
                if (version == null) {
                    version = new Float(0.8f);
                }
                if (creator.length() == 0) {
                    creator = new String("DEFAULT");
                }
                int index = 0;
                while ((index = summary.indexOf("\n", index)) >= 0) {
                    if (index == 0 || summary.charAt(index - 1) != '\r') {
                        summary.insert(index, "\r");
                        index += 2;
                        continue;
                    }
                    ++index;
                }
                this.pluginInfo.setVersion(version.floatValue());
                this.pluginInfo.setCreator(creator);
                this.pluginInfo.setSummary(summary.toString());
                this.descriptionUpdated = true;
                this.setVisible(false);
                this.dispose();
            } else if (action.equals("cancel")) {
                this.setVisible(false);
                this.dispose();
            }
        }
        catch (Throwable exc) {
            Main.logException("Exception while processing action event", exc);
        }
    }
}

