/*
 * Decompiled with CFR 0.152.
 */
package TES4Gecko;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import javax.swing.JFormattedTextField;

public final class EditNumber
extends JFormattedTextField.AbstractFormatter {
    private NumberFormat formatter;
    private boolean integerOnly;

    public EditNumber(boolean integerOnly, boolean useGrouping) {
        this.integerOnly = integerOnly;
        this.formatter = NumberFormat.getNumberInstance();
        this.formatter.setParseIntegerOnly(integerOnly);
        this.formatter.setGroupingUsed(useGrouping);
    }

    public Object stringToValue(String string) throws ParseException {
        int length = string.length();
        if (length == 0) {
            this.setEditValid(false);
            Number value = this.integerOnly ? (Number)new Integer(0) : (Number)new Double(0.0);
            return value;
        }
        ParsePosition pos = new ParsePosition(0);
        Number value = this.formatter.parse(string, pos);
        int index = pos.getIndex();
        if (value == null) {
            this.setEditValid(false);
            throw new ParseException("Unable to parse number", index);
        }
        if (index == length) {
            this.setEditValid(true);
            if (this.integerOnly) {
                value = new Integer(value.intValue());
            } else if (!(value instanceof Double)) {
                value = new Double(value.doubleValue());
            }
            return value;
        }
        double number = value.doubleValue();
        int op = 0;
        while (index < length) {
            char c = string.charAt(index);
            if (c == '+') {
                op = 0;
            } else if (c == '-') {
                op = 1;
            } else if (c == '*') {
                op = 2;
            } else if (c == '/') {
                op = 3;
            } else {
                this.setEditValid(false);
                throw new ParseException("Unrecognized operator", index);
            }
            if (++index == length) {
                this.setEditValid(false);
                throw new ParseException("Trailing operator", index);
            }
            pos.setIndex(index);
            value = this.formatter.parse(string, pos);
            index = pos.getIndex();
            if (value == null) {
                this.setEditValid(false);
                throw new ParseException("Unable to parse number", index);
            }
            switch (op) {
                case 0: {
                    number += value.doubleValue();
                    break;
                }
                case 1: {
                    number -= value.doubleValue();
                    break;
                }
                case 2: {
                    number *= value.doubleValue();
                    break;
                }
                case 3: {
                    number /= value.doubleValue();
                }
            }
        }
        value = this.integerOnly ? (Number)new Integer((int)number) : (Number)new Double(number);
        this.setEditValid(true);
        return value;
    }

    public String valueToString(Object value) throws ParseException {
        if (value == null) {
            this.setEditValid(false);
            return new String();
        }
        if (!(value instanceof Number)) {
            this.setEditValid(false);
            throw new ParseException("Value is not a Number", 0);
        }
        this.setEditValid(true);
        return this.formatter.format(value);
    }
}

