/*
 * Decompiled with CFR 0.152.
 */
package TES4Gecko;

import TES4Gecko.FormInfo;
import TES4Gecko.Main;
import TES4Gecko.Master;
import TES4Gecko.Plugin;
import TES4Gecko.PluginException;
import TES4Gecko.PluginGroup;
import TES4Gecko.PluginNPC;
import TES4Gecko.PluginQuest;
import TES4Gecko.PluginRace;
import TES4Gecko.PluginRecord;
import TES4Gecko.PluginSubrecord;
import TES4Gecko.PluginTopic;
import TES4Gecko.SerializedElement;
import TES4Gecko.StatusDialog;
import TES4Gecko.WorkerDialog;
import TES4Gecko.WorkerTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class GenerateTask
extends WorkerTask {
    private File pluginFile;
    private Plugin plugin;
    private byte[] voiceData;
    private List<PluginRace> raceList;
    private Map<Integer, PluginRace> raceMap;
    private List<PluginNPC> npcList;
    private Map<Integer, PluginNPC> npcMap;
    private List<PluginQuest> questList;
    private Map<Integer, PluginQuest> questMap;
    private List<PluginTopic> topicList;
    private Map<Integer, PluginTopic> topicMap;

    public GenerateTask(StatusDialog statusDialog, File pluginFile) {
        super(statusDialog);
        this.pluginFile = pluginFile;
    }

    public static void generateResponses(JFrame parent, File pluginFile) {
        StatusDialog statusDialog = new StatusDialog(parent, " ", "Generate Responses");
        GenerateTask worker = new GenerateTask(statusDialog, pluginFile);
        statusDialog.setWorker(worker);
        worker.start();
        statusDialog.showDialog();
        if (statusDialog.getStatus() == 1) {
            JOptionPane.showMessageDialog(parent, "Response files generated for " + pluginFile.getName(), "Generate Responses", 1);
        } else {
            JOptionPane.showMessageDialog(parent, "Unable to generate responses for " + pluginFile.getName(), "Generate Responses", 1);
        }
    }

    public void run() {
        boolean completed = false;
        try {
            PluginTopic topic;
            PluginQuest quest;
            PluginNPC npc;
            PluginRace race;
            URL fileURL = Main.class.getResource("Main.class");
            if (fileURL == null) {
                throw new IOException("Unable to locate Main class");
            }
            String filePath = fileURL.getPath();
            int sep = filePath.indexOf(58);
            if (sep < 1) {
                throw new IOException("Main class path is not valid");
            }
            String protocol = filePath.substring(0, sep);
            if (!protocol.equals("file")) {
                throw new IOException("Main class path protocol is not valid");
            }
            sep = filePath.indexOf(33);
            if (sep < 9 || filePath.charAt(5) != '/') {
                throw new IOException("TES4Gecko jar path is not valid");
            }
            String uriString = filePath.substring(0, sep = filePath.lastIndexOf(47, sep));
            URI fileURI = new URI(uriString);
            File voiceFile = new File((filePath = fileURI.getPath().substring(1)) + "/TES4Gecko-Silence.mp3");
            if (!voiceFile.exists() || !voiceFile.isFile()) {
                throw new IOException("'" + voiceFile.getPath() + "' does not exist");
            }
            this.voiceData = new byte[(int)voiceFile.length()];
            FileInputStream in = new FileInputStream(voiceFile);
            in.read(this.voiceData);
            in.close();
            this.plugin = new Plugin(this.pluginFile);
            this.plugin.load(this);
            List<PluginGroup> groupList = this.plugin.getGroupList();
            List<String> masterList = this.plugin.getMasterList();
            Master[] masters = new Master[masterList.size()];
            int index = 0;
            for (String masterName : masterList) {
                File masterFile = new File(this.pluginFile.getParent() + Main.fileSeparator + masterName);
                Master master = new Master(masterFile);
                master.load(this);
                masters[index++] = master;
            }
            this.raceList = new ArrayList<PluginRace>(32);
            this.raceMap = new HashMap<Integer, PluginRace>(32);
            this.npcList = new ArrayList<PluginNPC>(3072);
            this.npcMap = new HashMap<Integer, PluginNPC>(3072);
            this.questList = new ArrayList<PluginQuest>(512);
            this.questMap = new HashMap<Integer, PluginQuest>(512);
            this.topicList = new ArrayList<PluginTopic>(4096);
            this.topicMap = new HashMap<Integer, PluginTopic>(4096);
            this.getStatusDialog().updateMessage("Building cross-reference lists");
            for (PluginGroup group : groupList) {
                String groupRecordType = group.getGroupRecordType();
                List<PluginRecord> recordList = group.getRecordList();
                if (groupRecordType.equals("RACE")) {
                    for (PluginRecord record : recordList) {
                        if (!record.getRecordType().equals("RACE") || record.isIgnored()) continue;
                        if (record.isDeleted()) {
                            race = new PluginRace(record.getFormID());
                            race.setDelete(true);
                        } else {
                            race = this.buildRaceEntry(record);
                        }
                        this.raceList.add(race);
                        this.raceMap.put(new Integer(race.getFormID()), race);
                    }
                    continue;
                }
                if (groupRecordType.equals("NPC_")) {
                    for (PluginRecord record : recordList) {
                        if (!record.getRecordType().equals("NPC_") || record.isIgnored()) continue;
                        if (record.isDeleted()) {
                            npc = new PluginNPC(record.getFormID());
                            npc.setDelete(true);
                        } else {
                            npc = this.buildNPCEntry(record);
                        }
                        this.npcList.add(npc);
                        this.npcMap.put(new Integer(npc.getFormID()), npc);
                    }
                    continue;
                }
                if (groupRecordType.equals("QUST")) {
                    for (PluginRecord record : recordList) {
                        if (!record.getRecordType().equals("QUST") || record.isIgnored()) continue;
                        if (record.isDeleted()) {
                            quest = new PluginQuest(record.getFormID());
                            quest.setDelete(true);
                        } else {
                            quest = this.buildQuestEntry(record);
                        }
                        this.questList.add(quest);
                        this.questMap.put(new Integer(quest.getFormID()), quest);
                    }
                    continue;
                }
                if (!groupRecordType.equals("DIAL")) continue;
                for (PluginRecord record : recordList) {
                    if (!record.getRecordType().equals("DIAL") || record.isIgnored()) continue;
                    if (record.isDeleted()) {
                        topic = new PluginTopic(record.getFormID());
                        topic.setDelete(true);
                    } else {
                        topic = this.buildTopicEntry(record);
                    }
                    this.topicList.add(topic);
                    this.topicMap.put(new Integer(topic.getFormID()), topic);
                }
            }
            for (int masterID = 0; masterID < masters.length; ++masterID) {
                Master master = masters[masterID];
                List<FormInfo> formList = master.getFormList();
                for (FormInfo formInfo : formList) {
                    Integer objFormID;
                    int formID;
                    PluginRecord record;
                    String recordType = formInfo.getRecordType();
                    if (recordType.equals("RACE")) {
                        record = master.getRecord(formInfo.getFormID());
                        race = this.buildRaceEntry(record);
                        formID = race.getFormID() & 0xFFFFFF | masterID << 24;
                        objFormID = new Integer(formID);
                        if (this.raceMap.get(objFormID) != null) continue;
                        this.raceList.add(race);
                        this.raceMap.put(objFormID, race);
                        continue;
                    }
                    if (recordType.equals("NPC_")) {
                        record = master.getRecord(formInfo.getFormID());
                        npc = this.buildNPCEntry(record);
                        formID = npc.getFormID() & 0xFFFFFF | masterID << 24;
                        objFormID = new Integer(formID);
                        if (this.npcMap.get(objFormID) != null) continue;
                        this.npcList.add(npc);
                        this.npcMap.put(objFormID, npc);
                        continue;
                    }
                    if (recordType.equals("QUST")) {
                        record = master.getRecord(formInfo.getFormID());
                        quest = this.buildQuestEntry(record);
                        formID = quest.getFormID() & 0xFFFFFF | masterID << 24;
                        objFormID = new Integer(formID);
                        if (this.questMap.get(objFormID) != null) continue;
                        this.questList.add(quest);
                        this.questMap.put(objFormID, quest);
                        continue;
                    }
                    if (!recordType.equals("DIAL") || this.topicMap.get(objFormID = new Integer(formID = (topic = this.buildTopicEntry(record = master.getRecord(formInfo.getFormID()))).getFormID() & 0xFFFFFF | masterID << 24)) != null) continue;
                    this.topicList.add(topic);
                    this.topicMap.put(objFormID, topic);
                }
            }
            File voiceBase = new File(this.pluginFile.getParent() + Main.fileSeparator + "Sound" + Main.fileSeparator + "Voice" + Main.fileSeparator + this.plugin.getName());
            if (voiceBase.exists()) {
                if (voiceBase.isDirectory()) {
                    this.deleteDirectoryTree(voiceBase);
                } else {
                    voiceBase.delete();
                }
            }
            this.getStatusDialog().updateMessage("Generating response files for " + this.pluginFile.getName());
            for (PluginGroup group : groupList) {
                String groupRecordType = group.getGroupRecordType();
                if (!groupRecordType.equals("DIAL")) continue;
                List<PluginRecord> recordList = group.getRecordList();
                for (PluginRecord record : recordList) {
                    if (!record.getRecordType().equals("GRUP")) continue;
                    PluginGroup infoGroup = (PluginGroup)record;
                    int topicID = infoGroup.getGroupParentID();
                    List<PluginRecord> infoList = infoGroup.getRecordList();
                    for (PluginRecord infoRecord : infoList) {
                        int masterID;
                        if (!infoRecord.getRecordType().equals("INFO") || infoRecord.isIgnored() || infoRecord.isDeleted() || (masterID = infoRecord.getFormID() >>> 24) < masterList.size()) continue;
                        this.createResponseFiles(topicID, infoRecord);
                    }
                }
            }
            completed = true;
        }
        catch (PluginException exc) {
            Main.logException("Plugin Error", exc);
        }
        catch (DataFormatException exc) {
            Main.logException("Compression Error", exc);
        }
        catch (IOException exc) {
            Main.logException("I/O Error", exc);
        }
        catch (InterruptedException exc) {
            WorkerDialog.showMessageDialog(this.getStatusDialog(), "Request canceled", "Interrupted", 0);
        }
        catch (Throwable exc) {
            Main.logException("Exception while generating responses", exc);
        }
        this.getStatusDialog().closeDialog(completed);
    }

    private PluginRace buildRaceEntry(PluginRecord record) throws DataFormatException, IOException, PluginException {
        int raceFormID;
        int maleFormID = raceFormID = record.getFormID();
        int femaleFormID = raceFormID;
        boolean playableRace = false;
        String raceName = null;
        List<PluginSubrecord> subrecordList = record.getSubrecords();
        for (PluginSubrecord subrecord : subrecordList) {
            byte[] subrecordData;
            String subrecordType = subrecord.getSubrecordType();
            if (subrecordType.equals("FULL")) {
                subrecordData = subrecord.getSubrecordData();
                if (subrecordData.length <= 1) continue;
                raceName = new String(subrecordData, 0, subrecordData.length - 1);
                continue;
            }
            if (subrecordType.equals("VNAM")) {
                int formID;
                subrecordData = subrecord.getSubrecordData();
                if (subrecordData.length >= 4 && (formID = SerializedElement.getInteger(subrecordData, 0)) != 0) {
                    maleFormID = formID;
                }
                if (subrecordData.length < 8 || (formID = SerializedElement.getInteger(subrecordData, 4)) == 0) continue;
                femaleFormID = formID;
                continue;
            }
            if (!subrecordType.equals("DATA") || (subrecordData = subrecord.getSubrecordData()).length < 33 || (subrecordData[32] & 1) == 0) continue;
            playableRace = true;
        }
        if (raceName == null) {
            raceName = record.getEditorID();
        }
        return new PluginRace(raceFormID, record.getEditorID(), raceName, playableRace, maleFormID, femaleFormID);
    }

    private PluginNPC buildNPCEntry(PluginRecord record) throws DataFormatException, IOException, PluginException {
        int formID = record.getFormID();
        int raceID = 0;
        boolean female = false;
        List<PluginSubrecord> subrecordList = record.getSubrecords();
        for (PluginSubrecord subrecord : subrecordList) {
            byte[] subrecordData;
            String subrecordType = subrecord.getSubrecordType();
            if (subrecordType.equals("RNAM")) {
                subrecordData = subrecord.getSubrecordData();
                if (subrecordData.length < 4) continue;
                raceID = SerializedElement.getInteger(subrecordData, 0);
                continue;
            }
            if (!subrecordType.equals("ACBS") || (subrecordData = subrecord.getSubrecordData()).length < 1 || (subrecordData[0] & 1) == 0) continue;
            female = true;
        }
        return new PluginNPC(formID, record.getEditorID(), raceID, female);
    }

    private PluginQuest buildQuestEntry(PluginRecord record) {
        return new PluginQuest(record.getFormID(), record.getEditorID());
    }

    private PluginTopic buildTopicEntry(PluginRecord record) {
        return new PluginTopic(record.getFormID(), record.getEditorID());
    }

    private void createResponseFiles(int topicID, PluginRecord infoRecord) throws DataFormatException, IOException, PluginException {
        String text;
        String text2;
        List<PluginSubrecord> subrecordList = infoRecord.getSubrecords();
        int infoID = infoRecord.getFormID() & 0xFFFFFF;
        int responseCount = 0;
        int questID = 0;
        int npcID = 0;
        int raceID = 0;
        for (PluginSubrecord subrecord : subrecordList) {
            byte[] subrecordData;
            String subrecordType = subrecord.getSubrecordType();
            if (subrecordType.equals("QSTI")) {
                subrecordData = subrecord.getSubrecordData();
                questID = SerializedElement.getInteger(subrecordData, 0);
                continue;
            }
            if (subrecordType.equals("CTDA")) {
                subrecordData = subrecord.getSubrecordData();
                int code = SerializedElement.getInteger(subrecordData, 8);
                if (subrecordData[0] != 0 || code != 72 && code != 69) continue;
                int bits = SerializedElement.getInteger(subrecordData, 4);
                float value = Float.intBitsToFloat(bits);
                int formID = SerializedElement.getInteger(subrecordData, 12);
                if ((double)value != 1.0) continue;
                if (code == 72) {
                    npcID = formID;
                    continue;
                }
                raceID = formID;
                continue;
            }
            if (!subrecordType.equals("TRDT")) continue;
            ++responseCount;
        }
        if (responseCount == 0 || questID == 0) {
            return;
        }
        PluginTopic topic = this.topicMap.get(new Integer(topicID));
        if (topic == null) {
            text2 = String.format("Topic %08X not found", new Object[0]);
            throw new PluginException(text2);
        }
        if (topic.isDeleted()) {
            text2 = String.format("Topic %08X is deleted", topicID);
            throw new PluginException(text2);
        }
        String topicName = topic.getEditorID();
        PluginQuest quest = this.questMap.get(new Integer(questID));
        if (quest == null) {
            text = String.format("Quest %08X not found for dialog topic %s", questID, topicName);
            throw new PluginException(text);
        }
        if (quest.isDeleted()) {
            text = String.format("Quest %08X is deleted", questID);
            throw new PluginException(text);
        }
        String questName = quest.getEditorID();
        if (npcID != 0) {
            PluginNPC npc = this.npcMap.get(new Integer(npcID));
            if (npc == null) {
                String text3 = String.format("NPC %08X not found for dialog topic %s", npcID, topicName);
                throw new PluginException(text3);
            }
            if (npc.isDeleted()) {
                String text4 = String.format("NPC %08X is deleted", npcID);
                throw new PluginException(text4);
            }
            raceID = npc.getRaceID();
            PluginRace race = this.raceMap.get(new Integer(raceID));
            if (race == null) {
                String text5 = String.format("Race %08X not found for NPC %s", raceID, npc.getEditorID());
                throw new PluginException(text5);
            }
            if (race.isDeleted()) {
                String text6 = String.format("Race %08X is deleted", raceID);
                throw new PluginException(text6);
            }
            this.copyVoiceData(questName, topicName, infoID, race, npc.isFemale(), responseCount);
        } else if (raceID != 0) {
            PluginRace race = this.raceMap.get(new Integer(raceID));
            if (race == null) {
                String text7 = String.format("Race %08X not found for dialog topic %s", raceID, topicName);
                throw new PluginException(text7);
            }
            if (race.isDeleted()) {
                String text8 = String.format("Race %08X is deleted", raceID);
                throw new PluginException(text8);
            }
            this.copyVoiceData(questName, topicName, infoID, race, false, responseCount);
            this.copyVoiceData(questName, topicName, infoID, race, true, responseCount);
        } else {
            for (PluginRace race : this.raceList) {
                if (!race.isPlayableRace() || race.isDeleted()) continue;
                this.copyVoiceData(questName, topicName, infoID, race, false, responseCount);
                this.copyVoiceData(questName, topicName, infoID, race, true, responseCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyVoiceData(String questName, String topicName, int infoID, PluginRace race, boolean female, int count) throws IOException, PluginException {
        int voiceID = female ? race.getFemaleVoiceID() : race.getMaleVoiceID();
        PluginRace voiceRace = this.raceMap.get(new Integer(voiceID));
        if (voiceRace == null) {
            String text = String.format("Voice race %08X not found for race %s", voiceID, race.getName());
            throw new PluginException(text);
        }
        if (voiceRace.isDeleted()) {
            String text = String.format("Voice race %08X is deleted", voiceID);
            throw new PluginException(text);
        }
        String filePath = String.format("%s\\Sound\\Voice\\%s\\%s\\%s", this.pluginFile.getParent(), this.plugin.getName(), voiceRace.getName(), female ? "F" : "M");
        File voiceDirectory = new File(filePath);
        if (!voiceDirectory.exists()) {
            voiceDirectory.mkdirs();
        }
        for (int response = 1; response <= count; ++response) {
            String fileName = String.format("%s_%s_%08X_%d.mp3", questName, topicName, infoID, response);
            File voiceFile = new File(filePath + "\\" + fileName);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(voiceFile);
                out.write(this.voiceData);
                continue;
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    private void deleteDirectoryTree(File directory) {
        File[] files;
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                this.deleteDirectoryTree(file);
                continue;
            }
            file.delete();
        }
        directory.delete();
    }
}

