/*
 * Decompiled with CFR 0.152.
 */
package TES4Gecko;

import TES4Gecko.Main;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class PluginDialog
extends JDialog
implements ActionListener {
    private String[] pluginNames;
    private String[] columnNames = new String[]{"Priority", "Plugin"};
    private Class<?>[] columnClasses = new Class[]{Integer.class, String.class};
    private PluginTableModel tableModel;
    private JTable table;
    private JScrollPane scrollPane;

    public PluginDialog(JFrame parent) {
        super(parent, "Select Plugins", true);
        this.setDefaultCloseOperation(2);
        String pluginDirectory = Main.properties.getProperty("plugin.directory");
        this.tableModel = new PluginTableModel(pluginDirectory);
        this.table = new JTable(this.tableModel);
        this.table.setCellSelectionEnabled(true);
        this.table.setSelectionMode(0);
        this.table.setAutoResizeMode(3);
        TableCellRenderer headRenderer = this.table.getTableHeader().getDefaultRenderer();
        if (headRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)headRenderer).setHorizontalAlignment(0);
        }
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(50);
        columnModel.getColumn(1).setPreferredWidth(350);
        TableCellRenderer renderer = (DefaultTableCellRenderer)columnModel.getColumn(1).getCellRenderer();
        if (renderer == null) {
            renderer = this.table.getDefaultRenderer(this.columnClasses[1]);
        }
        renderer.setBackground(Main.backgroundColor);
        this.scrollPane = new JScrollPane(this.table);
        JPanel buttonPane = new JPanel();
        buttonPane.setBackground(Main.backgroundColor);
        JButton button = new JButton("OK");
        button.setActionCommand("done");
        button.addActionListener(this);
        buttonPane.add(button);
        button = new JButton("Cancel");
        button.setActionCommand("cancel");
        button.addActionListener(this);
        buttonPane.add(button);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setOpaque(true);
        contentPane.setBackground(Main.backgroundColor);
        contentPane.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        contentPane.add((Component)new JLabel("<html><b>Set the merge priority for two or more plugins.  Plugins with a blank or zero priority will not merged.</b><br><br></html>"), "North");
        contentPane.add((Component)this.scrollPane, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.setContentPane(contentPane);
    }

    public String[] getPluginNames() {
        return this.pluginNames;
    }

    public static String[] showDialog(JFrame parent) {
        PluginDialog dialog = new PluginDialog(parent);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.getPluginNames();
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            boolean doAction = true;
            if (this.table.isEditing() && !this.table.getCellEditor().stopCellEditing()) {
                doAction = false;
            }
            if (doAction) {
                String action = ae.getActionCommand();
                if (action.equals("done")) {
                    int rows = this.tableModel.getRowCount();
                    ArrayList<PluginTableEntry> entryList = new ArrayList<PluginTableEntry>(rows);
                    for (int row = 0; row < rows; ++row) {
                        PluginTableEntry checkEntry;
                        PluginTableEntry entry = this.tableModel.getPluginTableEntry(row);
                        int priority = entry.getMergePriority();
                        if (priority <= 0) continue;
                        int index = 0;
                        Iterator i$ = entryList.iterator();
                        while (i$.hasNext() && priority >= (checkEntry = (PluginTableEntry)i$.next()).getMergePriority()) {
                            ++index;
                        }
                        entryList.add(index, entry);
                    }
                    int count = entryList.size();
                    if (count < 2) {
                        JOptionPane.showMessageDialog(this, "You must select at least two plugins to merge", "Error", 0);
                    } else {
                        this.pluginNames = new String[count];
                        int index = 0;
                        for (PluginTableEntry entry : entryList) {
                            this.pluginNames[index++] = entry.getPluginName();
                        }
                        this.setVisible(false);
                        this.dispose();
                    }
                } else if (action.equals("cancel")) {
                    this.setVisible(false);
                    this.dispose();
                }
            }
        }
        catch (Throwable exc) {
            Main.logException("Exception while processing action event", exc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PluginTableModel
    extends AbstractTableModel {
        private List<PluginTableEntry> tableData = new ArrayList<PluginTableEntry>();

        public PluginTableModel(String pluginDirectory) {
            File[] fileList;
            File directory;
            if (pluginDirectory != null && pluginDirectory.length() != 0 && (directory = new File(pluginDirectory)).isDirectory() && (fileList = directory.listFiles(new PluginMergeFilter())) != null && fileList.length != 0) {
                for (File file : fileList) {
                    long lastModified = file.lastModified();
                    int index = 0;
                    for (PluginTableEntry entry : this.tableData) {
                        if (lastModified < entry.getLastModified()) break;
                        ++index;
                    }
                    this.tableData.add(index, new PluginTableEntry(file.getName(), lastModified));
                }
            }
        }

        @Override
        public int getColumnCount() {
            return PluginDialog.this.columnNames.length;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return PluginDialog.this.columnClasses[column];
        }

        @Override
        public String getColumnName(int column) {
            return PluginDialog.this.columnNames[column];
        }

        @Override
        public int getRowCount() {
            return this.tableData.size();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row >= this.tableData.size()) {
                throw new IndexOutOfBoundsException("Table row " + row + " is not valid");
            }
            Object value = null;
            PluginTableEntry entry = this.tableData.get(row);
            switch (column) {
                case 0: {
                    int priority = entry.getMergePriority();
                    if (priority <= 0) break;
                    value = new Integer(priority);
                    break;
                }
                case 1: {
                    value = entry.getPluginName();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException("Table column " + column + " is not valid");
                }
            }
            return value;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row >= this.tableData.size()) {
                throw new IndexOutOfBoundsException("Table row " + row + " is not valid");
            }
            if (column == 0) {
                int priority;
                if (value == null) {
                    priority = 0;
                } else {
                    priority = (Integer)value;
                    if (priority < 1) {
                        priority = 0;
                    }
                }
                this.tableData.get(row).setMergePriority(priority);
                this.fireTableCellUpdated(row, column);
            }
        }

        public PluginTableEntry getPluginTableEntry(int row) {
            if (row >= this.tableData.size()) {
                throw new IndexOutOfBoundsException("Table row " + row + " is not valid");
            }
            return this.tableData.get(row);
        }
    }

    private class PluginMergeFilter
    implements FileFilter {
        public boolean accept(File file) {
            String fileName;
            int sep;
            boolean acceptFile = false;
            if (file.isFile() && (sep = (fileName = file.getName()).lastIndexOf(46)) > 0 && fileName.substring(sep).equalsIgnoreCase(".esp")) {
                acceptFile = true;
            }
            return acceptFile;
        }
    }

    private class PluginTableEntry {
        private String pluginName;
        private long lastModified;
        private int mergePriority;

        public PluginTableEntry(String pluginName, long lastModified) {
            this.pluginName = pluginName;
            this.lastModified = lastModified;
            this.mergePriority = 0;
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public int getMergePriority() {
            return this.mergePriority;
        }

        public void setMergePriority(int priority) {
            this.mergePriority = priority;
        }
    }
}

