/*
 * Decompiled with CFR 0.152.
 */
package TES4Gecko;

import java.io.File;
import java.io.FileFilter;

public class PluginFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private boolean selectMasterFiles;
    private boolean selectPluginFiles;
    private boolean selectPatchFiles;

    public PluginFileFilter() {
        this.selectMasterFiles = true;
        this.selectPluginFiles = true;
        this.selectPatchFiles = true;
    }

    public PluginFileFilter(boolean selectMasterFiles) {
        this.selectMasterFiles = selectMasterFiles;
        this.selectPluginFiles = !selectMasterFiles;
        this.selectPatchFiles = false;
    }

    public PluginFileFilter(boolean selectMasterFiles, boolean selectPluginFiles, boolean selectPatchFiles) {
        this.selectMasterFiles = selectMasterFiles;
        this.selectPluginFiles = selectPluginFiles;
        this.selectPatchFiles = selectPatchFiles;
    }

    public String getDescription() {
        String text = null;
        if (this.selectMasterFiles) {
            text = "TES Files (*.esm";
        }
        if (this.selectPluginFiles) {
            text = text == null ? "TES Files (*.esp" : text.concat(", *.esp");
        }
        if (this.selectPatchFiles) {
            text = text == null ? "TES Files (*.esu" : text.concat(", *.esu");
        }
        return text.concat(")");
    }

    public boolean accept(File file) {
        boolean accept = false;
        if (!file.isFile()) {
            accept = true;
        } else {
            String name = file.getName();
            int sep = name.lastIndexOf(46);
            if (sep > 0) {
                if (name.substring(sep).equalsIgnoreCase(".esm")) {
                    if (this.selectMasterFiles) {
                        accept = true;
                    }
                } else if (name.substring(sep).equalsIgnoreCase(".esp")) {
                    if (this.selectPluginFiles) {
                        accept = true;
                    }
                } else if (name.substring(sep).equalsIgnoreCase(".esu") && this.selectPatchFiles) {
                    accept = true;
                }
            }
        }
        return accept;
    }
}

